<?php
/**
 # mod_megamininews - Mega Mini News Module for Joomla! 1.5
 # author 		OmegaTheme.com
 # copyright 	Copyright(C) 2011 - OmegaTheme.com. All Rights Reserved.
 # @license 	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 # Website: 	http://omegatheme.com
 # Technical support: Forum - http://omegatheme.com/forum/
**/
/**------------------------------------------------------------------------
 * file: helper.php 1.5.0 00001, April 2011 12:00:00Z OmegaTheme $
 * package:	Mega Mini News Module
 *------------------------------------------------------------------------*/
//No direct access!
defined('_JEXEC') or die ('Restricted access');
require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
class modMegaMiniNewsHelper{
	function getList(&$params)
	{
		global $mainframe;

		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();

		$count		= (int) $params->get('count', 5);
		$catid		= trim( $params->get('catid') );
		$aid		= $user->get('aid', 0);
		
		$order		    = $params->get( 'order', 0);
		$order_type	  = $params->get( 'order_type', 'asc');
		
		$show_date = $params->get('show_date', 1);
		$contentConfig = &JComponentHelper::getParams( 'com_content' );

		$nullDate	= $db->getNullDate();
		$date =& JFactory::getDate();
		$now = $date->toMySQL();

		$where		= 'a.state = 1'
			. ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )'
			. ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'
			;
		
		// Ordering
		switch ($params->get( 'ordering' ))
		{
			case 'm_dsc':
				$ordering		= 'a.modified DESC, a.created DESC';
				break;
			case 'c_dsc':
			default:
				$ordering		= 'a.created DESC';
				break;
		}

		if ($catid)
		{
			$ids = explode( ',', $catid );
			JArrayHelper::toInteger( $ids );
			$catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $ids ) . ')';
		}
		if ($secid)
		{
			$ids = explode( ',', $secid );
			JArrayHelper::toInteger( $ids );
			$secCondition = ' AND (s.id=' . implode( ' OR s.id=', $ids ) . ')';
		}

		// Content Items only
		$query = 'SELECT a.*, ' .
			' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
			' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug'.
			' FROM #__content AS a' .
			($show_front == '0' ? ' LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') .
			' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
			' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
			' WHERE '. $where .' AND s.id > 0' .
			($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
			($catid ? $catCondition : '').
			($secid ? $secCondition : '').
			($show_front == '0' ? ' AND f.content_id IS NULL ' : '').
			' AND s.published = 1' .
			' AND cc.published = 1' .
			' ORDER BY '. $ordering;
		$db->setQuery($query, 0, $count);
		$rows = $db->loadObjectList();
		
		$i		= 0;
		$lists	= array();
		
		foreach ( $rows as $row ){
			$lists[$i]->link = JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid));
			$lists[$i]->title = htmlspecialchars( $row->title );			
			$lists[$i]->ct= strip_tags(preg_replace('/<img([^>]+)>/i',"",$row->introtext));//load introtext and remove images in introtext
			$lists[$i]->content = substr($lists[$i]->ct, 0, $params->get('numberdisplay'));// show count from introtext on text numberdisolay
			preg_match_all('/src="([^"]+)"/i', $row->introtext . $row->fulltext, $matches);// load images first on introtex or fulltext
			if(empty($matches[1][0])){
				$lists[$i]->im="";
			}else{
				$lists[$i]->im= $matches [1] [0];
			}
			
			if($params->get('showthumbnails')==1){
				$lists[$i]->images = '<img src="' .$lists[$i]->im.'" width="'.$params->get('thumbwidth').'" height="'.$params->get('thumbheight').'" alt="'.$row->title.'" />'  ;    //show images
			}else{
				$lists[$i]->images="";
			}
			if(($params->get('showthumbnailsdefault')==1) && ($params->get('showthumbnails')==1) && empty($lists[$i]->im)){// if images null then default images
				$lists[$i]->images = '<img src="'.$params->get('directorydefault').'" width="'.$params->get('thumbwidth').'" height="'.$params->get('thumbheight').'"alt="'.$row->title.'" />';
			}
			$lists[$i]->created_date= $row->created;
			$i++;
		}
		return $lists;
	}
}
?>