<?php

// basic settings

$custom_css = "{$nmParam["themeGroup"]}_{$nmParam["color"]}.css";
$skin_dir = SM_PATH . "skins/{$nmParam["themeGroup"]}_" . $nmParam["color"];

// theme hooks

if (isset($nmParam['version'])) // version 3.8 or above
{
	global $squirrelmail_plugin_hooks;
	$squirrelmail_plugin_hooks['optpage_loadhook_display']['nm_' . $nmParam["themeGroup"]] = 'nmOptions';
}

function nmHook($place)
{
	if ($place == "htmlHeaderEnd")
		echo nmGetHeader();
}

// add to header

function nmGetHeader()
{
	global $skin_dir, $config_version, $nmParam, $org_title, $username, $data_dir;

	$smv = isset($nmParam['smVersion']) ? $nmParam['smVersion'] : "1.4.21";

	$nmVersion = "NutsMail version: {$nmParam['version']}";
	$smVersion = "SquirrelMail version: $smv";
	$organizationName = htmlentities($org_title, ENT_QUOTES);	
	
  $disableEffects = $username ? (int)getPref($data_dir, $username, 'nm_disable_effects') : 0;	
	$hideBody = $disableEffects ? "" : "<style> body { display: none; } </style>";

	return <<<END
<script type="text/javascript" src="$skin_dir/backgroundPosition.js"></script> 
<script type="text/javascript" src="$skin_dir/functions.min.js"></script> 
$hideBody
<script type="text/javascript">
$(document).ready(function(){
	showPage("$organizationName", $disableEffects);
	setupVersionBox("$smVersion", "$nmVersion", "{$nmParam['themeName']}", "{$nmParam['themeVersion']}"); 
	removeMailCountParentheses();
	setupMenuEffects("{$nmParam['color']}", $disableEffects);
});
</script>
END;
}

// add to options

function nmOptions() 
{
	global $optpage_data, $username, $data_dir, $nm_disable_effects, $nmParam;
	$nm_disable_effects = getPref($data_dir, $username, 'nm_disable_effects');
	
	// [0] - add to the general display options section
	$optpage_data['vals'][0][] = array(
		'name' => 'nm_disable_effects',
		'caption' => _("Disable theme's visual effects"),
		'type' => SMOPT_TYPE_BOOLEAN,
		'refresh' => SMOPT_REFRESH_ALL
	);
}