<?php

/**
 * signout.php -- cleans up session and logs the user out
 *
 *  Cleans up after the user. Resets cookies and terminates session.
 *
 * @copyright 1999-2010 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: signout.php 13893 2010-01-25 02:47:41Z pdontthink $
 * @package squirrelmail
 */

/** This is the signout page */
define('PAGE_NAME', 'signout');

/**
 * Path for SquirrelMail required files.
 * @ignore
 */
define('SM_PATH','../');

require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/prefs.php');
require_once(SM_PATH . 'functions/plugin.php');
require_once(SM_PATH . 'functions/strings.php');
require_once(SM_PATH . 'functions/html.php');

/* Erase any lingering attachments */
sqgetGlobalVar('compose_messages',  $compose_messages,  SQ_SESSION);
if (!empty($compose_messages) && is_array($compose_messages)) {
    foreach($compose_messages as $composeMessage) {
        $composeMessage->purgeAttachments();
    }
}

if (!isset($frame_top)) {
    $frame_top = '_top';
}

/* If a user hits reload on the last page, $base_uri isn't set
 * because it was deleted with the session. */
if (! sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION) ) {
    require_once(SM_PATH . 'functions/display_messages.php');
}

do_hook('logout');

sqsession_destroy();

if ($signout_page) {
    // Status 303 header is disabled. PHP fastcgi bug. See 1.91 changelog.
    //header('Status: 303 See Other');
    header("Location: $signout_page");
    exit; /* we send no content if we're redirecting. */
}

/* internal gettext functions will fail, if language is not set */
set_up_language($squirrelmail_language, true, true);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<?php
if (function_exists("nmHook"))
	nmHook("logoutHeaderStart");
?>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="robots" content="noindex,nofollow">
<?php
    if ($theme_css != '') {
?>
   <link rel="stylesheet" type="text/css" href="<?php echo $theme_css; ?>" />
<?php   $cssfile = substr($custom_css, 0, -4);

    echo "<!--[if lte IE 6]>\n";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . "themes/css/".$cssfile."_ie.css\" />\n";
    echo "<![endif]-->\n";

    echo "<!--[if gte IE 7]>\n";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . "themes/css/".$cssfile."_ie7.css\" />\n";
    echo "<![endif]-->\n";
    }
$plugin_message = concat_hook_function('logout_above_text');
?>
   <title><?php echo $org_title . ' - ' . _("Signout"); ?></title>
<?php
if (function_exists("nmHook"))
	nmHook("logoutHeaderEnd");
?>
</head>
<body id="login_bg">

<div id="logout_container">
<div id="logout">
  <h1><?php echo _("Webmail")."&nbsp;<span>"._("Signout"); ?></span></h1>
  <p class="signedout"><?php echo _("You have been successfully signed out."); ?></p>
  <p class="login"><a href="../src/login.php" target="<?php echo $frame_top; ?>"><?php echo _("Click here to log back in."); ?></a></p>
</div>
</div>

</body>
</html>
