<?php

/**
 * login.php -- simple login screen
 *
 * This a simple login screen. Some housekeeping is done to clean
 * cookies and find language.
 *
 * @copyright 1999-2010 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: login.php 13946 2010-06-21 00:43:54Z pdontthink $
 * @package squirrelmail
 */

/** This is the login page */
define('PAGE_NAME', 'login');

/**
 * Path for SquirrelMail required files.
 * @ignore
 */
define('SM_PATH','../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'functions/global.php');
require_once(SM_PATH . 'functions/i18n.php');
require_once(SM_PATH . 'functions/plugin.php');
require_once(SM_PATH . 'functions/constants.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'functions/html.php');
require_once(SM_PATH . 'functions/forms.php');

/**
 * $squirrelmail_language is set by a cookie when the user selects
 * language and logs out
 */
set_up_language($squirrelmail_language, TRUE, TRUE);

/**
 * In case the last session was not terminated properly, make sure
 * we get a new one, but make sure we preserve session_expired_*
 */
$sep = '';
$sel = '';
sqGetGlobalVar('session_expired_post', $sep, SQ_SESSION);
sqGetGlobalVar('session_expired_location', $sel, SQ_SESSION);

/* blow away session */
sqsession_destroy();

/**
 * in some rare instances, the session seems to stick
 * around even after destroying it (!!), so if it does,
 * we'll manually flatten the $_SESSION data
 */
if (!empty($_SESSION)) {
    $_SESSION = array();
}

/**
 * Allow administrators to define custom session handlers
 * for SquirrelMail without needing to change anything in
 * php.ini (application-level).
 *
 * In config_local.php, admin needs to put:
 *
 *     $custom_session_handlers = array(
 *         'my_open_handler',
 *         'my_close_handler',
 *         'my_read_handler',
 *         'my_write_handler',
 *         'my_destroy_handler',
 *         'my_gc_handler',
 *     );
 *     session_module_name('user');
 *     session_set_save_handler(
 *         $custom_session_handlers[0],
 *         $custom_session_handlers[1],
 *         $custom_session_handlers[2],
 *         $custom_session_handlers[3],
 *         $custom_session_handlers[4],
 *         $custom_session_handlers[5]
 *     );
 * 
 * We need to replicate that code once here because PHP has
 * long had a bug that resets the session handler mechanism
 * when the session data is also destroyed.  Because of this
 * bug, even administrators who define custom session handlers
 * via a PHP pre-load defined in php.ini (auto_prepend_file)
 * will still need to define the $custom_session_handlers array 
 * in config_local.php.
 */
global $custom_session_handlers;
if (!empty($custom_session_handlers)) {
    $open    = $custom_session_handlers[0];
    $close   = $custom_session_handlers[1];
    $read    = $custom_session_handlers[2];
    $write   = $custom_session_handlers[3];
    $destroy = $custom_session_handlers[4];
    $gc      = $custom_session_handlers[5];
    session_module_name('user');
    session_set_save_handler($open, $close, $read, $write, $destroy, $gc);
}

/* put session_expired_* variables back in session */
sqsession_is_active();
if (!empty($sel)) {
    sqsession_register($sel, 'session_expired_location');
    if (!empty($sep)) 
        sqsession_register($sep, 'session_expired_post');
}

// Disable Browser Caching
//
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: Sat, 1 Jan 2000 00:00:00 GMT');

do_hook('login_cookie');

$loginname_value = (sqGetGlobalVar('loginname', $loginname) ? htmlspecialchars($loginname) : '');

/* Output the javascript onload function. */

$header = "<script language=\"JavaScript\" type=\"text/javascript\">\n" .
          "<!--\n".
          "  var alreadyFocused = false;\n".
          "  function squirrelmail_loginpage_onload() {\n".
          "    document.login_form.js_autodetect_results.value = '" . SMPREF_JS_ON . "';\n".
          "    if (alreadyFocused) return;\n".
          "    var textElements = 0;\n".
          "    for (i = 0; i < document.login_form.elements.length; i++) {\n".
          "      if (document.login_form.elements[i].type == \"text\" || document.login_form.elements[i].type == \"password\") {\n".
          "        textElements++;\n".
          "        if (textElements == " . (isset($loginname) ? 2 : 1) . ") {\n".
          "          document.login_form.elements[i].focus();\n".
          "          break;\n".
          "        }\n".
          "      }\n".
          "    }\n".
          "  }\n".
          "// -->\n".
          "</script>\n";
$custom_css = 'none';

// Load default theme if possible
if (@file_exists($theme[$theme_default]['PATH']))
   @include ($theme[$theme_default]['PATH']);
  
displayHtmlHeader( "$org_name - " . _("Login"), $header, FALSE );
echo '<body id="login_bg" text="#000000" bgcolor="#FFFFFF" link="#0000CC" vlink="#0000CC" alink="#0000CC" onLoad="squirrelmail_loginpage_onload();">' .
     "\n" . '<div id="login_wrap">' . addForm('redirect.php', 'post', 'login_form');

$cssfile = substr($custom_css, 0, -4);
$fancyLogin = false;

if ($cssfile == "iWood" || ($cssfile == "iViola") || ($cssfile == "iClassic") || ($cssfile == "iSpruce")) {
	$fancyLogin = true;
} else {
	$fancyLogin = false;
}
if ($fancyLogin == true) {
	echo '<script type="text/javascript" src="'.SM_PATH . 'functions/login.js"></script>';
}
$username_form_name = 'login_username';
$password_form_name = 'secretkey';
do_hook('login_top');


if(sqgetGlobalVar('mailtodata', $mailtodata)) {
    $mailtofield = addHidden('mailtodata', $mailtodata);
} else {
    $mailtofield = '';
}

/* If they don't have a logo, don't bother.. */
if (isset($org_logo) && $org_logo) {
    /* Display width and height like good little people */
    $width_and_height = '';
    if (isset($org_logo_width) && is_numeric($org_logo_width) &&
     $org_logo_width>0) {
        $width_and_height = " width=\"$org_logo_width\"";
    }
    if (isset($org_logo_height) && is_numeric($org_logo_height) &&
     $org_logo_height>0) {
        $width_and_height .= " height=\"$org_logo_height\"";
    }
}

?>
<div id="login_container"> 
  <h1 id="login_h1"><?php echo _("WebMail")."&nbsp;<span>"._("Login")."</span>"; ?></h1>
  <?php
  if (isset($org_logo) && $org_logo) { echo '<img src="' . $org_logo . '" alt="' . sprintf(_("%s Logo"), $org_name) .'"' . $width_and_height . 'id="login_logo" />' . "\n"; }?>
  <fieldset id="login_fieldset">
	<div class="login-input-wrap">
  		<label for="<?php echo $username_form_name; ?>" class="login_user" id="user-label">
  			<span><?php echo _("Username:"); ?></span>
		</label>
  		<?php echo "<input type=\"text\" name=\"$username_form_name\" value=\"$loginname_value\" tabindex=\"1\" class=\"login_input\" onfocus=\"alreadyFocused=true;\" id=\"username\">"; ?>
	</div><br />
	<div class="login-input-wrap">
		<label for="<?php echo $password_form_name; ?>" class="login_user" id="pw-label">
			<span><?php echo _("Password:"); ?></span>
		</label>	
  		<input name="<?php echo $password_form_name; ?>" type="password" class="login_input"  tabindex="2" onfocus="alreadyFocused=true;" id="password">
	</div>
  <input type="hidden" name="js_autodetect_results" value="SMPREF_JS_OFF">
  <input type="hidden" name="just_logged_in" value="1">
  <input name="button" type="submit" value="<?php echo _("Login"); ?>" class="login_button">
  <?php do_hook('login_form'); ?>
  </fieldset>
  <div id="login_copyright"> 
		<p><?php echo _("Supported by "); ?> <a href="http://www.powerlearn.uk.com" target="_blank" style="text-decoration: none;" title="PowerLearn Systems">PowerLearn Systems</a>.</p>
  </div>
</div>
</form>

<?php

do_hook('login_bottom');
?>
</div>
</body></html>
