<?php
/********************************************************
  NutsMail Global Configuration Setup
	Copyright (c) 2010 NutsMail	(http://nutsmail.com)
	Programming: Chris Kulbacki (http://chriskulbacki.com)
*********************************************************/

class NmSetup
{
	private $themes = array();
	private $supportedLanguages = array('bg_BG'=>'Bulgarian', 'bn_BD'=>'Bengali (Bangladesh)', 'bn_IN'=>'Bengali (India)', 'ca_ES'=>'Catalan', 'cs_CZ'=>'Czech', 'cy_GB'=>'Welsh', 'da_DK'=>'Danish', 'de_DE'=>'German', 'el_GR'=>'Greek', 'en_US'=>'English', 'es_ES'=>'Spanish', 'et_EE'=>'Estonian', 'eu_ES'=>'Basque', 'fi_FI'=>'Finnish', 'fo_FO'=>'Faroese', 'fr_FR'=>'French', 'fy'=>'Frisian', 'hr_HR'=>'Croatian', 'hu_HU'=>'Hungarian', 'id_ID'=>'Bahasa Indonesia', 'is_IS'=>'Icelandic', 'it_IT'=>'Italian', 'ja_JP'=>'Japanese', 'ka'=>'Georgian', 'km'=>'Khmer', 'ko_KR'=>'Korean', 'lv_LV'=>'Latvian', 'lt_LT'=>'Lithuanian', 'mk'=>'Macedonian', 'ms_MY'=>'Bahasa Melayu', 'nl_NL'=>'Dutch', 'nb_NO'=>'Norwegian (Bokm&aring;l)', 'nn_NO'=>'Norwegian (Nynorsk)', 'pl_PL'=>'Polish', 'pt_PT'=>'Portuguese (Portugal)', 'pt_BR'=>'Portuguese (Brazil)', 'ro_RO'=>'Romanian', 'ru_RU'=>'Russian', 'sk_SK'=>'Slovak', 'sl_SI'=>'Slovenian', 'sr_YU'=>'Serbian', 'sv_SE'=>'Swedish', 'ta_LK'=>'Tamil', 'tr_TR'=>'Turkish', 'zh_TW'=>'Chinese Trad', 'zh_CN'=>'Chinese Simp', 'uk_UA'=>'Ukrainian', 'vi_VN'=>'Vietnamese', 'ar'=>'Arabic', 'fa_IR'=>'Persian', 'he_IL'=>'Hebrew', 'ug'=>'Uighur');
	private $dataDir;
	private $attachDir;
	private $configVersion = false;
	private $themeFile = "";
	private $themeFileMobile = "";

	function __construct()
	{
	}

	function checkWritableFile($fileName, &$errorText, $entity = "file")
	{
		if (!is_writable($fileName))
		{
			$errorText .= $this->getErrorCode("The $entity '$fileName' is not writable. Please change the $entity permissions to allow the program to write to it.");
			return false;
		}
		return true;
	}

	function checkDeleteFile($fileName, &$errorText)
	{
		if (file_exists($fileName) && !@unlink($fileName))
		{
			$errorText .= $this->getErrorCode("The file '$fileName' is not necessary with the new version of NutsMail and should be deleted. Please delete the file manually or change the file permissions to allow the program to delete it.");
			return false;
		}
		return true;

	}

	function checkFolders(&$errorText, &$tryAgainCode)
	{
		$dataOk = file_exists($this->getDataDir() . "default_pref");
		$attachOk = is_dir($this->getAttachDir());

		if ($dataOk && $attachOk)
			return true;

		$tryAgainCode = "document.nmForm.submit()";
		$errorText .=
			"<form name='nmForm' action='' method='post'>".
			"<input type='hidden' name='folderError' value='true' />";

		if (!$dataOk)
			$errorText .= $this->getErrorCode("Data directory: The setup cannot find the file '" . $this->getDataDir(true) . "default_pref'. If you have moved your data directory to a different location, specify the new location below.<br /><br />".
				"Data directory: <input style='width:300px' type='text' name='data_dir' value='" . $this->v($this->dataDir) . "' />");

		if (!$attachOk)
			$errorText .= $this->getErrorCode("Attachment directory: The setup cannot find the folder '" . $this->getAttachDir(true) . "'. If you have moved your attachment directory to a different location, specify the new location below.<br /><br />".
				"Attachment directory: <input style='width:300px' type='text' name='attachment_dir' value='" . $this->v($this->attachDir) . "' />");

		$errorText .= "</form>";

		return false;
	}

	function upgradeConfig()
	{
		// if config_local.php exists, merge it into config.php and cleanup config.php so there are no duplicate variables

		if (!file_exists(SM_PATH . "config/config_local.php") || !is_writable(SM_PATH . "config/config.php"))
			return;

		$contents = @file_get_contents(SM_PATH . "config/config.php");
		if (!$contents)
			return;

		if (!strpos($contents, "config/config_local.php")) // config_local has already been merged, but there was a problem deleting it
			return;

		$contents .= @file_get_contents(SM_PATH . "config/config_local.php");

		// get default theme

		@include(SM_PATH . "config/nutsmail_themes.php");
		$default_theme_file = "";

		if (isset($theme) && isset($theme_default))
			if (array_key_exists($theme_default, $theme))
				$default_theme_file = basename($theme[$theme_default]['PATH']);

		// remove /**/ comments

		$i = 0;
		while (($i = strpos($contents, "/*", $i)) !== false)
		{
			$j = strpos($contents, "*/", $i);
			if ($j === false)
				return;

			$contents = substr_replace($contents, "", $i, $j - $i + 2);
		}

		// create array from config lines and get variables as keys and entire lines as values.
		// this will overwrite earlier values with later values if the same variable is listed more than one time.

		$array = array(
			'$config_admin_account'=>'$config_admin_account = "";',
			'$init_setup_completed'=>'$init_setup_completed = true;',
			'$default_theme_file'=>'$default_theme_file = "' . $default_theme_file . '";',
			'$default_theme_file_mobile'=>'$default_theme_file_mobile = "";'
		);

		foreach (explode("\n", $contents) as $val)
		{
			$val = trim($val);
			if (!$val || strpos($val, "global") !== false || strpos($val, "<?") !== false || strpos($val, "include ") !== false)
				continue;

			// find variable
			$i = strpos($val, '$');
			if ($i === false)
				continue;

			$j = strpos($val, "=", $i);
			if (!$j)
				continue;

			$k = trim(substr($val, $i, $j - $i - 1));
			if ($k)
				$array[$k] = $val;
		}

		// re-create config file

		$output = "<?php\n\nglobal \$version;\nglobal \$config_version;\n\n";
		foreach ($array as $val)
		{
			if (strpos($val, "plugins[0]") || strpos($val, "theme_default"))
				$val = "\n" . $val;

			if (strpos($val, "theme[0]['NAME']"))
				$val = $val . "\n";

			$output .= $val . "\n";
		}

		$output .= "\nrequire_once SM_PATH . 'functions/nmThemeManager.php';\n";

		if (@file_put_contents(SM_PATH . "config/config.php", $output))
		{
			@unlink(SM_PATH . "config/config_local.php");
			@unlink(SM_PATH . "config/nutsmail_themes.php");
		}
	}

	function verifyConfigPermissions()
	{
		// check whether should display the configuration program or not

		$this->upgradeConfig(); // upgrade from earlier versions of NutsMail

		@include(SM_PATH . "config/config.php");

		$this->themeFile = @$default_theme_file;
		$this->themeFileMobile = @$default_theme_file_mobile;
		$this->dataDir = @$data_dir;
		$this->attachDir = @$attachment_dir;
		$this->fixDirectoryPaths();

		// if admin tyring to edit config

		global $username;
		if ($username)
			return @$config_admin_account && $config_admin_account == $username;

		// if initial setup

		if (isset($init_setup_completed) && !$init_setup_completed)
			return true;

		// redirect to login page

		header('Location: src/login.php');
		return false;
	}

	private function removeTrailingSlash($s)
	{
		if (substr($s, -1) == '/')
			return substr($s, 0, -1);
		return $s;
	}

	private function addTrailingSlash($s)
	{
		if (substr($s, -1) == '/')
			return $s;
		return $s . '/';
	}

	function getDataDir($forDisplay = false)
	{
		$smPath = $forDisplay ? "" : SM_PATH;
		$prefix = substr($this->dataDir, 0, 1) == "/" ? "" : $smPath;
		return $prefix . $this->addTrailingSlash($this->dataDir);
	}

	function getAttachDir($forDisplay = false)
	{
		$smPath = $forDisplay ? "" : SM_PATH;
		$prefix = substr($this->attachDir, 0, 1) == "/" ? "" : $smPath;
		return $prefix . $this->addTrailingSlash($this->attachDir);
	}

	function getThemes(&$errorText)
	{
		$nmThemeManager = new NmThemeManager();
		$nmThemeManager->createThemeArray($this->themes, $themeDefault, $themeCss, "", "");

		if (!count($this->themes))
		{
			$errorText .= $this->getErrorCode("The program could not find any NutsMail themes. Please copy the themes you have purchased to the appropriate folders.");
			return false;
		}
		return true;
	}

	private function getErrorCode($text)
	{
		return "<div class='errorItem'><table><tr><td><img src='" . SM_PATH . "setup/images/error.png' alt='' /></td><td><span>$text</span></td></tr></table></div>";
	}

	private function v($string)
	{
		return htmlentities($string, ENT_QUOTES);
	}

	private function getThemeCombo($mobile = false)
	{
		$mobileText = $mobile ? "_mobile" : "";
		$themeFile = $mobile ? $this->themeFileMobile : $this->themeFile;

		$hasThemes = false;
		$output = $mobile ? "<option value=''>- Use desktop theme -</option>" : "";

		foreach ($this->themes as $val)
		{
			$baseName = basename($this->v($val['PATH']));

			if ($mobile)
			{
				if (strpos($baseName, "mobile") === false)
					continue;
			}
			else
			{
				if (strpos($baseName, "mobile") !== false)
					continue;
			}

			$output .= "<option value='$baseName'" . ($baseName == $themeFile ? " selected='selected'" : "") . ">" . $this->v($val['NAME']) . "</option>";
			$hasThemes = true;
		}

		if ($output)
			return '<select id="default_theme_file' . $mobileText . '" name="default_theme_file' . $mobileText . '">' . $output . '</select>'.
				($mobile && !$hasThemes ? "<p class='subscript'>You don't have any mobile themes installed. Mobile themes make it easy to access e-mail from devices like iPhone. You can purchase mobile themes at <a target='_blank' href='http://nutsmail.com'>NutsMail.com</a>.</p>" : "");

		return "";
	}

	private function getCombo($name, $selected, $values = array('true'=>'Yes', 'false'=>'No'))
	{
		if (is_bool($selected))
			$selected = $selected ? "true" : "false";

		$output = "";
		foreach ($values as $key=>$val)
			$output .= "<option value='$key'" . ($selected == $key ? " selected='selected'" : "") . ">$val</option>";
		return "<select name='$name'>$output</select>";
	}

	private function getPluginCode()
	{
		$output = "";
		foreach (explode("\n", @file_get_contents(SM_PATH . "config/config.php")) as $val)
		{
			$pluginPos = strpos($val, '$plugins[');
			if ($pluginPos !== false)
			{
				$i = strpos($val, "=", $pluginPos);
				if (!$i)
					continue;

				$j = strpos($val, ";", $i);
				if (!$j)
					continue;

				$name = preg_replace("/[^A-Za-z\-_]/", "", substr($val, $i, $j - $i));

				if (!is_dir(SM_PATH . "plugins/" . $name))
					continue;

				$enabled = !(strpos($val, "//") < $pluginPos);
				$output .= "<tr><td class='plugin label'>$name</td><td class='plugin input'>" .
					$this->getCombo("sm_plugin_" . (int)$enabled . "_" . $name, $enabled, array("true"=>"Enabled", "false"=>"Disabled")) .
					"</td><td class='info'></td></tr>";
			}
		}

		if ($output)
			return "<table><tr><th><span>Plugin name</span></th><th><span>Enabled</span></th><th><span>&nbsp;</span></th></tr>$output</table>";

		return "<p>No plugins are listed in 'config/config.php.</p>";
	}

	private function backwardStrpos($haystack, $needle, $offset = 0)
	{
    $length = strlen($haystack);
    $offset = $offset > 0 ? $length - $offset : abs($offset);
    $pos = strpos(strrev($haystack), strrev($needle), $offset);
    return ($pos === false) ? false : $length - $pos - strlen($needle);
	}

	function replaceSetting(&$config, &$default, $setting, $value, $addSmPath = false)
	{
		if ($setting == "show_html_default" || $setting == "compose_window_type")
		{
			// default_pref
			$i = strpos($default, $setting);
			if ($i === false)
				return;

			$j = strpos($default, "\n", $i);
			if ($j === false)
				$j = strlen($default);

			$default = substr_replace($default, $setting . "=" . $value, $i, $j - $i);
			return;
		}

		// config.php

		if (strpos($setting, "sm_plugin_") === 0)
		{
			// value has not changed, don't edit
			$prevValue = substr($setting, 10, 1);
			if (($prevValue == "1" && $value == "true") || ($prevValue == "0" && $value == "false"))
				return;

			$name = substr($setting, 12);

			$pluginPos = 0;
			while ($pluginPos !== false)
			{
				$pluginPos = strpos($config, '$plugins[', $pluginPos + 1);
				if ($pluginPos === false)
					return;

				$i = strpos($config, "=", $pluginPos);
				if (!$i)
					return;

				$j = strpos($config, ";", $i);
				if (!$j)
					return;


				if ($name != preg_replace("/[^A-Za-z\-_]/", "", substr($config, $i, $j - $i)))
					continue;

				$n = $this->backwardStrpos($config, "\n", $pluginPos);
				if (!$n)
					return;

				$config = substr_replace($config, ($value == "true" ? "" : "//"), $n + 1, $pluginPos - $n - 1);
			}
		}
		else
		{
			$i = 0;
			while ($i !== false)
			{
				$i = strpos($config, $setting, $i + 1);
				if ($i !== false)
				{
					$j = strpos($config, "\n", $i);
					if ($j === false)
						$j = strlen($config);

					$k = strpos($config, ";", $i);
					if ($k !== false && $k < $j)
					{
						$quote = $value == "false" || $value == "true" || is_numeric($value) ? "" : '"';
						$config = substr_replace($config, $setting . ' = ' . ($addSmPath ? "SM_PATH . " : "") . $quote . $value . $quote, $i, $k - $i);
						return;
					}
				}
			}
		}
	}

	function writeSettings(&$errorText)
	{
		if (!(isset($_POST['data_dir']) || isset($_POST['attachment_dir'])))
			return false;

		$config = @file_get_contents(SM_PATH . "config/config.php");
		if (!$config)
		{
			$errorText = "Cannot open 'config/config.php' for editing.";
			return false;
		}

		if (!isset($_POST['folderError']))
		{
			$default = @file_get_contents($this->getDataDir() . "default_pref");
			if (!$default)
			{
				$errorText = "Cannot open '" . $this->getDataDir() . "default_pref' for editing.";
				return false;
			}
		}

		foreach ($_POST as $key=>$val)
		{
			$addSmPath = false;

			// special handling for data & attach directories
			if ($key == "data_dir" || $key == "attachment_dir")
			{
			  if (!$val)
					continue;

				$val = $this->addTrailingSlash($val);
				$addSmPath = substr($val, 0, 1) != "/";
			}

			$this->replaceSetting($config, $default, $key, $val, $addSmPath);

			// keep org_name and org_title the same, since they are used interchangeably by sm (!) - see browser title at login and after login
			if ($key == "org_name")
				$this->replaceSetting($config, $default, "org_title", $val);
		}

		// save settings into default_pref

		if (!isset($_POST['folderError']))
		{
			if (!@file_put_contents($this->getDataDir() . "default_pref", $default))
			{
				$errorText = "Cannot save information in '" . $this->getDataDir() . "default_pref'. Please make sure that the file is writable.";
				return false;
			}
		}

		// save settings into config.php. If old config.php, delete it and create a new one before writing settings

		if (!$this->configVersion && file_exists(SM_PATH . "config/config_default"))
			if (@copy(SM_PATH . "config/config_default", SM_PATH . "config/config_replace"))
				if (@unlink(SM_PATH . "config/config.php"))
					if (!@rename(SM_PATH . "config/config_replace", SM_PATH . "config/config.php"))
					{
						$errorText = "Your configuration file cannot be replaced. Please rename the file 'config/config_replace' to 'config/config.php' and click 'Save options' again.";
						return false;
					}

		if (!@file_put_contents(SM_PATH . "config/config.php", $config))
		{
			$errorText = "Cannot save information in 'config/config.php'. Please make sure that the file is writable.";
			return false;
		}

		// reload settings

		@include(SM_PATH . "config/config.php");
		$this->themeFile = @$default_theme_file;
		$this->themeFileMobile = @$default_theme_file_mobile;
		$this->dataDir = @$data_dir;
		$this->attachDir = @$attachment_dir;
		$this->fixDirectoryPaths();

		return true;
	}

	private function fixDirectoryPaths()
	{
		$this->dataDir = substr($this->dataDir, 0, 3) == "../" ? substr($this->dataDir, 3) : $this->dataDir;
		$this->attachDir = substr($this->attachDir, 0, 3) == "../" ? substr($this->attachDir, 3) : $this->attachDir;
	}

	function getHeader()
	{
		global $nmParam;

		?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>NutsMail Setup</title>
	<script type="text/javascript" src="<?php echo SM_PATH ?>functions/jquery.js"></script>
	<script type="text/javascript" src="<?php echo SM_PATH ?>setup/jqueryui/js/jquery-ui-1.8.6.custom.min.js"></script>
	<link rel="stylesheet" type="text/css" href="<?php echo SM_PATH ?>setup/jqueryui/css/custom-theme/jquery-ui-1.8.6.custom.css" />
	<script type="text/javascript" src="<?php echo SM_PATH ?>setup/jquery.form.min.js"></script>
	<script type="text/javascript" src="<?php echo SM_PATH ?>setup/general.js"></script>
	<link rel="stylesheet" type="text/css" href="<?php echo SM_PATH ?>setup/styles.css" />
	<script type="text/javascript">
		$(function() {
			if ($("#tabs").length)
				$("#tabs").tabs({selected: 0});
		});

		$(document).ready(function() {
			$(".button").button();
			$(".tooltipElement").hover(
				function(e) {
					$(this).contents(".tooltip").css("top", (Math.round($(this).position().top) + 25) + "px").css("left", Math.round($(this).position().left - 340) + "px");
					if ($(this).contents(".tooltip").find("#themePreview").length)
						getThemePreview(<?php echo SM_PATH ? "0" : "1" ?>, 0);
					if ($(this).contents(".tooltip").find("#themePreviewMobile").length)
						getThemePreview(<?php echo SM_PATH ? "0" : "1" ?>, 1);
					$(this).contents(".tooltip").show();
				},
				function () { $(this).contents(".tooltip").hide(); }
			);
			$("body").fadeIn(300);
		});
	</script>
</head>

<body>
<div id="container">
<div id="header"><img src="<?php echo SM_PATH ?>setup/images/logo.png" alt="" /></div>
<div id="contents">
<?php
	}

	function getFooter()
	{
		echo "</div></div><div id='footer'></div></body></html>";
	}

	function getOutput($nmParam)
	{
		include(SM_PATH . "config/config.php");

		$this->configVersion = isset($nm_config_version) ? $nm_config_version : false;

		$default_pref = array();
		foreach (explode("\n", @file_get_contents(SM_PATH . "data/default_pref")) as $val)
		{
			$a = explode("=", $val);
			if (count($a) == 2)
				$default_pref += array(trim($a[0])=>trim($a[1]));
		}

		if (!array_key_exists('show_html_default', $default_pref) || ($default_pref['show_html_default'] != '0' && $default_pref['show_html_default'] != '0'))
			$default_pref['show_html_default'] = '1';

		if (!array_key_exists('compose_window_type', $default_pref) || ($default_pref['compose_window_type'] != '0' && $default_pref['compose_window_type'] != '0'))
			$default_pref['compose_window_type'] = 'html';

		global $username;
		if (!@$username)
			echo "<div id='intro'><p>Welcome to NutsMail! Since this is the first time you are accessing your e-mail system, let's take a few minutes to configure it.</p><p>Most users will only need to modify the options on the Basic page; the other pages show some advanced options that in most cases don't need to be changed.</p><p>After you are done, click 'Save options' and you'll be redirected to your e-mail login page.</p></div>";

		?>
		<form name="nmForm" action="" method="post">
		<input type="hidden" name="init_setup_completed" value="true" />
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1">Basic</a></li>
				<li><a href="#tabs-2">Server</a></li>
				<li><a href="#tabs-3">Language</a></li>
				<li><a href="#tabs-4">E-mail folders</a></li>
				<li><a href="#tabs-5">Users</a></li>
				<li><a href="#tabs-6">Paths</a></li>
				<li><a href="#tabs-7">Plugins</a></li>
			</ul>

			<div id="tabs-1">
				<table>
					<tr><td colspan="3"><h4>Basic settings</h4></td></tr>

					<tr><td class="label">Organization name: </td><td class="input"><input type="text" name="org_name" value="<?php echo $this->v($org_name) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the name of your company or organization.</span></span></td></tr>

					<tr><td class="label">Default desktop theme: </td><td class="input"><?php echo $this->getThemeCombo() ?></td>
						<td class="info">
						<span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/preview.png" /><span class="tooltip"><span id='themePreview'><img src="<?php echo SM_PATH ?>setup/images/loaderBig.gif" /></span></span></span>
						<span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Specifies the default theme that will be used for all new users, as well as for the login and logout pages.</span></span>
						</td></tr>

					<tr><td class="label">Default mobile theme: </td><td class="input"><?php echo $this->getThemeCombo(true) ?></td>
						<td class="info">
						<span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/preview.png" /><span class="tooltip"><span id='themePreviewMobile'><img src="<?php echo SM_PATH ?>setup/images/loaderBig.gif" /></span></span></span>
						<span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Specifies the default theme that will be displayed when a mobile device like iPhone or Blackberry is used.</span></span>
						</td></tr>

					<tr><td class="label">Administrator's login: </td><td class="input"><input type="text" name="config_admin_account" value="<?php echo $this->v($config_admin_account) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">The user logging in using this login name will be able to launch this configuration program from the Options page of his or her account. If you leave this field blank, you will not be able to access this configuration program any more, and any future changes to the options will need to be made by manually editing the configuration files.</span></span></td></tr>

					<tr><td class="label">Login message: </td><td class="input"><input type="text" name="motd" value="<?php echo $this->v($motd) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is a message that is displayed immediately after a user logs in. Leave blank if you don't want to display any message.</span></span></td></tr>

					<tr><td class="label">Default width of folder list: </td><td class="input"><input type="text" name="default_left_size" value="<?php echo $this->v($default_left_size) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the default width of the folder list in pixels. Users can customize this value for their account.</span></span></td></tr>

				</table>
			</div>

			<div id="tabs-2">
				<table>
					<tr><td colspan="3"><h4>Server settings</h4></td></tr>

					<tr><td class="label">IMAP server address: </td><td class="input"><input type="text" name="imapServerAddress" value="<?php echo $this->v($imapServerAddress) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">The dns name (or IP address) for your imap server.</span></span></td></tr>

					<tr><td class="label">IMAP server port: </td><td class="input"><input type="text" name="imapPort" value="<?php echo $this->v($imapPort) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Port used by your imap server. (Usually 143)</span></span></td></tr>

					<tr><td class="label">IMAP server type: </td><td class="input"><?php echo $this->getCombo('imap_server_type', $imap_server_type, array("courier"=>"courier", "cyrus"=>"cyrus", "exchange"=>"exchange", "uw"=>"uw", "macosx"=>"macosx", "hmailserver"=>"hmailserver", "other"=>"other")) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">The type of IMAP server you are running. If you select a specific server, you may need to adjust several other options (see doc/presets.txt for details).</span></span></td></tr>

					<tr><td class="label">IMAP authentication mechanism: </td><td class="input"><?php echo $this->getCombo('imap_auth_mech', $imap_auth_mech, array('login'=>'login', 'plain'=>'plain', 'cram-md5'=>'cram-md5', 'digest-md5'=>'digest-md5')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Specifies the IMAP authentication mechanism.</span></span></td></tr>

					<tr><td class="label">IMAP charset search: </td><td class="input"><?php echo $this->getCombo('allow_charset_search', $allow_charset_search, array('true'=>'Yes', 'false'=>'No')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option allows you to choose if charset search will be used. Your imap server should support SEARCH CHARSET command for this to work.</span></span></td></tr>

					<tr><td class="label">IMAP folder delimiter: </td><td class="input"><input type="text" name="optional_delimiter" value="<?php echo $this->v($optional_delimiter) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the delimiter that your IMAP server uses to distinguish between folders. For example, Cyrus uses '.' as the delimiter and a complete folder would look like 'INBOX.Friends.Bob', while UW uses '/' and would look like 'INBOX/Friends/Bob'.  Normally this should be left at 'detect' but if you are sure you know what delimiter your server uses, you can specify it here.</span></span></td></tr>

					<tr><td class="label">Time offset inversion: </td><td class="input"><?php echo $this->getCombo('invert_time', $invert_time) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If you are running on a machine that doesn't have the tm_gmtoff value in your time structure and if you are in a time zone that has a negative offset, you need to set this value to 1. This is typically people in the US that are running Solaris 7.</span></span></td></tr>

					<tr><td class="label">Enable IMAP UID: </td><td class="input"><?php echo $this->getCombo('uid_support', $uid_support) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option allows you to enable unique identifier (UID) support.</span></span></td></tr>

					<tr><td class="label">Send method: </td><td class="input"><?php echo $this->getCombo('useSendmail', $useSendmail, array('true'=>'Sendmail', 'false'=>'SMTP')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">What should be used when sending email. If SMTP is selected, the SMTP options below will be used. If Sendmail is selected the Sendmail options will be used.</span></span></td></tr>

					<tr><td class="label">Path to Sendmail: </td><td class="input"><input type="text" name="sendmail_path" value="<?php echo $this->v($sendmail_path) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'Sendmail'). Program that should be used when sending email. SquirrelMail expects that this program will follow options used by original Sendmail.</span></span></td></tr>

					<tr><td class="label">Extra Sendmail command arguments: </td><td class="input"><input type="text" name="sendmail_args" value="<?php echo $this->v($sendmail_args) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'Sendmail'). Sets additional sendmail command arguments. Make sure that arguments are supported by your sendmail program. -f argument is added automatically by SquirrelMail scripts. Variable defaults to standard /usr/sbin/sendmail arguments. If you use qmail-inject, nbsmtp or any other sendmail wrapper, which does not support -t and -i arguments, set variable to empty string or use arguments suitable for your mailer.</span></span></td></tr>

					<tr><td class="label">SMTP server address: </td><td class="input"><input type="text" name="smtpServerAddress" value="<?php echo $this->v($smtpServerAddress) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'SMTP'). Your SMTP server (usually the same as the IMAP server).</span></span></td></tr>

					<tr><td class="label">SMTP server port: </td><td class="input"><input type="text" name="smtpPort" value="<?php echo $this->v($smtpPort) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'SMTP'). Your SMTP port number (usually 25).</span></span></td></tr>

					<tr><td class="label">SMTP authentication username: </td><td class="input"><input type="text" name="smtp_sitewide_user" value="<?php echo $this->v($smtp_sitewide_user) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'SMTP'). If this is left blank, the IMAP user name will be used.</span></span></td></tr>

					<tr><td class="label">SMTP authentication password: </td><td class="input"><input type="text" name="smtp_sitewide_pass" value="<?php echo $this->v($smtp_sitewide_pass) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'SMTP'). If this is left blank, the IMAP user password will be used.</span></span></td></tr>

					<tr><td class="label">SMTP authentication mechanism: </td><td class="input"><?php echo $this->getCombo('smtp_auth_mech', $smtp_auth_mech, array('none'=>'none', 'login'=>'login', 'plain'=>'plain', 'cram-md5'=>'cram-md5', 'digest-md5'=>'digest-md5')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">(Applicable only if send method is set to 'SMTP'). Specifies the SMTP authentication mechanism.</span></span></td></tr>

					<tr><td class="label">POP before SMTP: </td><td class="input"><?php echo $this->getCombo('pop_before_smtp', $pop_before_smtp) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Do you wish to use POP3 before SMTP?  Your server must support this in order for SquirrelMail to work with it.</span></span></td></tr>

					<tr><td class="label">Signout page: </td><td class="input"><input type="text" name="signout_page" value="<?php echo $this->v($signout_page) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Setting this option allows you to sign the user out and then redirect to whatever page you want. For example, specifying / will redirect the users to your home page. Leave blank to use the logout page.</span></span></td></tr>

				</table>
			</div>

			<div id="tabs-3">
				<table>
					<tr><td colspan="3"><h4>Language settings</h4></td></tr>

					<tr><td class="label">Default language: </td><td class="input"><?php echo $this->getCombo('squirrelmail_default_language', $squirrelmail_default_language, $this->supportedLanguages) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the default language. It is used as a last resort if the program can't figure out which language to display.</span></span></td></tr>

					<tr><td class="label">Default character set: </td><td class="input"><input type="text" name="default_charset" value="<?php echo $this->v($default_charset) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option controls what character set is used when sending mail and when sending HTML to the browser. This option is active only when default language is English. In other cases the program uses charset that depends on default language.</span></span></td></tr>

					<tr><td class="label">Lossy encoding: </td><td class="input"><?php echo $this->getCombo('lossy_encoding', $lossy_encoding) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option allows charset conversions when output charset does not support all symbols used in original charset. Symbols unsupported by output charset will be replaced with question marks.</span></span></td></tr>
				</table>
			</div>

			<div id="tabs-4">
				<table>
					<tr><td colspan="3"><h4>E-mail folder settings</h4></td></tr>

					<tr><td class="label">Default IMAP folder prefix: </td><td class="input"><input type="text" name="default_folder_prefix" value="<?php echo $this->v($default_folder_prefix) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Many servers store mail in your home directory. With this, they store them in a subdirectory: mail/ or Mail/, etc. If your server does this, please set this to what the default mail folder should be. This is still a user preference, so they can change it if it is different for each user.</span></span></td></tr>

					<tr><td class="label">Trash folder: </td><td class="input"><input type="text" name="trash_folder" value="<?php echo $this->v($trash_folder) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the path to the default trash folder. For Cyrus IMAP, it would be 'INBOX.Trash', but for UW it would be 'Trash'. We need the full path name here.</span></span></td></tr>

					<tr><td class="label">Sent folder: </td><td class="input"><input type="text" name="sent_folder" value="<?php echo $this->v($sent_folder) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the patch to where Draft messages will be stored.</span></span></td></tr>

					<tr><td class="label">Draft folder: </td><td class="input"><input type="text" name="draft_folder" value="<?php echo $this->v($draft_folder) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This is the path to where Sent messages will be stored.</span></span></td></tr>

					<tr><td class="label">Move to trash: </td><td class="input"><?php echo $this->getCombo('default_move_to_trash', $default_move_to_trash) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If this is set to 'Yes', when 'delete' is pressed, it will attempt to move the selected messages to the trash folder. If it's set to 'No', we won't even attempt to move the messages, just delete them.</span></span></td></tr>

					<tr><td class="label">Move to sent: </td><td class="input"><?php echo $this->getCombo('default_move_to_sent', $default_move_to_sent) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If this is set to 'Yes', sent messages will be stored in the sent folder by default.</span></span></td></tr>

					<tr><td class="label">Save as draft: </td><td class="input"><?php echo $this->getCombo('default_save_as_draft', $default_save_as_draft) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If this is set to 'Yes', users are able to use the draft folder to store their unfinished messages.</span></span></td></tr>

					<tr><td class="label">Allow users to change prefix: </td><td class="input"><?php echo $this->getCombo('show_prefix_option', $show_prefix_option) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If you do not wish to give them the option to change this, set it to 'no'. Otherwise, if it is true, they can change the folder prefix to be anything.</span></span></td></tr>

					<tr><td class="label">List special folders first: </td><td class="input"><?php echo $this->getCombo('list_special_folders_first', $list_special_folders_first) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Whether or not to list the special folders first.</span></span></td></tr>

					<tr><td class="label">Auto expunge: </td><td class="input"><?php echo $this->getCombo('auto_expunge', $auto_expunge) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If this option is set, when a message is moved or copied, the  source mailbox will get expunged, removing all messages marked 'Deleted'.</span></span></td></tr>

					<tr><td class="label">All folders under inbox: </td><td class="input"><?php echo $this->getCombo('default_sub_of_inbox', $default_sub_of_inbox) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Are all your folders subfolders of INBOX (i.e. cyrus IMAP server)? If you are unsure, set it to 'no'.</span></span></td></tr>

					<tr><td class="label">Display subfolder option: </td><td class="input"><?php echo $this->getCombo('show_contain_subfolders_option', $show_contain_subfolders_option) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Some IMAP daemons (UW) only allow a folder to contain either messages or other folders, not both at the same time. This option controls whether or not to display an option during folder creation. The option toggles which type of folder it should be. If you are not sure, set it to 'yes'.</span></span></td></tr>

					<tr><td class="label">Display unseen in folders: </td><td class="input"><?php echo $this->getCombo('default_unseen_notify', $default_unseen_notify, array('1'=>'None', '2'=>'Inbox', '3'=>'All')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Specifies whether or not the users will see the number of unseen in each folder by default and also which folders to do this to.</span></span></td></tr>

					<tr><td class="label">Unseen notification type: </td><td class="input"><?php echo $this->getCombo('default_unseen_type', $default_unseen_type, array('1'=>'(4)', '2'=>'(4,25)')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Specifies the type of notification to give the users by default.</span></span></td></tr>

					<tr><td class="label">Create special folders: </td><td class="input"><?php echo $this->getCombo('auto_create_special', $auto_create_special) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Should the program create the Sent and Trash folders automatically for a new user that doesn't already have them created?</span></span></td></tr>

					<tr><td class="label">Delete folders permanently: </td><td class="input"><?php echo $this->getCombo('delete_folder', $delete_folder) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">If this is true, when a folder is deleted then it will not get moved into the Trash folder.</span></span></td></tr>

					<tr><td class="label">Cyrus 'no select' fix: </td><td class="input"><?php echo $this->getCombo('noselect_fix_enable', $noselect_fix_enable) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This enables the no select fix for Cyrus when subfolders exist but parent folders do not.</span></span></td></tr>

				</table>
			</div>

			<div id="tabs-5">
				<table>
					<tr><td colspan="3"><h4>User settings</h4></td></tr>

					<tr><td class="label">Display mail as HTML: </td><td class="input"><?php echo $this->getCombo('show_html_default', $default_pref['show_html_default'], array('1'=>'Yes', '0'=>'No')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option specifies whether e-mails will be displayed using formatted HTML or plain text. Users will be able to change this option in their account configuration.</span></span></td></tr>

					<tr><td class="label">Compose using formatted text: </td><td class="input"><?php echo $this->getCombo('compose_window_type', $default_pref['compose_window_type'], array('html'=>'Yes', 'plain'=>'No')) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option specifies whether e-mails will be composed using formatted HTML or plain text. Users will be able to change this option in their account configuration.</span></span></td></tr>

					<tr><td class="label">Force lowercase usernames: </td><td class="input"><?php echo $this->getCombo('force_username_lowercase', $force_username_lowercase) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Some IMAP servers allow a username (like 'bob') to log in if they use uppercase in their name (like 'Bob' or 'BOB'). This creates extra preference files. Setting this option to 'yes' will transparently change all usernames to lowercase.</span></span></td></tr>

					<tr><td class="label">Enable e-mail priority flags: </td><td class="input"><?php echo $this->getCombo('default_use_priority', $default_use_priority) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option enables use of email priority flags by end users.</span></span></td></tr>

					<tr><td class="label">Enables read/delivery receipts: </td><td class="input"><?php echo $this->getCombo('default_use_mdn', $default_use_mdn) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">This option enables use of read/delivery receipts by end users.</span></span></td></tr>

					<tr><td class="label">Allow users to change e-mail address: </td><td class="input"><?php echo $this->getCombo('edit_identity', $edit_identity) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Allows users to change their email address.</span></span></td></tr>

					<tr><td class="label">Allow users to change name: </td><td class="input"><?php echo $this->getCombo('edit_name', $edit_name) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Allows users to change their email address. This option has no effect unless 'Allow users to change name' is set to 'no'.</span></span></td></tr>

					<tr><td class="label">Hide username header: </td><td class="input"><?php echo $this->getCombo('hide_auth_header', $hide_auth_header) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">SquirrelMail adds username information to every sent email. It is done in order to prevent possible sender forging when end users are allowed to change their email and name information. You can disable this header, if you think that it violates user's privacy or security. Please note, that setting will work only when users are not allowed to change their e-mail address.</span></span></td></tr>

					<tr><td class="label">Use Javascript in addressbook: </td><td class="input"><?php echo $this->getCombo('default_use_javascript_addr_book', $default_use_javascript_addr_book) ?></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Users may search their addressbook via either a plain HTML or Javascript enhanced user interface. This option allows you to set the default choice.</span></span></td></tr>
				</table>
			</div>

			<div id="tabs-6">
				<table>
					<tr><td colspan="3"><h4>Path settings</h4></td></tr>

					<tr><td class="label">Data directory: </td><td class="input"><input type="text" name="data_dir" value="<?php echo $this->v($this->getDataDir(true)) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Path to the data/ directory. It is a possible security hole to have a writable directory under the web server's root directory (ex: /home/httpd/html). It is possible to put the data directory anywhere you would like; it is strongly advised that it is NOT directly web-accessible.</span></span></td></tr>

					<tr><td class="label">Attachment directory: </td><td class="input"><input type="text" name="attachment_dir" value="<?php echo $this->v($this->getAttachDir(true)) ?>" /></td>
						<td class="info"><span class="tooltipElement"><img src="<?php echo SM_PATH ?>setup/images/info.png" /><span class="tooltip">Path to directory used for storing attachments while a mail is being sent. There are a few security considerations regarding this directory: (1) It should have the permission 733 (rwx-wx-wx) to make it impossible for a random person with access to the webserver to list files in this directory. Confidential data might be laying around there. (2) Since the webserver is not able to list the files in the content is also impossible for the webserver to delete files lying around there for too long. (3) It should probably be another directory than the data directory.</span></span></td></tr>
				</table>
			</div>

			<div id="tabs-7">
				<?php echo $this->getPluginCode(); ?>
			</div>

		</div>

		<div class='buttonBox'>
			<?php echo (isset($username) ? "<input class='button' type='button' value='Return to Inbox' onClick='window.location=\"../src/right_main.php\"' />" : "") ?>
			<input class='button' type='button' value="Save options" onClick="verifyForm()" />
		</div>
		</form>

		<?php
	}

}
