function isUnsignedInteger(s)
{
  return (s.toString().search(/^[0-9]+$/) == 0);
}

function verifyForm()
{
	if (!document.nmForm.org_name.value)
	{
		alert("Please type the organization name. (Basic page)");
		return;
	}

	if (!isUnsignedInteger(document.nmForm.default_left_size.value) || document.nmForm.default_left_size.value < 100 || document.nmForm.default_left_size.value > 600)
	{
		alert("The default width of folder list must be a number between 100 and 600. (Basic page)");
		return;
	}

	if (!document.nmForm.imapServerAddress.value)
	{
		alert("Please type the IMAP server address. (Server page)");
		return;
	}

	if (!document.nmForm.imapPort.value)
	{
		alert("Please type the IMAP server port. (Server page)");
		return;
	}

	if (!document.nmForm.optional_delimiter.value)
	{
		alert("Please type the IMAP folder delimiter. (Server page)");
		return;
	}

	if (!document.nmForm.config_admin_account.value)
	{
		if (!confirm("If you don't specify the administrator's e-mail on the basic page, you will not be able to access this configuration program any more and all future changes to the configuration will need to be made manually. Continue?"))
			return;
	}

	document.nmForm.submit();
}

function getThemePreview(rootFolder, mobile)
{
	var themeFile = $("#default_theme_file" + (mobile ? "_mobile" : "")).val();
	if (mobile && !themeFile)
		themeFile = $("#default_theme_file").val();

	$("#themePreview" + (mobile ? "Mobile" : "")).html("<img src='" + (rootFolder ? "" : "../") + " setup/images/loaderBig.gif' alt='' />");

	$.ajax({ type: "GET",	url: (rootFolder ? "" : "../") +"setup/ajax.php", data: "rootFolder=" + rootFolder + "&themePreview=" + escape(themeFile),
		success: function(msg)
		{
			if (msg.substr(0, 2) == "ok")
				$("#themePreview" + (mobile ? "Mobile" : "")).html("<img id='previewImage' src='" + msg.substr(3) + "' alt='' />");
			else
				$("#themePreview" + (mobile ? "Mobile" : "")).html(msg);
		}
	});

}
















