<?php

//**************************************************************
// Fly06 Spammer Blocker for Joomla 1.5              
// Copyright (C) 2009-2010 by Frédéric Leroy (aka Fly06)   
// --------------- All Rights Reserved ----------------      
// Homepage   : http://www.fly06.fr/        
// Version    : 1.1 beta    
// Date       : 06/04/10
// License    : GNU/GPL            
//**************************************************************
// APIs : Stop Forum Spam
// http://www.stopforumspam.com/
//**************************************************************

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


//******************************************************************
// HELPER CLASS
//******************************************************************

class spammerBlockerHelper {

	// Date et heure d'appel
	var $now; // date
	
	// Request
	var $option;
	var $task;
	var $func;
	var $Itemid;
	
	// Email admin (notifications)
	var $admin_email;
	
	// Contexte d'application du plugin
	var $registration; // int
	var $useredit; // int
	
	// Connexion serveur
	var $allow_url_fopen; // string
	var $curl_loaded; // string
	var $cnx_err_no; // int
	var $cnx_err_str; // string
	
	// Url Stop Forum Spam
	var $base_url; // string
	
	// Id user/visitor
	var $id; // int
	
	// Paramètres
	var $params; // object
	
	// Code erreur
	var $error; // int
	
	// Données de test
	var $check_list; // array
	var $use_it; // array
	var $user_data; // array
	var $is_bad; // array
	
	
	function isApplicable() {

		// Composants supportés :
		// - Joomla standard
		// - VirtueMart
		// - Community Builder
		// - JUser
		// Evènements interceptés :
		// - Inscription
		// - Modification du profil utilisateur
		
		$option = JRequest::getVar( 'option' );
		$task = JRequest::getVar( 'task' ); // com_user, com_comprofiler, com_juser
		$func = JRequest::getVar( 'func' ); // com_virtuemart

		$registration = (($option == 'com_virtuemart') && ($func == 'shopperadd')) 
						|| 
						(($option == 'com_user') && ($task == 'register_save')) 
						||
						(($option == 'com_comprofiler') && ($task == 'saveregisters'))
						|| 
						(($option == 'com_juser') && ($task == 'saveUserRegistration'));
		$useredit = (($option == 'com_virtuemart') && ($func == 'shopperupdate'))
						||
						(($option == 'com_user') && ($task == 'save'))
						|| 
						(($option == 'com_comprofiler') && ($task == 'saveUserEdit')) 
						|| 
						(($option == 'com_juser') && ($task == 'saveUserEdit'));		
		
		// Est-on dans un contexte d'application du plugin ?
		$isApplicable = $registration || $useredit;
		
		// Si oui, on initialise les variables de contexte avant de sortir
		if ($isApplicable) {
			$this->option = $option;
			$this->task = $task;
			$this->func = $func;
			$this->registration = $registration;
			$this->useredit = $useredit;
		}
		
		return $isApplicable;
	
	}
	
	function init() {
	
		// Récupération et sauvegarde des paramètres
		$mainframe = &JFactory::getApplication();
	
 		$plugin =& JPluginHelper::getPlugin('system', 'spammerblocker');
 		$params = new JParameter( $plugin->params );
		
		$params->set('filter_power', $params->get('filter_power', 'max'));	
				
		$params->set('use_email', intval($params->get('use_email', 1)));
		$params->set('use_username', intval($params->get('use_username', 1)));
		$params->set('use_ip', intval($params->get('use_ip', 1)));
		
		$params->set('redir_mode', intval($params->get('redir_mode', 1)));
		$params->set('redir_to', intval($params->get('redir_to', 1)));
		$params->set('redir_url', trim(strip_tags($params->get('redir_url', ''))));
		
		// On force 'redir_url' en url absolue 
		if (!$params->get('redir_to') && !preg_match('#^http://#', $params->get('redir_url'))) {
			$params->set('redir_url', JRoute::_(JURI::base() . $params->get('redir_url'), false));
		}
		
		$params->set('user_edit_mode', intval($params->get('user_edit_mode', 0))); 
		$params->set('notify_mailfrom', trim(strip_tags($params->get('notify_mailfrom', $mainframe->getCfg( 'mailfrom' )))));
		$params->set('notify_fromname', trim(strip_tags($params->get('notify_fromname', $mainframe->getCfg( 'fromname' )))));
		
		$params->set('admin_to_notify', intval($params->get('admin_to_notify', 0)));
		
		$params->set('admin_notification_spam', intval($params->get('admin_notification_spam', 1)));
		$params->set('admin_notification_cnx', intval($params->get('admin_notification_cnx', 1)));
		
		$params->set('user_notification', intval($params->get('user_notification', 0)));
		$params->set('error_url_handling', intval($params->get('error_url_handling', 1)));

		$curlopt_timeout = intval($params->get( 'curlopt_timeout', 10 ));
		$params->set('curlopt_timeout', ($curlopt_timeout ? $curlopt_timeout : 10));
		$curlopt_connect_timeout = intval($params->get( 'curlopt_connect_timeout', 10 ));
		$params->set('curlopt_connect_timeout', ($curlopt_connect_timeout ? $curlopt_connect_timeout : 10));			
			
		$params->set('user_ip_handling', intval($params->get( 'user_ip_handling', 1 )));
		$params->set('redir_use_itemid', intval($params->get( 'redir_use_itemid', 1 )));

		$params->set('msgtype_block_spammer', $params->get( 'msgtype_block_spammer', 'notice' ));		
		$params->set('msgtype_block_user', $params->get( 'msgtype_block_user', 'error' ));			
		$params->set('msgtype_connexion_failed', $params->get( 'msgtype_connexion_failed', 'message' ));	
			
		$this->params = $params;
		
		// Email de l'administrateur à notifier		
		if ($params->get('admin_to_notify')) {
			$database = &JFactory::getDBO();
			$query = "SELECT email FROM #__users WHERE id=" . $params->get('admin_to_notify');
			$database->setQuery($query);
			$this->admin_email = $database->loadResult();			
		} else {
			$this->admin_email = $params->get('notify_mailfrom');
		}
		
		// Autres initialisations
		$this->Itemid = JRequest::getInt('Itemid', 0);
		$this->now = defined('_CURRENT_SERVER_TIME') ? constant('_CURRENT_SERVER_TIME') : date( 'Y-m-d H:i', time() );
		$this->allow_url_fopen = (ini_get('allow_url_fopen') == '' ? 0 : 1);
		//$this->curl_loaded = (extension_loaded('curl') == '' ? 0 : 1);
		$this->curl_loaded = (extension_loaded('curl') && function_exists('curl_exec') ? 1 : 0);
		$this->cnx_err_no = '';
		$this->cnx_err_str = '';
		$this->base_url = "http://www.stopforumspam.com/";
		$this->id = JRequest::getInt('id', 0);
		
	}
	
	function isNotUserEditApplicable() {
	
		return $this->useredit && !$this->params->get('user_edit_mode');
	
	}
	
	function isRemoteConnexionPossible() {
	
		$return = $this->curl_loaded || $this->allow_url_fopen;
		
		if (!$return) $this->error = 1;
		
		return $return;
	
	}
	
	function isPluginConfigurationOk() {
	
		$return =  $this->params->get('use_email') || $this->params->get('use_username') || $this->params->get('use_ip');

		if (!$return) $this->error = 0;
		
		return $return;
		
	}

	// Check for request forgeries, com_user only
	function checkToken() {

		switch ($this->option) {
			case 'com_comprofiler':
			case 'com_juser':
			case 'com_virtuemart':
				return true; 
				break;
			default:
			case 'com_user':	
				return JRequest::checkToken();
				break;
		}

	}
	
	function setUserData() {
	
		// Liste des paramètres à vérifier (potentielle)
		$this->check_list = array('email', 'username', 'ip');
		
		// Quels paramètres doit-on effectivement vérifier (config) ?
		$this->use_it = array(	'email' => $this->params->get('use_email'), 
									'username' => $this->params->get('use_username'), 
									'ip' => $this->params->get('use_ip')
								);
		
		// Récupération des valeurs des paramètres à vérifier
		$this->user_data['email'] = JRequest::getVar( 'email', '', 'post' );
		$this->user_data['username'] = JRequest::getVar( 'username', '', 'post');	
		$this->user_data['ip'] = JRequest::getVar( 'REMOTE_ADDR', $_SERVER["REMOTE_ADDR"], 'server' );

		// A-t-on les infos suffisantes pour continuer ?
		foreach ($this->use_it as $key => $val) {
			if ($val && empty($this->user_data[$key])) {
				return false;	
			}
		}

		return true;
		
	}
	
	function getXMLFromSFS() {
	
		// Initialisations
		$this->is_bad = array();
		$return = true;
	
		// On boucle sur $this->check_list
		foreach ($this->check_list as $check_element) {
		
			// Initialisation
			$this->is_bad[$check_element] = 'not tested';
			if (!$this->use_it[$check_element]) {
				continue;
			}
			$url = $this->base_url . "api?" . $check_element . "=" . urlencode($this->user_data[$check_element]);
			// On teste l'existence de la valeur de retour (connexion)
			if (!($xml = $this->_openConnexionToSFS($url))) {
				$return = false;
				break;
			}
			// On teste la cohérence de la valeur de retour (fichier xml)
			if (!($is_bad = $this->_readXML($xml))) {
				$return = false;
				break;
			}
			// A ce stade $is_bad_email contient 'yes' ou 'no'
			// ==> On sauve la valeur et on retourne true
			$this->is_bad[$check_element] = $is_bad;
		
		}
		
		// Valeur de retour
		return $return;
	
	}
	
	function isUserASpammer() {
	
		// $bad est un tableau binaire 
		// 1 : Le critère est positif pour la valeur
		// 0 : Le critère est négatif pour la valeur 
		$bad = array();

		// On boucle sur $this->check_list
		foreach ($this->check_list as $check_element) {
			if ($this->use_it[$check_element]) {
				$bad[] = ($this->is_bad[$check_element] == 'yes' ? 1 : 0);
			}
		}		

		// Application du type de filtrage
		// Min : toutes les critères doivent être positifs (1) pour bloquer l'inscription
		// Max : L'inscription est bloquée si au moins l'un des critères est positif (1)
		$is_bad_user_eval = $this->params->get('filter_power') . '($bad)';
		eval( "\$is_bad_user = $is_bad_user_eval;" );

		return $is_bad_user;
		
	}
	
	function blockSpammer() {

		$database = &JFactory::getDBO();
		
		// On bloque le compte ?
		$user_account_blocked = 0;
		if ($this->useredit && $this->id) {
			$user_account_blocked = $this->_blockUserAccount();	
		}

		// Récup du paramètre 'enabled' du composant
		$params = &JComponentHelper::getParams( 'com_spammerblocker' );
		$enable_log_spammer = $params->get('enabled');	

		// Log du spammer		
		if ($enable_log_spammer) {
			$this->_logSpammer();
		}
	
		// Envoi notification admin
		if ($this->params->get('admin_notification_spam')) {
			$text = ($this->registration ? JText::_( 'FLY06_REG_SPAMMER_BLOCKED' ) : JText::_( 'FLY06_USER_SPAMMER_BLOCKED' ));
			$subject = sprintf($text, $this->params->get('notify_fromname'), $this->now);
			$message = '';
			$message .= 'IP : ' . $this->user_data['ip'] . ' (' . $this->is_bad['ip'] . ')' . "\n";
			$message .= 'Email : ' . $this->user_data['email'] . ' (' . $this->is_bad['email'] . ')' . "\n";
			$message .= 'Username : ' . $this->user_data['username'] . ' (' . $this->is_bad['username'] . ')' . "\n";
			$sent = $this->_sendMail($this->admin_email, $subject, $message);	
		}
		
		// Gestion des messages selon que l'évènement intercepté est :
		// - Une modification de profil utilisateur
		// - Un enregistrement
		if ($this->useredit && $this->id) {
			$msg = JText::_( 'FLY06_USEREDIT_NOT_ALLOWED' );
			if ($user_account_blocked) {
				$msg .= ($this->params->get('redir_mode') ? '\n' : '<br />');
				$msg .= JText::_( 'FLY06_USER_ACCOUNT_BLOCKED' );
				$type = $this->params->get('msgtype_block_user');
			} else {
				$type = $this->params->get('msgtype_block_spammer');			
			}
		} else {
			$msg = JText::_( 'FLY06_REG_NOT_ALLOWED' );	
			$type = $this->params->get('msgtype_block_spammer');				
		}
	
		// Arrêt inscription/modification, message js et redirection
		$this->_redirect($msg, $type); 
		
	}
	
	function unpublishPlugin() {
		
		$database = &JFactory::getDBO();

		$query = "UPDATE #__plugins"
			. "\n SET published = '0'"
			. "\n WHERE element='spammerblocker'"
			;
		$database->setQuery( $query );	
		$database->query();	
		
		switch ($this->error) {
			case 0: // Plugin configuration
				$subject_constant = JText::_( 'FLY06_REG_PB_CONFIG_SUBJECT' );
				$message_constant = JText::_( 'FLY06_REG_PB_CONFIG_MESSAGE' );
				break;
			case 1: // Server configuration
				$subject_constant = JText::_( 'FLY06_REG_PB_SERVER_SUBJECT' );
				$message_constant = JText::_( 'FLY06_REG_PB_SERVER_MESSAGE' );
				break;				
		}	
	
		$subject = sprintf( $subject_constant, $this->params->get('notify_fromname'), $now);
		$message = $message_constant;
				
  		$sent = $this->_sendMail($this->admin_email, $subject, $message);

	}
	
	function remoteConnexionFailed() {
			
		// Notification admin
		if ($this->params->get('admin_notification_cnx')) {
			//$device = (	$this->params->get('curl_loaded') ? 'cURL' : 'fopen');
			$device = ($this->curl_loaded ? 'cURL' : 'fopen');
			$subject = sprintf(	JText::_( 'FLY06_REG_URL_ERR_SUBJECT' ), 
						$this->params->get('notify_fromname'), 
						$this->base_url
						);
			$message = sprintf(	JText::_( 'FLY06_REG_URL_ERR_MESSAGE' ), 
						$this->base_url, 
						$this->now, $device, 
						$this->base_url,
						$this->cnx_err_no,
						$this->cnx_err_str
						);
			$sent = $this->_sendMail($this->admin_email, $subject, $message);
		}
		
		// Redirection
		if ($this->params->get('error_url_handling')) {
			// On bloque l'enregistrement (redirection)
			$msg = JText::_( 'FLY06_REG_PROBLEM_OCCURRED' );
			$type = $this->params->get('msgtype_connexion_failed');	
			$this->_redirect($msg, $type); 
		} 
		
		// Si pas de redirection, on retourne true de façon à arrêter l'exécution du script
		// L'action (enregistrement ou modification profil) se déroule alors normalement
		return true;
				
	}

	
	///////////////////////////////////////////////////////////
	// Méthodes privées
	///////////////////////////////////////////////////////////	
	
	function _openConnexionToSFS($url) {
		
		$xml = '';
		
			switch ($this->curl_loaded) {
				case 0: // Fopen
					set_error_handler(array($this, '_sbFopenErrorHandler'));
					$xml = @fopen($url, "r");
					restore_error_handler();
					break;
				case 1: // cURL
					$curl_handler = curl_init();
					curl_setopt($curl_handler, CURLOPT_URL, $url);
					curl_setopt($curl_handler, CURLOPT_TIMEOUT, $this->params->get('curlopt_timeout'));
					curl_setopt($curl_handler, CURLOPT_CONNECTTIMEOUT, $this->params->get('curlopt_connect_timeout'));
					curl_setopt($curl_handler, CURLOPT_HEADER, false);
					curl_setopt($curl_handler, CURLOPT_RETURNTRANSFER, true);					
					$xml = curl_exec($curl_handler);
					if ($xml === false) {
						$this->cnx_err_no = curl_errno($curl_handler);
						$this->cnx_err_str = curl_error($curl_handler);
					}
					curl_close($curl_handler);
					break;				
			}	
				
		return $xml;
			
	}

	function _sbFopenErrorHandler($errno, $errstr) {

		$this->cnx_err_no = $errno;
		$this->cnx_err_str = $errstr;

		return true;		

	}
	
	function _blockUserAccount() {
	
		global $mainframe;

		$user_account_blocked = 0;

		$database = &JFactory::getDBO();
	
		// Si l'on souhaite bloquer l'utilisateur dans ce cas ($user_edit_mode == 2 ou 3)
		// ==>
		// On bloque l'utilisateur
		// On déconnecte l'utilisateur
			
		// L'utilisateur est-il déjà dans les logs ?
		$query = "SELECT * FROM #__spammerblocker_log WHERE user_id=" . $this->id;
		$database->setQuery($query);
		$database->query();
		$already_logged = $database->getNumRows();
			
		if (($this->params->get('user_edit_mode') == 3) || (($this->params->get('user_edit_mode') == 2) && ($already_logged))) {

				$query = "UPDATE #__users SET block = 1 WHERE id = " . $this->id;
				$database->setQuery( $query );
				$database->query();
				
				$user_account_blocked = 1;
				
				// Déconnexion de l'utilisateur avec conservation de la session
				// Permet l'affichage du message de redirection
				$this->_smoothLogoff();
				
				if ($this->params->get('user_notification')) {
							
					// Récupération de l'email du user
					$query = "SELECT * FROM #__users WHERE id = " . $this->id;
					$database->setQuery( $query );
					$user = $database->loadObject();

					// Envoi notification user
					$siteURL		= JURI::base();
					$sitename = $mainframe->getCfg( 'sitename' );
					$subject = sprintf(JText::_( 'FLY06_REG_USER_ACCOUNT_BLOCKED_SUBJECT' ), $user->name, $sitename );
					$message = sprintf(JText::_( 'FLY06_REG_USER_ACCOUNT_BLOCKED_MSG' ), $user->name, $siteURL);
					$sent = $this->_sendMail($user->email, $subject, $message);
					
				}
				
		}

	return $user_account_blocked;	

	}
	
	function _readXML($xml) {
		
		$is_bad = false;
		
			switch ($this->curl_loaded) {
				case 0: // Fopen ==> $xml est un fichier
					while (!feof($xml)) {
						$line = fgets($xml, 1024);
						if (preg_match("#<appears>(.*)</appears>#Ui", $line, $out)) {
							$is_bad = $out[1];
							break;
						}
					}
					fclose($xml);
					break;
				case 1: // cURL ==> $xml est une chaîne de caractères
					if (preg_match("#<appears>(.*)</appears>#Ui", $xml, $out)) $is_bad = $out[1];
					break;				
			}
				
	return $is_bad;
			
	}

	function _sendMail($mailto, $subject, $message) {
 
 		$mail =& JFactory::getMailer();
		$mail->addRecipient($mailto);
		$mail->setSubject($subject);
		$message = html_entity_decode($message, ENT_QUOTES);
		$mail->setBody($message);
		$sender = array( $this->params->get('notify_mailfrom'), $this->params->get('notify_fromname' ) );
		$mail->setSender($sender);
		$sent = $mail->send();
				
		return $sent;
			
	}	
	
	function _logSpammer() {
		
		$db =& JFactory::getDBO();
			
		$email = $db->getEscaped( trim( $this->user_data['email'] ) );
		$username = $db->getEscaped( trim( $this->user_data['username'] ) );
		$ip = $db->getEscaped( trim( $this->user_data['ip'] ) );
		
		$email_status = $this->_getStatus($this->use_it['email'], $this->is_bad['email']);
		$username_status = $this->_getStatus($this->use_it['username'], $this->is_bad['username']);
		$ip_status = $this->_getStatus($this->use_it['ip'], $this->is_bad['ip']);
						
		$user_id = $this->id;
		
		$query = 'INSERT INTO #__spammerblocker_log VALUES (0, "' . $email . '", "' . $username . '", "' . $ip . '", "' . $email_status . '", "'. $username_status . '", "'. $ip_status . '", "'. $user_id . '", NOW() )';
		$db->setQuery( $query );
		$db->query();
			
	}
	
	function _getStatus($use, $is_bad) {
	
		if (!$use) return -1;
		
		if ($is_bad == 'yes') return 1;
		
		return 0;
		
	}
	
	function _redirect($message, $type) {
	
		global $mainframe;
		
		switch ($this->params->get('redir_mode')) { 
			case 1:// js
				$js = '<script>alert("' . $message . '");</script>';
				if (!$this->params->get('redir_to') && $this->params->get('redir_url')) {
					$js .= '<script>document.location.href="' . $this->params->get('redir_url') . '";</script>';
				} else {
					$js .= '<script> window.history.go(-1); </script>';
				}
				
				header('Content-Type: text/html; charset=UTF-8');
				echo $js;
				$mainframe->close();
				break;
			case 0: // php
			default:
				if (!$this->params->get('redir_to') && $this->params->get('redir_url')) {
					$url = $this->params->get('redir_url');
				} else {
					$url = $this->_getPreviousUrl();
				}
				$mainframe->redirect($url, $message, $type);
				break;
		}
	
	}

	function _getPreviousUrl() {
	
		$uri = JURI::getInstance();
		
		$uri->setVar('option', $this->option);
		
		switch ($this->option) {
			case 'com_comprofiler' :
				if ($this->task == 'saveregisters') {
					$task = 'registers';
				} else {
					$task = 'userDetails';				
				}
				break;
			case 'com_virtuemart' :
				if ($this->func == 'shopperadd') {
					$page = 'shop.registration';
				} else {
					$page = 'account.billing';				
				}			
				break;
			case 'com_juser' :
				if ($this->task == 'saveUserRegistration') {
					$task = 'UserRegistration';
				} else {
					$task = 'UserDetails';				
				}			
				break;
			case 'com_user' :
			default: 
				if ($this->task == 'register_save') {
					$task = 'register';
				} else {
					$task = 'edit';	
					$view = 'user';
				}			
				break;
		}

		if (isset($view)) $uri->setVar('view', $view);		
		if (isset($task)) $uri->setVar('task', $task);
		if (isset($page)) $uri->setVar('page', $page);
		
		if ($this->params->get('redir_use_itemid') && $this->Itemid) $uri->setVar('Itemid', $this->Itemid);
		
		$url = JRoute::_('index.php'.$uri->toString(array('query', 'fragment')), false);
		
		return $url;
	
	}

	function _smoothLogoff() {
	
		// User session variables
		$session =& JFactory::getSession();
		$session->clear('user');

		// User session fields
		$table = & JTable::getInstance('session');
		$table->load( $session->getId() );

		$table->guest 		= 1;
		$table->username 	= '';
		$table->userid 		= 0;
		$table->usertype 	= '';
		$table->gid 		= 0;

		$table->update();
		
	}
	
} // Fin helper class

?>
