<?php

/*if(!defined('INCLUDE_CHECK')) die('You are not allowed to execute this file directly - functions');
*/
require_once 'config.php';

function checkEmail($str)
{
	return preg_match("/^[\.A-z0-9_\-\+]+[@][A-z0-9_\-]+([.][A-z0-9_\-]+)+[A-z]{1,4}$/", $str);
}

function IsNullOrEmptyString($question){
    return (!isset($question) || trim($question)==='');
}

function getUserTickets($userId)
{
     global $appConfig;
    try {
    # MySQL with PDO_MYSQL
    $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
    }
        catch(PDOException $e) {
        echo $e->getMessage();
    }
    $mainSQL = "SELECT * FROM tbl_tickets where userid = ?";
     # setting the fetch mode
    $statement = $db->prepare($mainSQL);
    $statement->setFetchMode(PDO::FETCH_ASSOC);
    $statement->execute(array(intval($userId)));
    $userTicketList="";
    while($row = $statement->fetch()) {
           $userTicketList .= '<li>Island : '.$row['isle'].', Ticket ID: '.$row['ticketid'].', Ticket Type: '.$row['tickettype'].'</li>';
    }
    return $userTicketList;
}

/*
 * Generates Random md5String based on Time() and Rand()
 */
function generateCustomTxnId(){
return md5(time()+rand(1, 1000));
}

 function VisitorIP()
    {
    if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $TheIp=$_SERVER['HTTP_X_FORWARDED_FOR'];
    else $TheIp=$_SERVER['REMOTE_ADDR'];
    return trim($TheIp);
    }


function genarateTicket()
{
    $rest = substr(md5(microtime()+rand(1,1000)), 0, 12);
    return $rest; //Print our randomly generated string
}

function insertTickets($sid,$type,$email,$isle)
{
    global $appConfig;
    try {
    # MySQL with PDO_MYSQL
    $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
    }
        catch(PDOException $e) {
        echo $e->getMessage();
    }

    $created_on = date("yyyy-mm-dd hh:mm:ss", time());
    if($type == 'dot5')
    {
	$statement1 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement1->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
    }

    if($type == 'dot10')
    {
	$statement2 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement2->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
	$statement3 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement3->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
    }
    if($type == 'dot15')
    {
	$statement4 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement4->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
	$statement5 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement5->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
	$statement6 = $db->prepare("INSERT INTO `tbl_tickets` (`userid`, `ticketid`, `tickettype`, `datebought`, `emailbought`, `IP`,`isle`) VALUES (?, ?, ?, ?, ?, ? ,?)");
	$statement6->execute(array($sid, genarateTicket(),$type,$created_on,$email,$_SERVER['REMOTE_ADDR'],$isle));
    }
}

function checkDoubleEmailPromote($email)
    {
        $appConfig = new config();
        try {
        # MySQL with PDO_MYSQL
        $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
        }
            catch(PDOException $e) {
            echo $e->getMessage();
        }
        $mainSQL= "SELECT count(*) FROM tbl_promote WHERE tbl_promote.email = '".$email."'";
        $nRows = $db->query($mainSQL)->fetchColumn();
        if($nRows>0)
            return 1;
        else
            return 0;
    }


function checkDoubleEmail($email)
    {
        $appConfig = new config();
        try {
        # MySQL with PDO_MYSQL
        $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
        }
            catch(PDOException $e) {
            echo $e->getMessage();
        }
        $mainSQL= "SELECT count(*) FROM tbl_members WHERE tbl_members.email = '".$email."'";
        $nRows = $db->query($mainSQL)->fetchColumn(); 
        if($nRows>0)
            return true;
        else
            return false;
    }

    
function logdblocal($txt)
{
    global $appConfig;
    $appConfig = new config();
    try {
    # MySQL with PDO_MYSQL
    $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
    }
        catch(PDOException $e) {
        echo $e->getMessage();
    }
    $statement2 = $db->prepare("INSERT INTO `tlog` (`tlog`) values( ? )");
    $statement2->execute(array($txt));
    $db=null;$statement2=null;
}
    
function updateInvited($email)
{
	global $appConfig;
        try {
        # MySQL with PDO_MYSQL
        $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass, array(PDO::MYSQL_ATTR_FOUND_ROWS => true));
        }
            catch(PDOException $e) {
            echo $e->getMessage();
        }
        $mainSQL= "UPDATE `tbl_promote` SET `emailIsReg`='1', `emailUsedForTag`='1' WHERE (`email`= ? )";
        $nRows = $db->query($mainSQL)->fetchColumn(); 
	$db=null;
	$nRows=null;
}


function mail_pass($from,$to,$subject,$body){
    try {
        require_once("class.phpmailer.php");
        $mail = new PHPMailer();
	$mail->CharSet = 'UTF-8';
        $mail->IsMail();      // telling the class to use PHP's Mail()
        $mail->AddReplyTo($from,'World Top Island');
        $mail->From       = $from;
        $mail->FromName   = 'World Top Island';
        $mail->AddReplyTo($from);
        $mail->From       = $from;
        $mail->FromName   = $from;
        $mail->AddAddress($to);
        $mail->Subject  = $subject;

        require_once('class.html2text.inc.php');
        $h2t = new html2text($body);
        $mail->AltBody = $h2t->get_text();
        //$mail->AltBody    = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
        $mail->WordWrap   = 80; //set word wrap

        $mail->MsgHTML($body);

        $mail->IsHTML(true); // send as HTML

  
        try {
        if ( !$mail->Send() ) {
          $error = "Unable to send to: " . $to . "<br />";
          throw new phpmailerAppException($error);
        } else {
          echo 'Message has been sent<br /><br />';
        }
        }
        catch (phpmailerAppException $e) {
        $errorMsg[] = $e->errorMessage();
        }

        if ( count($errorMsg) > 0 ) {
        foreach ($errorMsg as $key => $value) {
          $thisError = $key + 1;
          echo $thisError . ' : ' . $value;
        }
        }
  }
  catch (Exception $e) {
      foreach ($errorMsg as $key => $value) {
          logdblocal($key.' <-=-> '.$value);
      }
  }	
}


function db_getIsleID($isleName){
    global $appConfig;
    try {
    # MySQL with PDO_MYSQL
    $db = new PDO("mysql:host=".$appConfig->sqlhost.";dbname=".$appConfig->sqldb, $appConfig->sqluser, $appConfig->sqlpass);
    }
	catch(PDOException $e) {
	echo $e->getMessage();
    }
    logdblocal("SELECT tbl_menuislandsuk.isleId FROM tbl_menuislandsuk WHERE tbl_menuislandsuk.isleName = '".$isleName."'");
    $mainSQL = "SELECT tbl_menuislandsuk.isleId FROM tbl_menuislandsuk WHERE tbl_menuislandsuk.isleName =  ?";
    # setting the fetch mode
    $statement = $db->prepare($mainSQL);
    $statement->setFetchMode(PDO::FETCH_ASSOC);
    $statement->execute(array($isleName));
    while($row = $statement->fetch()) {
           return $row['isleId'];
    }
}


function getVoteRank ($isleId)
{
    global $appConfig;
    $link = mysql_connect($appConfig->sqlhost,$appConfig->sqluser,$appConfig->sqlpass) OR die(mysql_error());
    mysql_select_db($appConfig->sqldb, $link);
    mysql_query("SET NAMES utf8;");
    $isleId = intval($isleId);
    $result = mysql_query("SELECT rating FROM ratings WHERE id = ".$isleId,$link) or die(mysql_error());;
    $votesnr = 0;
    $totalvotes = 0;
    $rating = 0;
    while($vote = mysql_fetch_array($result)){
	$votesnr++;
	$curRate = intval($vote['rating']);
	$totalvotes += $curRate;
    }
    if($votesnr == 0){
	$rating = 0;
    }
    else {
	$rating = ($totalvotes/$votesnr);
    }
    $roundedrating = floor($rating) + round($rating - floor($rating))/2;
    $cResult['roundedrating'] = $roundedrating;
    $cResult['rating'] = $rating;
    $cResult['votesnr'] = $votesnr;
    mysql_free_result($result);
    mysql_close($link);
    return $cResult;
}



function send_mail($from,$to,$subject,$body)
{
	$headers = '';
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
	$headers  = 'MIME-Version: 1.0' . "\r\n";
        $headers .= "From: $from\n";
	$headers .= "Reply-to: $from\n";
	$headers .= "Return-Path: $from\n";
	$headers .= "Message-ID: <" . md5(uniqid(time())) . "@" . $_SERVER['SERVER_NAME'] . ">\n";
	$headers .= "Date: " . date('r', time()) . "\n";

	mail($to,$subject,$body,$headers);
}

#Get Only Number (0-9)
function get_num($key){ return preg_replace('~[^0-9]~', '', $key);}
#Get Only Latin Characters ((A-Z ,a-z)
function getchar($key){ return preg_replace('~[^A-Za-z]~', '', $key);}
#Get Latin Characters & Number (A-Z ,a-z And 0-9)
function getchar_num($key){ return preg_replace('~[^A-Za-z0-9]~', '', $key);}
#Get Latin Characters, Space & Number
function getchar_num_space($key){return preg_replace('~[^A-Za-z0-9 ]~', '', $key);}
#Get  Characters, Space & Number and dot and comma for payments float and double numbers
function getchar_num_double($key){return preg_replace('~[^A-Za-z0-9., ]~', '', $key);}
#Get IP
function get_ip($key){ return preg_replace('~[^0-9.]~', '', $key);}
#Get Cookie
function get_cookie($key){return preg_replace('~[^A-Za-z0-9&]~', '', $key);}
#Get Active Key (num and -)
function get_activekey($key){ return preg_replace('~[^0-9-]~', '', $key);}
#Get E-mail
function get_mail($key){
	$mail = preg_replace('~[^A-Za-z0-9._%-@]~', '', $key);
	#Get E-mail address validation form Info: http://www.ars-informatica.ca/article.php?article=46
	if (!preg_match("/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i",$mail)){
	     $mail ='';
	}
return $mail;
}

function validateURL($URL) {
    $v = "/^(http|https|ftp):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i";
    return (bool)preg_match($v, $URL);
}


function validateURL2($url){
$pattern = '/^(([w]+:)?//)?(([dw]|%[a-fA-fd]{2,2})+(:([dw]|%[a-fA-fd]{2,2})+)?@)?([dw][-dw]{0,253}[dw].)+[w]{2,4}(:[d]+)?(/([-+_~.dw]|%[a-fA-fd]{2,2})*)*(?(&?([-+_~.dw]|%[a-fA-fd]{2,2})=?)*)?(#([-+_~.dw]|%[a-fA-fd]{2,2})*)?$/';
return preg_match($pattern, $url);
}

?>