<?php

//**************************************************************
// Fly06 Spammer Blocker for Joomla 1.5              
// Copyright (C) 2009-2010 by Frdric Leroy (aka Fly06)   
// --------------- All Rights Reserved ----------------      
// Homepage   : http://www.fly06.fr/        
// Version    : 1.1 beta    
// Date       : 06/04/10
// License    : GNU/GPL            
//**************************************************************
// APIs : Stop Forum Spam
// http://www.stopforumspam.com/
//**************************************************************

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );

/**
 * @package		Joomla
 * @subpackage	SpammerBlocker
 */
class SpammerBlockerModelSpammerBlocker extends JModel {

	/**
	* Liste des lments de fotmulaires
	* @var array
	*/
	var $_html = null;

	/**
	* Total des logs  afficher
	* @var integer
	*/
	var $_total = null;

	/**
	* Pagination
	* @var object
	*/
	var $_pagination = null;
	
	/**
	* Liste des logs  afficher
	* @var array
	*/
	var $_data = null;
	
	/**
	 * Overridden constructor
	 * @access	protected
	 */
	function __construct()
	{
		parent::__construct();
		
		global $mainframe, $option;
		
		// Rcupration des paramtres Request/Session/Config
		$filter_order		= $mainframe->getUserStateFromRequest( $option.'filter_order',		'filter_order',		'date', 'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $option.'filter_order_Dir',	'filter_order_Dir',	'asc', 'word' );
		
		/*
		echo '> ' . $filter_order_Dir . ' <';
		global $mainframe;
		$mainframe->close();
		*/
		
		$limit				= $mainframe->getUserStateFromRequest( 'global.list.limit',				'limit',			$mainframe->getCfg('list_limit'), 'int' );
		$limitstart			= $mainframe->getUserStateFromRequest( $option.'.limitstart',			'limitstart',		0,		'int' );
		
 		// In case limit has been changed, adjust it
    $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		
		// Custom Filters
		$filter_user = $mainframe->getUserStateFromRequest( $option.'.filter_user', 'filter_user', '0', 'string' ); 
		$filter_date = $mainframe->getUserStateFromRequest( $option.'.filter_date', 'filter_date', '0', 'string' ); 
		$filter_detection = $mainframe->getUserStateFromRequest( $option.'.filter_detection', 'filter_detection', '0', 'string' ); 
				
		// Search Filter
		$search				= $mainframe->getUserStateFromRequest( $option.'.search',				'search',			'',		'string' );
		$search				= JString::strtolower( $search );
		
		// Config Compo
		$params = &JComponentHelper::getParams( 'com_spammerblocker' );
		$enabled = $params->get('enabled');	
		$highlighting = $params->get('highlighting');			
		$show_user_status = $params->get('show_user_status');	
		
		// Sauvegarde des paramtres Request/Session
		$this->setState('filter_order', $filter_order);
		$this->setState('filter_order_Dir', $filter_order_Dir);		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);		
		
		$this->setState('filter_user', $filter_user);
		$this->setState('filter_date', $filter_date);		 
		$this->setState('filter_detection', $filter_detection);
		
		$this->setState('search', $search);
		
		$this->setState('enabled', $enabled);
		$this->setState('highlighting', $highlighting);		 
		$this->setState('show_user_status', $show_user_status);		
		
	}
	
	// CONSTRUCTION DES ELEMENTS DE FORMULAIRE
	function getHtml() {
		
		if (empty($this->_html)) {
			
			// table ordering
			$filter_order_Dir = $this->getState('filter_order_Dir');

			if ( $filter_order_Dir == 'asc' ) {
				$this->_html['order_Dir'] = 'asc';
			} else {
				$this->_html['order_Dir'] = 'desc';
			}
			$this->_html['order'] = $this->getState('filter_order');

			// Detection filter
			$this->_html['detection'] = $this->_buildHtmlDetectionFilter();

			// Date filter
			$this->_html['date'] = $this->_buildHtmlDateFilter();
	
			// Search filter
			$this->_html['search']= $this->getState('search');

			// User filter
			$this->_html['user'] = $this->_buildHtmlUserFilter();		
			
			// Highlighting
			$highlighting = $this->getState('highlighting');
			if ($highlighting) $this->_html['highlighting'] = $this->_buildHtmlHighlighting();
			
		}
		
		return $this->_html;
		
	}
	
	// CALCUL DU NOMBRE TOTAL D'ITEMS
	function getTotal() {
		
		if (empty($this->_total)) {
			
			$query = 'SELECT *'
			. ' FROM #__spammerblocker_log AS s LEFT OUTER JOIN #__users AS u'
			. ' ON u.id = s.user_id'
			. $this->_buildContentWhere();
		
			$this->_total = $this->_getListCount($query);
		
		}
		
		return $this->_total;
		
	}
	
	// CONSTRUCTION DE LA PAGINATION
	function getPagination() {
		
		if (empty($this->_pagination)) {
			
			jimport( 'joomla.html.pagination' );
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		
		}		
		
		return $this->_pagination;
		
	}
	
	// RECUPERATION DE LA LISTE DES LOGS A AFFICHER
	function getData( )	{
		
		if (empty($this->_data)) {	
			
			//global $mainframe, $option;
			
			// Construction de la requte
			$query = ' SELECT s.id, s.email, s.username, s.ip, s.email_status, s.username_status, s.ip_status, s.user_id, s.date, u.name, u.block'
			. ' FROM #__spammerblocker_log AS s LEFT OUTER JOIN #__users AS u'
			. ' ON u.id = s.user_id'
			. $this->_buildContentWhere()
			. $this->_buildContentOrderBy()
			;
			
			// Rcup des donnes en base via la mthode _getList
			$rows = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
			
			// Ajout d'un champs user_link 
			$rows = $this->addDataUserLink($rows);
		
			// Ajout de la coloration smantique (optionnelle)
			$rows = $this->addDataHighlighting($rows);
			
			$this->_data = $rows;
		
		}

		return $this->_data;
	}
	
	//***********************************************************************
	// METHODES PRIVEES
	//***********************************************************************
	
	// Mthode prive : Retourne la clause where
	function _buildHtmlHighlighting() {
		
			// Ajout lgende en bas de page		
			$html = JText::_( 'SB_HIGHLIGHTING_LEGEND' );
		
		return $html;
		
	}	
	
	// Mthode prive : Retourne la clause where
	function _buildContentWhere() {
		
		$where = array();
		
		// User filter	
		$where = $this->_getWhereUser($where);

		// Detection filter		
		$where = $this->_getWhereDetection($where);	
		
		// Date filter		
		$where = $this->_getWhereDate($where);	

		// Search filter		
		$where = $this->_getWhereSearch($where);
			
		// Construction de la clause where par agrgation		
		$where = ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );
		
		return $where;
		
	}
	
	// Mthode prive : Retourne la clause orderby
	function _buildContentOrderBy() {
		
		$orderby = '';
		
		$orderby 	= ' ORDER BY '. $this->getState('filter_order') .' '. $this->getState('filter_order_Dir');
		//$orderby 	= ' ORDER BY '. $this->getState('filter_order') .' '. $this->getState('filter_order_Dir') .', date DESC';
		
		return $orderby;
		
	}
		
	// Mthode prive : Retourne la bonne coloration smantique en fonction du statut
	function _getClass($status) {
		
		switch ($status) {
			case 1:
				$class = 'sb_positive';
				break;
			case 0:
				$class = 'sb_negative';
				break;
			case -1:
			default:
				$class = 'sb_unknown';
				break;									
		}	
		
		return $class;
		
	}

	// Mthode prive de construction de la clause where correspondant au Detection Filter 
	function _getWhereDetection($where) {
		
		$filter_detection = $this->getState('filter_detection');
		
		$valid_detection = array('email', 'username', 'ip');
			
		if ( $filter_detection ) {
			if (in_array($filter_detection, $valid_detection)) {
				$where[] = 's.' . strtolower($filter_detection) . '_status = 1';			
			}			
		}	
		
		return $where;
	}	
	
	// Mthode prive de construction de la clause where correspondant au User Filter 
	function _getWhereUser($where) {
		
		$filter_user = $this->getState('filter_user');
		
		switch ($filter_user) {
			case 'user_yes':
				$where[] = 's.user_id > 0';
				break;
			case 'user_no':
				$where[] = 's.user_id = 0';
				break;								
			case 'user_block_yes':
				$where[] = '(s.user_id > 0 AND u.block = 1)';
				break;
			case 'user_block_no':
				$where[] = '(s.user_id > 0 AND u.block = 0)';
				break;
			case '0':
			default:
				break;				
		}
		
		return $where;
	}	

	// Mthode prive de construction de la clause where correspondant au Date Filter 
	function _getWhereDate($where) {
		
		$filter_date = $this->getState('filter_date');
		
		$valid_period = array('day', 'week', 'month', 'year');
		
		if ( $filter_date ) {
			if (in_array($filter_date, $valid_period)) {
				$where[] = $this->_getWhereDate_2($filter_date);			
			}
		}
		
		return $where;
	}	
	
	// Mthode prive de construction de la clause where correspondant au Search 
	function _getWhereSearch($where) {
		
		$search = $this->getState('search');
		
		if ($search) {
			
			$db = & JFactory::getDBO();
			
			$where_search = array();
			$where_search[] = 'LOWER( s.email ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			$where_search[] = 'LOWER( s.username ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			$where_search[] = 'LOWER( s.ip ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			
			$where[] = ( count( $where_search ) ? '(' . implode( ' OR ', $where_search ) . ')' : '' );
		
		}
		
		return $where;
	}	
	
	// Mthode prive de construction de la clause where correspondant au Date Filter
	function _getWhereDate_2($period) {
		
		$where = ' DATEDIFF(NOW(), DATE(s.date)) < ';
		
		switch ($period) {
			case 'year' :
				$where .= 'DAYOFYEAR(NOW())';
				break;
			case 'month':
				$where .= 'DAYOFMONTH(NOW())';
				break;
			case 'week':
				$where .= 'DAYOFWEEK(NOW())';
				break;
			case 'day':
			default:
				$where .= '1';
				break;
		} 
		
		return $where;
	}

	// Mthode prive de slection de l'image  afficher
	function _getImgPath($show_user_status, $block, $img_path) {
		
		$img = $img_path['unknown'];
		
		if (!$show_user_status) {
			return $img;
		}
		
		switch ($block) {
			case '1' :
				$img = $img_path['no'];
				break;
			case '0':
				$img = $img_path['yes'];
				break;
		} 
		
		return $img;
	}
	
	// Mthode prive de construction de l'lment de formulaire 'Detection filter'
	function _buildHtmlDetectionFilter() {
		
		$filter_detection_options = array();
		$filter_detection_options[] = JHTML::_('select.option',  '0', '- '. JText::_( 'SB_SELECT_A_CRITERIA' ) .' -' );
		$filter_detection_options[] = JHTML::_('select.option',  'email', JText::_( 'SB_EMAIL' ) );
		$filter_detection_options[] = JHTML::_('select.option',  'username', JText::_( 'SB_USERNAME' ) );	
		$filter_detection_options[] = JHTML::_('select.option',  'ip', JText::_( 'SB_IP' ) );		
		$js='onchange="document.adminForm.submit() ; " ';
		$html = JHTML::_('select.genericlist', $filter_detection_options, 'filter_detection', 'class="inputbox" size="1" '. $js, 'value', 'text', $this->getState('filter_detection') );

		return $html;
	}
	
	// Mthode prive de construction de l'lment de formulaire 'Date filter'
	function _buildHtmlDateFilter() {
		
		$filter_date_options = array();
		$filter_date_options[] = JHTML::_('select.option',  '0', '- '. JText::_( 'SB_SELECT_A_PERIOD' ) .' -' );
		$filter_date_options[] = JHTML::_('select.option',  'day', JText::_( 'SB_THIS_DAY_ONLY' ) );
		$filter_date_options[] = JHTML::_('select.option',  'week', JText::_( 'SB_THIS_WEEK_ONLY' ) );	
		$filter_date_options[] = JHTML::_('select.option',  'month', JText::_( 'SB_THIS_MONTH_ONLY' ) );
		$filter_date_options[] = JHTML::_('select.option',  'year', JText::_( 'SB_THIS_YEAR_ONLY' ) );		
		$js='onchange="document.adminForm.submit() ; " ';
		$html = JHTML::_('select.genericlist', $filter_date_options, 'filter_date', 'class="inputbox" size="1" '. $js, 'value', 'text', $this->getState('filter_date') );
	
		return $html;
	}

	// Mthode prive de construction de l'lment de formulaire 'User filter'
	function _buildHtmlUserFilter() {
		
		//$params = &JComponentHelper::getParams( 'com_spammerblocker' );
		$show_user_status = $this->getState('show_user_status');		
				
		// Construction de l'lment de formulaire correspondant  $filter_user
		$filter_user_options = array();
		$filter_user_options[] = JHTML::_('select.option',  '0', '- '. JText::_( 'SB_SELECT_A_USER_TYPE' ) .' -' );
		$filter_user_options[] = JHTML::_('select.option',  'user_yes', JText::_( 'SB_USER_ONLY' ) );
		$filter_user_options[] = JHTML::_('select.option',  'user_no', JText::_( 'SB_NON_USER_ONLY' ) );	
			
		if ($show_user_status) {
			$filter_user_options[] = JHTML::_('select.option',  'user_block_yes', JText::_( 'SB_BLOCKED_USER_ONLY' ) );
			$filter_user_options[] = JHTML::_('select.option',  'user_block_no', JText::_( 'SB_NON_BLOCKED_USER_ONLY' ) );				
		}
			
		$js='onchange="document.adminForm.submit() ; " ';
		$html = JHTML::_('select.genericlist',   $filter_user_options, 'filter_user', 'class="inputbox" size="1" '. $js, 'value', 'text', $this->getState('filter_user') );

		return $html;
	}
	
	// Mthode prive d'ajout d'un champs user link dans la liste des logs  afficher
	function addDataUserLink($rows) {
		
		$show_user_status = $this->getState('show_user_status');
	
		$img_path = array();
		/*
		$img_path['unknown'] = JURI::base() . 'components' . DS . 'com_spammerblocker' . DS . 'images' . DS . 'icon-16-user.png';
		$img_path['yes'] = JURI::base() . 'components' . DS . 'com_spammerblocker' . DS . 'images' . DS . 'icon-16-user-yes.png';
		$img_path['no'] = JURI::base() . 'components' . DS . 'com_spammerblocker' . DS . 'images' . DS . 'icon-16-user-no.png';		
		*/
		$img_path['unknown'] = JURI::base() . 'components/com_spammerblocker/images/icon-16-user.png';
		$img_path['yes'] = JURI::base() . 'components/com_spammerblocker/images/icon-16-user-yes.png';
		$img_path['no'] = JURI::base() . 'components/com_spammerblocker/images/icon-16-user-no.png';	
		
		$img_path['unknown'] = str_replace( '\\' , DS , $img_path['unknown'] ); 
		$img_path['yes'] = str_replace( '\\' , DS , $img_path['yes'] ); 
		$img_path['no'] = str_replace( '\\' , DS , $img_path['no'] ); 
							
		for ($i=0, $n = count($rows); $i < $n; $i++) {

			if ( $rows[$i]->user_id ) {
				$user_link = '<a target="popup" href="index3.php?option=com_users&view=user&task=edit&cid[]=' . $rows[$i]->user_id . '" onclick="window.open(\'\',\'popup\',\'resizable=yes,status=no,toolbar=no,location=no,scrollbars=yes,width=690,height=560\')" title="' . sprintf(JText::_('SB_SHOW_USER_PROFILE'), $rows[$i]->name) . '">';
				$user_link .= '<img src="' . $this->_getImgPath($show_user_status, $rows[$i]->block, $img_path) . '" width="16" height="16">';
				$user_link .= '</a>';
				$rows[$i]->user_link = $user_link;
			} else {
				$rows[$i]->user_link = null;
			}
			
		}
		
		return $rows;
		
	}
	
	// Mthode prive d'ajout de la coloration smantique dans la liste des logs  afficher
	function addDataHighlighting($rows) {
	
		//$params = &JComponentHelper::getParams( 'com_spammerblocker' );
		$highlighting = $this->getState('highlighting');	
		
		if ($highlighting) {
			
			//Ajout Feuille de style dans le head
			//JHTML::stylesheet('spammerblocker.css', JURI::base() . 'components' . DS . 'com_spammerblocker' . DS . 'css' . DS);
			JHTML::stylesheet('spammerblocker.css', JURI::base() . 'components/com_spammerblocker/css/');
			
			for ($i=0, $n = count($rows); $i < $n; $i++) {

					$rows[$i]->email = '<span class="' . $this->_getClass($rows[$i]->email_status) . '">' . $rows[$i]->email . '</span>';
					$rows[$i]->username = '<span class="' . $this->_getClass($rows[$i]->username_status) . '">' . $rows[$i]->username . '</span>';
					$rows[$i]->ip = '<span class="' . $this->_getClass($rows[$i]->ip_status) . '">' . $rows[$i]->ip . '</span>';
										
			}
	
		}
		
		return $rows;
		
	}

}