<?php
/**
* @version		$Id: modalmessages.php $
* @package		Joomla
* @copyright	Copyright (C) 2010 Crossing Hippos - Babs Gsgens. All rights reserved.
* @license		GNU/GPL
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * Joomla! Debug plugin
 *
 * @package		Joomla
 * @subpackage	System
 */
class  plgSystemModalmessages extends JPlugin
{
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since	1.0
	 */
	function plgSystemModalmessages(& $subject, $config)
	{
		parent::__construct($subject, $config);
	}
	
	/*
	 * Load javascript voor message modal box
	 */
	function onAfterInitialise()
	{
		global $mainframe;
		
		$scope	= $this->params->get('scope', 0);
		
		// Check if we are in the frontend or the backend
		switch($scope) {
			case 0:
				$active = true;
				break;
			case 1:
				$active = JPATH_BASE == JPATH_SITE ? true : false;
				break;
			case 2:
				$active = JPATH_BASE == JPATH_ADMINISTRATOR ? true : false;
				break;
		}
		
		if($mainframe->getMessageQueue() && $active) {
			
			// Load the mootools library, we need it
			JHTML::_('behavior.modal');
			
			$document =& JFactory::getDocument();
			
			// Intialize some config variables
			$opacity		= $this->params->get('overlay_opacity', 0);
			$custom_class	= $this->params->get('custom_class', 'modal-message');
			$custom_css_frontend = $this->params->get('custom_css_frontend');
			$custom_css_backend	 = $this->params->get('custom_css_backend');
			
			// System Messages Overrides
			$document->addStyleDeclaration("
			#system-message { visibility: hidden; display: none; }
			#sbox-content #system-message { visibility: visible !important; display: block !important; }
			");
			
			if(JPATH_BASE == JPATH_SITE && !$custom_css_frontend)
				$document->addStyleSheet(JURI::root().'plugins/system/modalmessages/modalmessages.css');
				
			elseif(JPATH_BASE == JPATH_ADMINISTRATOR && !$custom_css_backend)
				$document->addStyleSheet(JURI::root().'plugins/system/modalmessages/modalmessages.css');
							
			// Load the magic
			$document->addScriptDeclaration("
				window.addEvent('domready', function(){
					var message = SqueezeBox.fromElement( $('system-message'), {
						size: {x: 600, y: 100},
						handler: 'adopt', // this is what's moving the message inside the modal box
						closable: true,
						closeBtn: true,
						overlayOpacity: $opacity,
						classWindow: '$custom_class'
						
						/*
						Alternate attributes:
						onOpen: $empty,
						onClose: $empty,
						onUpdate: $empty,
						onResize: $empty,
						onMove: $empty,
						onShow: $empty,
						onHide: $empty,
						sizeLoading: {x: 600, y: 100},
						marginInner: {x: 0, y: 0},
						marginImage: {x: 0, y: 0},
						target: null,
						zIndex: 65555,
						classOverlay: '',
						overlayFx: {},
						resizeFx: {},
						contentFx: {},
						parse: false, // 'rel'
						parseSecure: false,
						shadow: true,
						document: null,
						ajaxOptions: {},
						*/
					});
				});
			");
		}
	}
}