<?php
# Copyright 2008 eriestuff.blogspot.com

## SET HARDCODED VARS #######################################################################################################################################################
// google maps api key
define('GOOGLE_MAPS_API_KEY',       'ABQIAAAAwhB3lTdaZFrJsKa0FPFlVhQgDxaUP40jgCyfoOcj_n5cTh0q5hSHBxVoo-0EDWgn3iSgL0e1D6vn1w');
define('GOOGLE_AJAX_SEARCH_API_KEY','ABQIAAAAwhB3lTdaZFrJsKa0FPFlVhQgDxaUP40jgCyfoOcj_n5cTh0q5hSHBxVoo-0EDWgn3iSgL0e1D6vn1w');
// google analitics id
define('GOOGLE_ANALITICS_ID','UA-2964824-2');
// set special request defaults
$q='cafe';
// - map initial center and zoom level
$lat = '52.365014022082676';
$lng = '4.893208140209909';
// - map zoomlevel
$zoom = 12;


## HANDLE REQUEST VARS ######################################################################################################################################################
// overwrite with requested url/query
$q   = (isset($_REQUEST['q']))?urldecode($_REQUEST['q']):$q;

## OUTPUT HTML ###############################################################################################################################################################
// start output
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<title>Convex Hull - Gmaps - Eriestuff</title>
	<link rel="stylesheet" href="./css/style.css" type="text/css" media="screen" />
	<script src="http://www.google.com/jsapi?key=<?php echo GOOGLE_AJAX_SEARCH_API_KEY ?>" type="text/javascript" ></script>
	<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo GOOGLE_MAPS_API_KEY ?>" type="text/javascript"></script>
	<script type="text/javascript">//<![CDATA[

// load Google Search API
google.load("search", "1");

// set user defined constants
var START_LOCATION 		= <?php echo "['$lat','$lng']" ?>;
var START_ZOOM			= <?php echo $zoom ?>;
var ID_MAP_DIV			= 'map';
var ID_PLACEMARK_FORM	= 'formPlacemarks';
 
// initialize global vars
var map;
var form;
var convexHull;
var markerimages = [];
markerimages[0] = "./img/blue_MarkerA.png";
markerimages[1] = "./img/blue_MarkerB.png";
markerimages[2] = "./img/blue_MarkerC.png";
markerimages[3] = "./img/blue_MarkerD.png";
markerimages[4] = "./img/blue_MarkerE.png";
markerimages[5] = "./img/blue_MarkerF.png";
markerimages[6] = "./img/blue_MarkerG.png";
markerimages[7] = "./img/blue_MarkerH.png";
markerimages[8] = "./img/blue_MarkerI.png";
markerimages[9] = "./img/blue_MarkerJ.png";
markerimages[10] = "./img/blue_MarkerK.png";
markerimages[11] = "./img/blue_MarkerL.png";

// set onload function
window.onload = onLoad; if (window.captureEvents) window.captureEvents(Event.LOAD);


function onLoad() {
	// setup Google Map
	map = new GMap2(document.getElementById(ID_MAP_DIV));
	map.setCenter(new GLatLng(START_LOCATION[0],START_LOCATION[1]), START_ZOOM);
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.enableScrollWheelZoom();
	map.enableGoogleBar();
	// add onclick functionalities to map
	GEvent.addListener(map, "click", function(overlay, point){
		if(!overlay){
			// add new marker
			addMarkerAndCheckbox(map,overlay,point,null,ID_PLACEMARK_FORM);
			// drawConvex hull
			drawConvexHull(map,form);
		}
	});

	// setup placemark checkbox form
	form = document.getElementById(ID_PLACEMARK_FORM);
}

function addMarkerAndCheckbox(gMap,gOverlay,gLatLng,strLabel,idTargetElm){
	var CHECKBOX_BASE_ID = 'placemark_checkbox_';
	// place new marker and save position, if click returned a gLatLng
	if (!gOverlay) {
		// gMap is clicked, not an gOverlay
		// build new marker
		var gMarker = new GMarker(gLatLng,{draggable: true});
		// place on gMap
		gMap.addOverlay(gMarker);
		// add marker events 
		gMarker.bindMarkerEvents();
		// add position to placemark form
		// - get next id
		var id = 1; while(document.getElementById(CHECKBOX_BASE_ID+id)) id++;
		// - build form elements
		var elBr = document.createElement('BR');
		var elCheckbox = document.createElement('INPUT');
		elCheckbox.type='checkbox';
		elCheckbox.id = CHECKBOX_BASE_ID+id
		elCheckbox.name = 'Placemark '+id
		elCheckbox.value = gLatLng;
		elCheckbox.defaultChecked = true;
		elCheckbox.marker = gMarker;
		elCheckbox.marker.name = elCheckbox.name;
		elCheckbox.onclick = function(){
			// loop all checkboxes 
			var elms = document.getElementById(idTargetElm).getElementsByTagName('INPUT');
			for(i=0;i<elms.length;i++){
				if(elms[i].type == 'checkbox'){
					// if checkbox is checked, add/show a marker and save coordinate to array
					if(elms[i].checked){
						// build and/or show marker
						if(elms[i].marker){
							// marker exists, show it
							elms[i].marker.show();
						}
					}else if(elms[i].marker){
						// placemark not checked and marker exists, hide it
						elms[i].marker.hide();
					}
				}
			}			
			// (re)draw the convex hull polygon
			drawConvexHull(map,form);
		}
		if (elCheckbox.captureEvents) elCheckbox.captureEvents(Event.CLICK);
		var elLabel = document.createElement('LABEL');
		elLabel.setAttribute('for',elCheckbox.id);
		elLabel.innerHTML = (strLabel) ? strLabel : elCheckbox.name;
		// - append nieuw elements		
		var target = document.getElementById(idTargetElm);
		target.appendChild(elCheckbox);
		target.appendChild(elLabel);
		target.appendChild(elBr);
	}
}

function drawConvexHull(gMap,elmForm){
	// remove convex hull, if it exists
	if(convexHull) map.removeOverlay(convexHull);
	// get selected placemarks
	var selectedPlacemarks = new Array();
	var elms = elmForm.getElementsByTagName('INPUT');
	for(i=0;i<elms.length;i++){
		if(elms[i].type == 'checkbox' && elms[i].checked){
			selectedPlacemarks[selectedPlacemarks.length] = elms[i].marker.getLatLng();
		}
	}
	// draw convex hull
	if(selectedPlacemarks && selectedPlacemarks.length && selectedPlacemarks.length>2){
		var convexHullPoints = getConvexHullPoints(selectedPlacemarks);
		convexHull = new GPolygon(convexHullPoints,'#000000',2,.5,'#ff0000',.5,{clickable:false});
		gMap.addOverlay(convexHull);
	}
}

function getConvexHullPoints(points) {
	//find first baseline
	var maxX, minX;
	var maxPt, minPt;
	for (var idx in points) {
		// transform point to [lat,lng] array from GLatLng
		var pt = [points[idx].lat(),points[idx].lng()];
		if (pt[0] > maxX || !maxX) {
			maxPt = pt;
			maxX = pt[0];
		}
		if (pt[0] < minX || !minX) {
			minPt = pt;
			minX = pt[0];
		}
	}
	// transform point back into a GLatLng
	minPt = new GLatLng(minPt[0],minPt[1]);
	maxPt = new GLatLng(maxPt[0],maxPt[1]);
	// get all baselines
	var allBaseLines = new Array();
	var ch = [].concat(buildConvexHull([minPt, maxPt], points), buildConvexHull([maxPt, minPt], points))
	// turn baseline array into points array
	var points = new Array();
	for(var i in ch){
		points.push(ch[i][0]);
		points.push(ch[i][1]);
	}
	return points;

	// private functions
	function buildConvexHull(baseLine, points) {
		allBaseLines.push(baseLine)
		var convexHullBaseLines = new Array();
		var t = findMostDistantPointFromBaseLine(baseLine, points);
		if (t.maxPoint && t.maxPoint.lat) {
			convexHullBaseLines = convexHullBaseLines.concat( buildConvexHull( [baseLine[0],t.maxPoint], t.newPoints) );
			convexHullBaseLines = convexHullBaseLines.concat( buildConvexHull( [t.maxPoint,baseLine[1]], t.newPoints) );
			return convexHullBaseLines;
		} else {
			return [baseLine];
		}
	}
	function findMostDistantPointFromBaseLine(baseLine, points) {
		var maxD = 0;
		var maxPt = new Array();
		var newPoints = new Array();
		for (var idx in points) {
			var pt = points[idx];
			var d = getDistant(pt, baseLine);
			if ( d > 0) {
				newPoints.push(pt);
			} else {
				continue;
			}
			if ( d > maxD ) {
				maxD = d;
				maxPt = pt;
			}
		}
		return {maxPoint:maxPt, newPoints:newPoints}
	}
	function getDistant(cpt, bl) {
		// transform GLatLng into array
		cpt = [cpt.lat(),cpt.lng()];
		bl  = [[bl[0].lat(),bl[0].lng()],[bl[1].lat(),bl[1].lng()]]
		// get distance from point to baseline
		Vy = bl[1][0] - bl[0][0];
		Vx = bl[0][1] - bl[1][1];
		// return distance (dotproduct or crossproduct?)
		return (Vx * (cpt[0] - bl[0][0]) + Vy * (cpt[1] -bl[0][1]))
	}
}

var arrMarkers = new Array();
var searchRandomCounter = 0;
function searchRandom(recur){
	var recur = (recur)?true:false;
	if(!recur){
		searchRandomCounter = 0;
		// remove previous search results, if any
		while(arrMarkers.length){
			map.removeOverlay(arrMarkers[arrMarkers.length-1]);
			arrMarkers.pop();
		}
		// start recur loop
		searchRandom(true);
		return;
	}else{
		searchRandomCounter++;
		if(convexHull){
			var query = document.getElementById("query").value;
			var southWest = convexHull.getBounds().getSouthWest();
			var northEast = convexHull.getBounds().getNorthEast();
			var lngSpan = northEast.lng() - southWest.lng();
			var latSpan = northEast.lat() - southWest.lat();
			var gPoint; var i = 0;
			do{
				gPoint = new GLatLng(southWest.lat() + latSpan * Math.random(),southWest.lng() + lngSpan * Math.random());
			}while(!convexHull.Contains(gPoint) && i++<100);
			if(i<=100){
				gMarker = new GMarker(gPoint);
				gMarker.convexHull = convexHull;
				gMarker.searchNearby = ErieStuff.gmaps.searchNearby;
				gMarker.searchNearby(query,searchRandomCallback);
			}
		}
	}
}
function searchRandomCallback(obj){
	var MAX_RESULT = 10;
	var MAX_SEARCH = 20;
	if(obj.gLocalSearch.results && 0 != obj.gLocalSearch.results.length){
		for(var i=0; i<obj.gLocalSearch.results.length; i++) {
			var gResult = obj.gLocalSearch.results[i];
			var gPoint = new GLatLng(gResult.lat, gResult.lng);
			// check if it is not found before
			var unique = true; var j=-1;
			while(unique && ++j<arrMarkers.length){
				unique = !(gPoint.lat() == arrMarkers[j].getLatLng().lat() && gPoint.lng() == arrMarkers[j].getLatLng().lng()); 
			}
			if(unique && obj.convexHull.Contains(gPoint)){
				// this result point is inside the convex hull polygon
				if (markerimages && markerimages.length>arrMarkers.length) {
					// use predefined img from markerimages array
					var gIcon = new GIcon(G_DEFAULT_ICON, markerimages[arrMarkers.length]);
					gMarker = new GMarker(gPoint, { icon: gIcon });
				} else {
					// use default image
					gMarker = new GMarker(gPoint);
				}
				// add marker to the map
				map.addOverlay(gMarker);
				GEvent.addListener(gMarker, "click", function() {
					this.openInfoWindowHtml(gResult.html.innerHTML);
				});
				//add marker to marker array, in order to be able to remove it
				arrMarkers.push(gMarker);
				gMarker = null;
				// result found for this random point, break from loop
				break;
			}
		}
	}
	// see if enough search results are found, or max search tries is reached
	if(arrMarkers.length<MAX_RESULT && searchRandomCounter<MAX_SEARCH){
		searchRandom(true);
	}
	return;
}


// init ErieStuff namespace object
ErieStuff = new Object();
// init Eriestuff.gmaps namespace object
ErieStuff.gmaps = new Object();

// GMarker.searchNearby
// this function should be bound to a GMarker object like so:
//	 myMarker.searchNearby = ErieStuff.gmaps.searchNearby;
// than call it like so:
//   myMarker.searchNearby(...);
// it allows for a local search around the marker
// attributes:	- strQuery - string, search terms to to query google maps with
//				- funcCallback - function, to be called with the search results, the marker object will be past to the callback function as the only argument.
//				- objOptions - object,	holding optional parameters for searchNearby callback function, 
//										the options obj is bound to the marker, to make it availablel to the callback function (to act as arguments container).
ErieStuff.gmaps.searchNearby = function(strQuery,funcCallback,objOptions){
	// bind Google Local Search object to Marker
	this.gLocalSearch = new GlocalSearch();
	// get options or set defaults
	objOptions = (objOptions)?objOptions:{}
	this.gLocalSearch.resultset 			= (objOptions.resultset)?objOptions.resultset:GSearch.LARGE_RESULTSET
	this.gLocalSearch.addressLookupDisabled	= (objOptions.addressLookupDisabled)?objOptions.addressLookupDisabled:GlocalSearch.ADDRESS_LOOKUP_DISABLED
	this.gLocalSearch.arrMarkerImgUrls 		= (objOptions.arrMarkerImgUrls)?objOptions.arrMarkerImgUrls:null;
	// bind optional other options to search object
	this.gLocalSearch.objOptions 			= objOptions;
	// set local search parameters
	this.gLocalSearch.setAddressLookupMode(this.gLocalSearch.addressLookupDisabled);
	this.gLocalSearch.setResultSetSize(this.gLocalSearch.resultset);
	// build callback closure
	gMarker = this;
	this.gLocalSearch.setSearchCompleteCallback(null, function(){funcCallback(gMarker);});
	// run the query
	this.gLocalSearch.setCenterPoint(this.getLatLng());
	this.gLocalSearch.execute(strQuery);
}

// === A method for testing if a point is inside a polygon
// === Returns true if poly contains point
// === Algorithm shamelessly stolen from http://alienryderflex.com/polygon/ 
// === rewritten for gmaps by Eriestuff.blogspot.com
GPolygon.prototype.Contains = function(gLatLng) {
	// check if point is in polygons bounds, if not than dont need to check;
	if (!this.getBounds().containsLatLng(gLatLng)) return false; 
	// point is in polygon bounds, see if it is inside the polygon
	var j=0;
	var oddNodes = false;
	var x1 = gLatLng.lng();
	var y1 = gLatLng.lat();
	for (var i=0; i < this.getVertexCount(); i++) {
		j++;
		if (j == this.getVertexCount()) {j = 0;}
		x2 = this.getVertex(i).lng(); y2 = this.getVertex(i).lat();
		x3 = this.getVertex(j).lng(); y3 = this.getVertex(j).lat();
		if (((y2 < y1) && (y3 >= y1)) || ((y3 < y1) && (y2 >= y1))){
			if ( x2 + (y1 - y2) / (y3-y2) * (x3 - x2)<x1 ){
			  oddNodes = !oddNodes
			}
		}
	}
	return oddNodes;
}

GMarker.prototype.bindMarkerEvents = function (){
	// - add marker eventlisteners
	// - - onclick -> infowindow
	GEvent.addListener(this, 'click', function(){
		var htmlString = '<h2>'+this.name+'</h2><h3>' + this.getLatLng().lat() + ',' + this.getLatLng().lng() +'</h3>';
		this.openInfoWindowHtml(htmlString);
	});
	// - - ondrag -> update COG / close info window
	GEvent.addListener(this, "drag", function(){
		this.closeInfoWindow();
		drawConvexHull(map,form);
	});
	// - - ondragend -> search nearby
	GEvent.addListener(this, "dragend", function(){
		// nothing
	});
}

	//]]></script>
</head>
<body onunload="GUnload()">
	<div id="columncontainer">
		<div id="columnleft">
			<div id="columnleftheader" >
				<h1>Convex Hull</h1>
				<a href="?q=" id="clearlink" >clear map</a> | 
				<a href="index.html" >Other Gmaps Apps</a>
			</div>
			<div id="columnleftcontent" >
				<form id="formPlacemarks" enctype="multipart/form-data" method="post" action="" >
					<p><br/></p>
					<h2>User defined placemarks:</h2>
					<h3>Click to add markers</h3>
					<h3>Drag markers to reposition</h3>
				</form>
				<br />
				<h2>Random Search in Hull:</h2>
				<form id="formSearch" enctype="multipart/form-data" method="post" action="" >
					<input type="text" id="query" name="q" value="<?php echo $q ?>" />
					<div id="attribution"></div>
					<input type="button" name="searchrandom" id="searchrandom" value="Search Random" onclick="searchRandom()" />
				</form>
			</div>
		</div>	
		<div id="columnmid">
			<div id="map" ></div>
		</div>
	</div>

	<!-- GOOGLE ANALITICS -->
	<script type="text/javascript">
		var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
		document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>
	<script type="text/javascript">
		var pageTracker = _gat._getTracker("<?php echo GOOGLE_ANALITICS_ID ?>");
		pageTracker._initData();
		pageTracker._trackPageview();
	</script>
	<!-- end analitics -->
</body>
</html>

<?php
exit;



