<?php
# Copyright 2008 eriestuff.blogspot.com


## INITIALIZE ##############################################################################################################################################################
// include polygon GEO class (which includes polygon.class.php, wich includes vertex.class.php)
require('./class/polygon.geo.class.php');
// include KML function library
require('./class/kml.lib.php');


## SET HARDCODED VARS #######################################################################################################################################################
// google maps api key
define('GOOGLE_MAPS_API_KEY',       'ABQIAAAAwhB3lTdaZFrJsKa0FPFlVhQgDxaUP40jgCyfoOcj_n5cTh0q5hSHBxVoo-0EDWgn3iSgL0e1D6vn1w');
define('GOOGLE_AJAX_SEARCH_API_KEY','ABQIAAAAwhB3lTdaZFrJsKa0FPFlVhQgDxaUP40jgCyfoOcj_n5cTh0q5hSHBxVoo-0EDWgn3iSgL0e1D6vn1w');
// google analitics id
define('GOOGLE_ANALITICS_ID','UA-2964824-2');
// set default google map url / KML url
$url='';
$q='';
// set special request defaults
$urlVrijMiBo = 'http://maps.google.com/maps/ms?ie=UTF8&hl=en&msa=0&msid=109046886555039097315.000443fff9e2930d30201&ll=52.367634,4.859734&spn=0.151143,0.277405&z=12&om=0';
$qVrijMiBo   = 'cafe';
// - map initial center and zoom level
$lat = '52.365014022082676';
$lng = '4.893208140209909';
// - map zoomlevel
$zoom = 12;

## HANDLE REQUEST VARS ######################################################################################################################################################
// get special request
$url = (isset($_REQUEST['vrijmibo']))?$urlVrijMiBo:$url;
$q   = (isset($_REQUEST['vrijmibo']))?$qVrijMiBo:$q;
// overwrite with requested url/query
$url = (isset($_REQUEST['url']))?urldecode($_REQUEST['url']):$url;
$q   = (isset($_REQUEST['q']))?urldecode($_REQUEST['q']):$q;
// make google maps output a kml file if a custom created google maps map url is provided
$url .= (strpos($url,"maps.google.com/maps/ms?") && !strpos($url,"output=kml") )?'&amp;output=kml':'';
// get uploaded file data, if file was uploaded
$file = (getUploadedFileData('uploadedfile'))?getUploadedFileData('uploadedfile'):NULL;


## LOAD KML SOURCES #########################################################################################################################################################
// get all kml data from urls and uploaded file(s)
// instantiate new kml object, which will load the provided url and read in the data
// and add it to the array of kml files
$placemarks = array();
if(isset($file)){
	$kml =& new kml($file['tmp_name']);
	$kml->set_filename($file['name']);
	$placemarks = & array_merge($placemarks,$kml->get_placemarks());
}
if(!empty($url)){
	$kml = &new kml($url);
	$placemarks = & array_merge($placemarks,$kml->get_placemarks());
}
// make array of points, as references to the placemark array
$points = array();
if(count($placemarks)){
	foreach($placemarks as & $placemark){
		if($placemark['type']=='Point'){
			$points[] = &$placemark;
		}
	}
}

## OUTPUT HTML ###############################################################################################################################################################
// start output
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<title>Center of Gravity - Gmaps - Eriestuff</title>
	<link rel="stylesheet" href="./css/style.css" type="text/css" media="screen" />
	<script src="http://www.google.com/jsapi?key=<?php echo GOOGLE_AJAX_SEARCH_API_KEY ?>" type="text/javascript" ></script>
	<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo GOOGLE_MAPS_API_KEY ?>" type="text/javascript"></script>
	<script type="text/javascript">//<![CDATA[

// load Google Search API
google.load("search", "1");

// set user defined constants
var START_LOCATION 		= <?php echo "['$lat','$lng']" ?>;
var START_ZOOM			= <?php echo $zoom ?>;
var URL_COG_ICON		= "./img/green_MarkerX.png"
var ID_MAP_DIV			= 'map';
var ID_PLACEMARK_FORM	= 'formPlacemarks';
 
// initialize global vars
var map;
var form;
var COGMarker;
var gLocalSearch;
var markerimages = [];
markerimages[0] = "./img/blue_MarkerA.png";
markerimages[1] = "./img/blue_MarkerB.png";
markerimages[2] = "./img/blue_MarkerC.png";
markerimages[3] = "./img/blue_MarkerD.png";
markerimages[4] = "./img/blue_MarkerE.png";
markerimages[5] = "./img/blue_MarkerF.png";
markerimages[6] = "./img/blue_MarkerG.png";
markerimages[7] = "./img/blue_MarkerH.png";
markerimages[8] = "./img/blue_MarkerI.png";
markerimages[9] = "./img/blue_MarkerJ.png";
markerimages[10] = "./img/blue_MarkerK.png";
markerimages[11] = "./img/blue_MarkerL.png";

// set onload function
window.onload = onLoad; if (window.captureEvents) window.captureEvents(Event.LOAD);

function onLoad() {
	// setup Google Map
    map = new GMap2(document.getElementById(ID_MAP_DIV));
	map.setCenter(new GLatLng(START_LOCATION[0],START_LOCATION[1]), START_ZOOM);
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.enableScrollWheelZoom();
	map.enableGoogleBar();
	// add onclick functionalities to map
	GEvent.addListener(map, "click", function(overlay, point){
		// add new marker
		addMarkerAndCheckbox(map,overlay,point);
		if(!overlay){
			// show markers and calculate Center Of Gravity
			onSelectionChange();
		}
	});

	// setup Google Search
	gLocalSearch = new GlocalSearch();
	gLocalSearch.setAddressLookupMode(GlocalSearch.ADDRESS_LOOKUP_DISABLED);
	gLocalSearch.setResultSetSize(GSearch.LARGE_RESULTSET);
	gLocalSearch.markerimages = markerimages;
	
	// attach events on search nearby Checkbox and inputbox
	var nearCheckbox = document.getElementById('nearCheckbox');
	nearCheckbox.onclick = onSelectionChange; if (nearCheckbox.captureEvents) nearCheckbox.captureEvents(Event.CLICK);
	var nearQ = document.getElementById('nearQ');
	nearQ.onkeyup = onSelectionChange; if (nearQ.captureEvents) nearQ.captureEvents(Event.keyup);
	
	// build COG marker
	var COGIcon = new GIcon(G_DEFAULT_ICON);
	COGIcon.image = URL_COG_ICON;
	// initiate marker
	COGMarker = new GMarker(new GLatLng(START_LOCATION[0],START_LOCATION[1]), {icon:COGIcon, draggable:false});
	// stick marker name to marker object
	COGMarker.name = 'Center Of Gravity';
	// add COG marker to map
	map.addOverlay(COGMarker);
	// hide it initialy
	COGMarker.hide();
	// add marker events
	addMarkerEvents(COGMarker);
	// setup placemark checkbox form
	form = document.getElementById(ID_PLACEMARK_FORM);
	// attach onclick event to checkboxes
	var elms = document.getElementById(ID_PLACEMARK_FORM).getElementsByTagName('INPUT');
	for(i=0;i<elms.length;i++){
		if(elms[i].type == 'checkbox'){
			elms[i].onclick = onSelectionChange;
			if (elms[i].captureEvents) elms[i].captureEvents(Event.CLICK);
		}
	}
	// draw markers and calculate Center Of Gravity
	onSelectionChange();
}

function addMarkerAndCheckbox(map,overlay,point){
	// place new marker and save position, if click returned a gpoint
	if (!overlay) {
		// map is clicked, not an overlay
		// build new marker
		var newMarker = new GMarker(point,{draggable: true});
		// place on map
		map.addOverlay(newMarker);
		// add marker events 
		addMarkerEvents(newMarker);
		// add position to placemark form
		// - get next id
		var id = 1; while(document.getElementById('placemark_checkbox_'+id)) id++;
		// - build form elements
		var elBr = document.createElement('BR');
		var elCheckbox = document.createElement('INPUT');
		elCheckbox.type='checkbox';
		elCheckbox.id = 'placemark_checkbox_'+id
		elCheckbox.name = 'Placemark '+id
		elCheckbox.value = new GLatLng(point);
		elCheckbox.defaultChecked = true;
		elCheckbox.marker = newMarker;
		elCheckbox.marker.name = elCheckbox.name;
		elCheckbox.onclick = onSelectionChange; if (elCheckbox.captureEvents) elCheckbox.captureEvents(Event.CLICK);
		var elLabel = document.createElement('LABEL');
		elLabel.setAttribute('for',elCheckbox.id);
		elLabel.innerHTML = elCheckbox.name;
		// - append nieuw elements		
		form.appendChild(elCheckbox);
		form.appendChild(elLabel);
		form.appendChild(elBr);
	}
}

function addMarkerEvents(marker){
	// - add marker eventlisteners
	// - - onclick -> infowindow
	GEvent.addListener(marker, 'click', function(){
		var htmlString = '<h2>'+this.name+'</h2><h3>' + this.getLatLng().lat() + ',' + this.getLatLng().lng() +'</h3>';
		this.openInfoWindowHtml(htmlString);
	});
	// - - ondrag -> update COG / close info window
	GEvent.addListener(marker, "drag", function(){
		COGMarker.setLatLng(getCOG(getCOGMasses(form)));
		this.closeInfoWindow();
		COGMarker.closeInfoWindow();
	});
	// - - ondragend -> search nearby
	GEvent.addListener(marker, "dragend", function(){
		searchNearCOG(document.getElementById('nearQ').value);
	});
}

function searchNearCOG(query) {
  if (!(document.getElementById("nearCheckbox").checked)) return;
  performLocalQuery(COGMarker.getLatLng(),query,'attribution');
}

function onSelectionChange(){
	// show/hide placemarks
	showSelectedPlacemarks(form,map);
	// calculate Center Of Gravity
	// update COG marker positon
	COGMarker.setLatLng(getCOG(getCOGMasses(form)));
	// get nearby search results
	searchNearCOG(document.getElementById('nearQ').value);
}

function showSelectedPlacemarks(elmForm,elmMap){
	var bounds = new GLatLngBounds();
	var intMarkersShown = 0;
	// hide the COGmarker until all placemarks are drawn
	COGMarker.hide();
	// loop all checkboxes 
	var elms = elmForm.getElementsByTagName('INPUT');
	for(i=0;i<elms.length;i++){
		if(elms[i].type == 'checkbox'){
			// if checkbox is checked, add/show a marker and save coordinate to array
			if(elms[i].checked){
				intMarkersShown++;
				// build and/or show marker
				if(elms[i].marker){
					// marker exists, show it
					elms[i].marker.show();
				}else{
					// marker doesnt exist yet, build it
					// - get coordinates from checkbox value
					var arrCoords = elms[i].value.split(',');
					// - bind new marker object to checkbox element in the DOM
					elms[i].marker = new GMarker(new GLatLng(arrCoords[1],arrCoords[0]), {draggable: true});
					// - stick marker name to marker
					elms[i].marker.name = elms[i].name;
					// - add the marker to the map
					elmMap.addOverlay(elms[i].marker);
					// - add marker eventlisteners
					addMarkerEvents(elms[i].marker);
				}
				// add point to bounds (to set pan/zoom level later)
				bounds.extend(elms[i].marker.getLatLng());
			}else if(elms[i].marker){
				// placemark not checked and marker exists, hide it
				elms[i].marker.hide();
			}
		}
	}
	// show COG maker
	// zoom/pan the map
	if(intMarkersShown>1){
		// only when there are markers on the map
		COGMarker.show();
		if(!(document.getElementById("nearCheckbox").checked) && Math.abs(elmMap.getZoom()-map.getBoundsZoomLevel(bounds))>2){
			elmMap.setZoom(map.getBoundsZoomLevel(bounds));
			elmMap.panTo(bounds.getCenter());
		}
	}
}

function getCOGMasses(elmForm){
	var arrCOGMasses = new Array();
	// loop all checkboxes 
	var elms = elmForm.getElementsByTagName('INPUT');
	for(i=0;i<elms.length;i++){
		if(elms[i].type == 'checkbox' && elms[i].checked){
			arrCOGMasses[arrCOGMasses.length] = elms[i].marker.getLatLng();
		}
	}
	return arrCOGMasses;
}

function getCOG(arrCOGMasses){
	// copyright: brammeleman <brammeleman@nerdnotes.org>
	// javascript rewrite: eriestuff.blogspot.com
	// gmaps api rewrite: eriestuff.blogspot.com
	var sumx = 0;
	var sumy = 0;
	var sumz = 0;
	for(var strCoord in arrCOGMasses) {
		var lat = arrCOGMasses[strCoord].latRadians();
		var lng = arrCOGMasses[strCoord].lngRadians();
		// convert spherical coordinates to cartesian
		var cart = sph2cart(lng, lat, 1);
		var x = cart[0];
		var y = cart[1];
		var z = cart[2];
		// sum the vectors
		sumx += x;
		sumy += y;
		sumz += z;
	}
	// convert cartesian coordinate back to spherical
	var sph = cart2sph(sumx, sumy, sumz);
	var lat = sph[1];
	var lng = sph[0];
	// convert to degrees
	lat = lat *(180/Math.PI);
	lng = lng *(180/Math.PI);
	
	// return as GLatLng point
	return new GLatLng(lat,lng);

	// private functions //////////////////////////////////////////

	function cart2sph(x, y, z){
		// # php version of cart2sph.m from octave <www.octave.org>
		// # copyright (C) 2000 kai habel <kai.habel@gmx.de>
		// # adapted-by: jwe
		// # php rewrite: brammeleman <brammeleman@nerdnotes.org>
		// # javascript rewrite: erie <eriestuff.blogspot.com>
		// 
		// # Transform cartesian to spherical coordinates.
		// # theta describes the angle relative to the x - axis.
		// # phi is the angle relative to the xy - plane.
		// # r is the distance to the origin (0, 0, 0).

		var theta = Math.atan2(y, x);
		var phi = Math.atan2(z, Math.sqrt(x * x + y * y));
		var r = Math.sqrt(x * x + y * y + z * z);

		return [theta, phi, r];
	}
	
	function sph2cart(theta, phi, r){
		// # php version of sph2cart.m from octave <www.octave.org>
		// # copyright (C) 2000 kai habel <kai.habel@gmx.de>
		// # adapted-by: jwe
		// # php rewrite: brammeleman <brammeleman@nerdnotes.org>
		// # javascript rewrite: erie <eriestuff.blogspot.com>
		//
		// # Transform spherical to cartesian coordinates.
		// # theta describes the angle relative to the x-axis.
		// # phi is the angle relative to the xy-plane.
		// # r is the distance to the origin (0, 0, 0).

		var x = r * Math.cos(phi) * Math.cos(theta);
		var y = r * Math.cos(phi) * Math.sin(theta);
		var z = r * Math.sin(phi);

		return [x, y, z];
	}
}

function performLocalQuery(point,query,divAttribution) {
	gLocalSearch.setSearchCompleteCallback(null, function(){
		performLocalQueryCallback(divAttribution);
	});
	gLocalSearch.setCenterPoint(point);
	gLocalSearch.execute(query);
}

function performLocalQueryCallback(divAttribution) {
	// init search result array, on first run only
	if(!gLocalSearch.arrSearchResultMarkers) gLocalSearch.arrSearchResultMarkers = Array();
	// remove previous search results, if any
	while(gLocalSearch.arrSearchResultMarkers.length){
		map.removeOverlay(gLocalSearch.arrSearchResultMarkers[gLocalSearch.arrSearchResultMarkers.length-1]);
		gLocalSearch.arrSearchResultMarkers.pop();
	}
	if ((!gLocalSearch.results) || (0 == gLocalSearch.results.length)) {
		QuietAlert("no results");
		return;
	}
	var attribution = gLocalSearch.getAttribution();
	if (null == attribution) {
		attribution = "";
	}
	document.getElementById(divAttribution).innerHTML = '<h3>Search results:</h3>';
	document.getElementById(divAttribution).innerHTML += attribution;
	var new_bounds = new GLatLngBounds();
	for (var i = 0; i < gLocalSearch.results.length; i++) {
		var result = gLocalSearch.results[i];
		var point = new GLatLng(result.lat, result.lng);
		new_bounds.extend(point);
		// add marker to map and save pointer in array
		gLocalSearch.arrSearchResultMarkers[gLocalSearch.arrSearchResultMarkers.length] = addResultMarker(point, gLocalSearch.markerimages[i], result.html.innerHTML);
		// add name/link to result list
		strAZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		document.getElementById(divAttribution).innerHTML += strAZ.substring(i,i+1) + ' <a href="'+result.url+'" target="_new" >'+result.title+'</a><br/>';
	}
	// center map around the local query results
	if(Math.abs(map.getZoom()-map.getBoundsZoomLevel(new_bounds))>3){
		map.setZoom(map.getBoundsZoomLevel(new_bounds)-1);
		map.setCenter(new_bounds.getCenter());
	}

	// private functions
	function addResultMarker(point, markerimg, html) {
		var marker;
		if (markerimg) {
			var icon = new GIcon(G_DEFAULT_ICON, markerimg);
			marker = new GMarker(point, { icon: icon });
		} else {
			marker = new GMarker(point);
		}
		map.addOverlay(marker);
		GEvent.addListener(marker, "click", function() {
			marker.openInfoWindowHtml(html);
		});
		return marker;
	}
	function QuietAlert(text) {
		document.getElementById(divAttribution).innerHTML = "<i>" + text + "</i>";
	}

}
	//]]></script>
</head>
<body onunload="GUnload()">
	<div id="columncontainer">
		<div id="columnleft">
			<div id="columnleftheader" >
				<h1>Center of Gravity</h1>
				<a href="?url=&amp;q=" id="clearlink" >clear map</a> | 
				<a href="index.html" >Other Gmaps Apps</a>
			</div>
			<div id="columnleftcontent" >
				<form id="formPlacemarks" enctype="multipart/form-data" method="post" action="" >
					<?php
					if(count($points)){
						?><h2><?php echo 'Points in KML source:' ?></h2><?php echo"\n";
						if(isset($kml)){
							?><h3><?php echo htmlentities($kml->get_document_name()); ?></h3><?php echo"\n";
						}
						$i = 0;
				    	foreach ($points as $point){
							$i++;
							?>
					<input type="checkbox" id="placemark_checkbox_<?php echo $i ?>" name="<?php echo $point['name'] ?>" value="<?php echo implode(',',$point['coordinates']) ?>" checked="checked"  />
					<label for="placemark_checkbox_<?php echo $i ?>" ><?php echo $point['name'] ?></label><br/><?php echo"\n";
						}
					}
					?>
					<p><br/></p>
					<h2>User defined placemarks:</h2>
					<h3>Click map to add placemark</h3>
					<h3>Drag markers to reposition</h3>
				</form>
				<br />
				<h2>Search nearby:</h2>
				<form id="formSearch" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<input type="checkbox" id="nearCheckbox" checked="checked"  />
						<input type="text" id="nearQ" name="q" value="<?php echo $q ?>" />
						<div id="attribution"></div>
					</fieldset>
				</form>
				<h2>Load KML source(s):</h2>
				<form id="formSources" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<h3>KML or google map urls:</h3>
						<input type="text" name="url" id="url" value="<?php echo htmlentities($url) ?>" /><label for="url">URL</label><br/>
						<h3>Path to local KML file:</h3>
						<input type="hidden" name="MAX_FILE_SIZE" value="50000" />
						<input type="file" name="uploadedfile" id="uploadedfiles" size="12" /><br />
						<br />
						<input type="submit" name="fetchSubmit" id="fetchSubmit" value="go" />
					</fieldset>
				</form>
			</div>
		</div>	
		<div id="columnmid">
			<div id="map" ></div>
		</div>
	</div>

	<!-- GOOGLE ANALITICS -->
	<script type="text/javascript">
		var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
		document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>
	<script type="text/javascript">
		var pageTracker = _gat._getTracker("<?php echo GOOGLE_ANALITICS_ID ?>");
		pageTracker._initData();
		pageTracker._trackPageview();
	</script>
	<!-- end analitics -->
</body>
</html>

<?php
exit;



// UNUSED FUNCTIONS - KEPT FOR FUTURE REFERENCES /////////////////////////////////////////////////////////

function calcCOG($placemarks){
# Copyright 2006 brammeleman@nerdnotes.org
    $sumx = 0;
    $sumy = 0;
    $sumz = 0;

    foreach ($placemarks as $placemark) {
		// get lat and lon from the array in radians
		$coordinates = $placemark['Point']['coordinates'];
		
		// coordinates are seperated by commas
		list($longitude, $latitude, $altitude) = explode(',', $coordinates);
		
		// convert to radians
		$lat = deg2rad($latitude);
		$lon = deg2rad($longitude);
		
		// convert spherical coordinates to cartesian
		list($x, $y, $z)=sph2cart($lon, $lat, 1);
		
		// sum the vectors
		$sumx += $x;
		$sumy += $y;
		$sumz += $z;
    }

    // convert cartesian coordinate back to spherical
    list($lon, $lat, $r) = cart2sph($sumx, $sumy, $sumz);
    $lon = rad2deg($lon);
    $lat = rad2deg($lat);

    $coordinates = "$lon,$lat,0";
	return $coordinates;
}

function cart2sph($x, $y, $z){
   # php version of cart2sph.m from octave <www.octave.org>
   # copyright (C) 2000 kai habel <kai.habel@gmx.de>
   # adapted-by: jwe
   # php rewrite: brammeleman <brammeleman@nerdnotes.org>

   # Transform cartesian to spherical coordinates.
   # $theta describes the angle relative to the x - axis.
   # $phi is the angle relative to the xy - plane.
   # $r is the distance to the origin (0, 0, 0).
   
   $theta = atan2($y, $x);
   $phi = atan2($z, sqrt($x * $x + $y * $y));
   $r = sqrt($x * $x + $y * $y + $z * $z);
   
   return array($theta, $phi, $r);
}

function sph2cart($theta, $phi, $r){
   # php version of sph2cart.m from octave <www.octave.org>
   # copyright (C) 2000 kai habel <kai.habel@gmx.de>
   # adapted-by: jwe
   # php rewrite: brammeleman <brammeleman@nerdnotes.org>
   
   # Transform spherical to cartesian coordinates.
   # $theta describes the angle relative to the x-axis.
   # $phi is the angle relative to the xy-plane.
   # $r is the distance to the origin (0, 0, 0).

   $x = $r * cos($phi) * cos($theta);
   $y = $r * cos($phi) * sin($theta);
   $z = $r * sin($phi);
   
   return array($x, $y, $z);
}

function outputCOGKML($coordinates){	
# Copyright 2006 brammeleman@nerdnotes.org
# altered by eriestuff.blogspot.com
	// send the response KML file
	header('Content-Type: application/vnd.google-earth.kml+xml');    
	header('Content-Disposition: attachment; filename="cog.kml"');
	echo '<?xml version="1.0" encoding="UTF-8"?>'  . "\n";
	echo '<kml xmlns="http://earth.google.com/kml/2.0">'  . "\n";
	echo formatKMLplacemark('Center of Gravity', $coordinates, 'Center of Gravity', 1);
	echo '</kml>' . "\n";
}

function formatKMLplacemark ($name, $coordinates, $description = "", $visibility = 1){
# Copyright 2006 brammeleman@nerdnotes.org
    $kml  = "<Placemark>\n";
    $kml .= "  <name>$name</name>\n";
    $kml .= "  <visibility>$visibility</visibility>\n";
    $kml .= "  <description>$description</description>";
    $kml .= "  <Point>\n";
    $kml .= "    <coordinates>$coordinates</coordinates>\n";
    $kml .= "  </Point>\n";
    $kml .= "</Placemark>\n";
    return $kml;
}


