<?php 




class VideoSource_YoutubeUserUploads
{
	function extractYouTubeUserID($youtubeURL)
	{
		//link example: http://www.youtube.com/user/designcompasscorp
		$matches=explode('/',$youtubeURL);
	
		if (count($matches) >3)
		{
			
			$userid = $matches[4];
			
			return $userid;
		}
				
	    return '';
	}
	
	function getVideoIDList($youtubeURL)
	{
		$videolist=array();
		
		$userid=VideoSource_YoutubeUserUploads::extractYouTubeUserID($youtubeURL);
		
		if($userid=='')
			return $videolist; //user id not found
		
		$url = 'http://gdata.youtube.com/feeds/api/users/'.$userid.'/uploads?start-index=1&v=2'; //&max-results=10
		if (ini_get('allow_url_fopen') == true)
		{
			$xml = simplexml_load_file($url);
		}
		elseif ( function_exists('curl_init'))
		{
			$c = curl_init();
			$t = 3; 
			curl_setopt ($c, CURLOPT_URL, $url);
			curl_setopt ($c, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($c, CURLOPT_CONNECTTIMEOUT, $t);
			$xml = simplexml_load_string(curl_exec($c));
			curl_close($c);		
		}
		else return 'Cannot load data, enable "allow_url_fopen"';
		
		if($xml){
			foreach ($xml->entry as $entry)
			{
				if(isset($entry->link[0]))
				{
					$link=$entry->link[0];
					$attr = $link->attributes();
					
					$videolist[] = $attr['href'];
				}	
				
			}
		}
		
		return $videolist;
		
	}
	

}


?>