<?php

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

error_reporting(E_ALL ^ E_NOTICE);


class YouTubeGalleryMisc
{
	var $tablerow;
	function formGalleryList($rawList,$video_showtitle,$video_showdescription,&$firstvideo, $showactivevideotitle)
	{
		//extract title if it's needed for navigation (thumbnail) or for active video.
		$video_showtitle_nav_or_active=($video_showtitle or $showactivevideotitle ? true : false);
		
		
		$gallery_list=array();
		
		foreach($rawList as $b)
		{
			
			$listitem=$this->csv_explode(',', $b, '"', false);
			$theLink=trim($listitem[0]);
			if(isset($listitem[1]))
				$customtitle=$listitem[1];
			else
				$customtitle='';
			
			if(isset($listitem[2]))
				$customdescription=$listitem[2];
			else
				$customdescription='';
				
			if(isset($listitem[3]))
				$customimage=$listitem[3];
			else
				$customimage='';
			
				
			$vsn=$this->getVideoSourceName($theLink);
			
			switch($vsn)
			{
				case 'megavideo' :
					
					require_once('megavideo.php');
					$HTML_SOURCE='';
					$videoid=VideoSource_Megavideo::extractMegavideoID($theLink,$HTML_SOURCE);
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
			
						$gallery_list[]=VideoSource_Megavideo::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription,$HTML_SOURCE);
					}

					break;
				
				case 'break' :
					
					require_once('break.php');
					$HTML_SOURCE='';
					$videoid=VideoSource_Break::extractBreakID($theLink,$HTML_SOURCE);
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
			
						$gallery_list[]=VideoSource_Break::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription,$HTML_SOURCE);
					}

					break;
				
				
				case 'vimeo' :
					
					require_once('vimeo.php');
					
					$videoid=VideoSource_Vimeo::extractVimeoID($theLink);
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
							
						$gallery_list[]=VideoSource_Vimeo::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription);
					}

					break;
				
				case 'youtube' :
					
					require_once('youtube.php');
					
					$videoid=VideoSource_Youtube::extractYouTubeID($theLink);
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
							
						$gallery_list[]=VideoSource_Youtube::getVideoData(
												$videoid,
												$customimage,
												$customtitle,
												$customdescription,
												$video_showtitle_nav_or_active,
												$video_showdescription,
												$this->tablerow->thumbnailstyle
												);
					
					}
					break;
				
				case 'youtubeplaylist' :
					
					require_once('youtubeplaylist.php');
					require_once('youtube.php');
					
					$newlist=VideoSource_YoutubePlaylist::getVideoIDList($theLink);
					foreach($newlist as $theLink)
					{
						
						$videoid=VideoSource_Youtube::extractYouTubeID($theLink);
					
						if($videoid!='')
						{
							if($firstvideo=='')
								$firstvideo=$videoid;
							
							$gallery_list[]=VideoSource_Youtube::getVideoData(
												$videoid,
												$customimage,
												$customtitle,
												$customdescription,
												$video_showtitle_nav_or_active,
												$video_showdescription,
												$this->tablerow->thumbnailstyle
												);
					
						}
						
					}
					
					break;
				
				case 'youtubeuseruploads' :
					
					require_once('youtubeuseruploads.php');
					require_once('youtube.php');
					
					$newlist=VideoSource_YoutubeUserUploads::getVideoIDList($theLink);
					foreach($newlist as $theLink)
					{
						
						$videoid=VideoSource_Youtube::extractYouTubeID($theLink);
					
						if($videoid!='')
						{
							if($firstvideo=='')
								$firstvideo=$videoid;
							
							$gallery_list[]=VideoSource_Youtube::getVideoData(
												$videoid,
												$customimage,
												$customtitle,
												$customdescription,
												$video_showtitle_nav_or_active,
												$video_showdescription,
												$this->tablerow->thumbnailstyle
												);
					
						}
						
					}
					
					break;
				
				case 'google' :

					require_once('google.php');
					
					$videoid=VideoSource_Google::extractGoogleID($theLink);
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
							
						$gallery_list[]=VideoSource_Google::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription);
					}
					
					break;
				
				case 'yahoo' :
					
					require_once('yahoo.php');
					
					
					$videoid=VideoSource_Yahoo::extractYahooID($theLink);
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
						
						$gallery_list[]=VideoSource_Yahoo::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription,$theLink);
					}
				
					break;
				
				case 'collegehumor' :
					
					require_once('collegehumor.php');
					
					
					$videoid=VideoSource_CollegeHumor::extractCollegeHumorID($theLink);
					
					
					if($videoid!='')
					{
						if($firstvideo=='')
							$firstvideo=$videoid;
						
						$gallery_list[]=VideoSource_CollegeHumor::getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription);
					}
				
					break;
				
				
				
			}//switch($vsn)
			
			
		}//foreach($rawList as $b)
		
		return $gallery_list;
	}
	
	
	function getGalleryList_FromCache($cache,&$firstvideo)
	{
		$gallery_list=array();
		
		$listitems=$this->csv_explode(';', $cache, $enclose='"', true);
		
		foreach($listitems as $item)
		{
			$itemsfields=$this->csv_explode(',', $item, $enclose='"', false);
			
			
			$gallery_list[]=array(
				'videosource'=>$itemsfields[0],
				'videoid'=>$itemsfields[1],
				'imageurl'=>$itemsfields[2],
				'title'=>$itemsfields[3],
				'description'=>$itemsfields[4]
				);
			
			if($firstvideo=='')
				$firstvideo=$itemsfields[1];
		}
		
//		print_r($gallery_list);
		return $gallery_list;
	}
	
	function getVideoSourceName($link)
	{
		if(!(strpos($link,'youtube.com')===false))
		{
			if(!(strpos($link,'/playlist')===false))
				return 'youtubeplaylist';
			
			elseif(!(strpos($link,'/user')===false))
				return 'youtubeuseruploads';
			
			else
				return 'youtube';
		}
		
		
		
		if(!(strpos($link,'vimeo.com')===false) or !(strpos($link,'www.vimeo.com')===false))
			return 'vimeo';
		
		if(!(strpos($link,'video.google.com')===false))
			return 'google';
		
		if(!(strpos($link,'video.yahoo.com')===false))
			return 'yahoo';
		
		if(!(strpos($link,'break.com')===false))
			return 'break';
		
		if(!(strpos($link,'megavideo.com')===false))
			return 'megavideo';
		
		if(!(strpos($link,'collegehumor.com')===false))
			return 'collegehumor';
		
		return '';
	}
	
	
	function parse_query($var)
	{
		$arr  = array();
		
		 $var  = parse_url($var);
		 $varquery=$var['query'];

		 
		 if($varquery=='')
			return $arr;
		
		 $var  = html_entity_decode($varquery);
		 $var  = explode('&', $var);
		 

		foreach($var as $val)
		{
			$x          = explode('=', $val);
			$arr[$x[0]] = $x[1];
		}
		unset($val, $x, $var);
		return $arr;
	}
	
	
	function csv_explode($delim=',', $str, $enclose='"', $preserve=false)
	{
		$resArr = array();
		$n = 0;
		$expEncArr = explode($enclose, $str);
		foreach($expEncArr as $EncItem)
		{
			if($n++%2){
				array_push($resArr, array_pop($resArr) . ($preserve?$enclose:'') . $EncItem.($preserve?$enclose:''));
			}else{
				$expDelArr = explode($delim, $EncItem);
				array_push($resArr, array_pop($resArr) . array_shift($expDelArr));
			    $resArr = array_merge($resArr, $expDelArr);
			}
		}
	return $resArr;
	}
		

}




?>