<?php

/*
 * @version		$Id: settings.php 1.6 2011-09-09 $
 * @package		Joomla
 * @subpackage	hdwebplayer
 * @copyright   Copyright (C) 2011-2012 HD Webplayer
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import Joomla! libraries
jimport('joomla.application.component.model');

// Import filesystem libraries.
jimport('joomla.filesystem.file');

class WebplayerModelSettings extends JModel {

    function __construct() {
		parent::__construct();
    }
	
	function getsettings()
    {
         $db     =& JFactory::getDBO();
         $query  = "SELECT * FROM #__webplayer_settings";
         $db->setQuery( $query );
         $output = $db->loadObjectList();
         return($output);
	}
	
	function save()
	{
	  $mainframe = JFactory::getApplication();
	  $row       =& JTable::getInstance('webplayersettings', 'Table');
	  $cid       = JRequest::getVar( 'cid', array(0), '', 'array' );
      $id        = $cid[0];
      $row->load($id);

      if(!$row->bind(JRequest::get('post')))
	  {
		JError::raiseError(500, $row->getError() );
	  }
	  
	  $row->logo = $this->upload('logo');
	
	  if(!$row->store()){
		JError::raiseError(500, $row->getError() );
	  }
	  
	  $task = JRequest::getCmd('task');
	  
	  $msg  = 'Saved';
      $link = 'index.php?option=com_webplayer&task=settings';
			  
	  // page redirect
	  $mainframe->redirect($link, $msg);
	  
	}
	
	function upload($filename)
	{
	
	  jimport('joomla.filesystem.file');
	  
	  if(!JFolder::exists(WEBPLAYER_UPLOAD_BASE)) {
			JFolder::create(WEBPLAYER_UPLOAD_BASE);
	  }
		
	  $file = JFile::makeSafe($_FILES[$filename]['name']);
	  $temp = $_FILES[$filename]['tmp_name'];
	  
      if($file != "") {
     	 if(JFile::upload($temp, WEBPLAYER_UPLOAD_BASE.$file)) {
		 	return WEBPLAYER_UPLOAD_BASEURL.$file;
		 } else {
		 	JError::raiseWarning(21, 'Error Occured While Uploading!');
			return false;
		 }
	  }	
	  	  
	}
	
}

?>