<?php

/*
 * @version		$Id: install.webplayer.php 1.6 2011-09-09 $
 * @package		Joomla
 * @subpackage	hdwebplayer
 * @copyright   Copyright (C) 2011-2012 HD Webplayer
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

if( (substr(JVERSION,0,3) == '1.6' || substr(JVERSION,0,3) == '1.7') && !defined('_INSTALL_HACK') ) {
	return;
} else {
	global $webplayer_installation_has_run;
	if($webplayer_installation_has_run) return;
}

jimport('joomla.installer.installer');

$db              = & JFactory::getDBO();
$status          = new JObject();
$status->modules = array();
$status->plugins = array();

if(substr(JVERSION,0,3) == '1.6' || substr(JVERSION,0,3) == '1.7') {
	$src = dirname(__FILE__);
} else {
	$src = $this->parent->getPath('source');
}

// -- Install Modules
$mname   = 'mod_webplayer';
$installer = new JInstaller;
$result = $installer->install($src.DS.'modules'.DS.$mname);
$status->modules[] = array('name'=>$mname,'client'=>'site', 'result'=>$result);

$mname   = 'mod_webplayersearch';
$installer = new JInstaller;
$result = $installer->install($src.DS.'modules'.DS.$mname);
$status->modules[] = array('name'=>$mname,'client'=>'site', 'result'=>$result);

// -- Install Plugin
$pname   = 'webplayer';
$installer = new JInstaller;
$result = $installer->install($src.DS.'plugins'.DS.'webplayer');
$status->plugins[] = array('name'=>$pname,'group'=>'content', 'result'=>$result);

// Database modifications [start]

$query = "SELECT COUNT(*) FROM #__webplayer_settings";
$db->setQuery($query);
$num = $db->loadResult();

if ($num==0){
	$query = "INSERT INTO `#__webplayer_videos` (`id`, `title`, `type`, `streamer`, `video`, `preview`, `thumb`, `category`, `published`) VALUES (NULL, 'Sample Video', 'Direct URL', '', 'http://hdwebplayer.com/player/videos/300.mp4', '', '', 'none', '1')";
	$db->setQuery($query);
	$db->Query();
	
	$query = "INSERT INTO `#__webplayer_settings` (`id`, `width`, `height`, `licensekey`, `logo`, `logoposition`, `logoalpha`, `logotarget`, `skinmode`, `stretchtype`, `buffertime`, `volumelevel`, `autoplay`, `playlistautoplay`, `ffmpeg`, `flvtool2`) VALUES (NULL, '640', '360', 'Your Commercial Key Here', '', 'topleft', '35', 'http://hdwebplayer.com', 'static', 'fill', '3', '50', '0', '0', '/usr/bin/ffmpeg/', '/usr/bin/flvtool2/')";
	$db->setQuery($query);
	$db->Query();
	
	$query = "INSERT INTO `#__webplayer_skin` (`id`, `controlbar`, `playpause`, `progressbar`, `timer`, `share`, `volume`, `fullscreen`, `playdock`, `videogallery`) VALUES (NULL, '1', '1', '1', '1', '1', '1', '1', '1', '1')";
	$db->setQuery($query);
	$db->Query();
	
	$query = "INSERT INTO `#__webplayer_googleads` (`id`, `adscript`, `component`, `module`, `plugin`) VALUES
(1, '<script type=\"text/javascript\"><!--\r\ngoogle_ad_client = \"pub-9025491354486492\";\r\n/* 300x250 */\r\ngoogle_ad_slot = \"9364881640\";\r\ngoogle_ad_width = 300;\r\ngoogle_ad_height = 250;\r\n//-->\r\n</script>\r\n<script type=\"text/javascript\"\r\nsrc=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">\r\n</script>', 0, 0, 0);";
    $db->setQuery($query);
	$db->Query();
}

$fields = $db->getTableFields('#__webplayer_settings');
if (!array_key_exists('playlistopen', $fields['#__webplayer_settings'])) {
	$query = "ALTER TABLE #__webplayer_settings ADD `playlistopen` TINYINT(4) NOT NULL, ADD `ffmpeg` VARCHAR(255) NOT NULL DEFAULT '/usr/bin/ffmpeg/', ADD `flvtool2` VARCHAR(255) NOT NULL DEFAULT '/usr/bin/flvtool2/' AFTER `playlistautoplay`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('hdvideo', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `hdvideo` VARCHAR(255) NOT NULL AFTER `video`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('ordering', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `ordering` INT(5) NOT NULL DEFAULT '1' AFTER `category`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('token', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `token` VARCHAR(255) NOT NULL AFTER `thumb`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_category');
if (!array_key_exists('type', $fields['#__webplayer_category'])) {
	$query = "ALTER TABLE #__webplayer_category ADD `type` VARCHAR(255) NOT NULL DEFAULT 'Url', ADD `image` VARCHAR(255) NOT NULL AFTER `name`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('featured', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `featured` TINYINT(4) NOT NULL, ADD `views` int(5) NOT NULL AFTER `category`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('user', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `user` VARCHAR(255) NOT NULL DEFAULT 'Admin', ADD `tags` VARCHAR(255) NOT NULL AFTER `featured`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_videos');
if (!array_key_exists('dvr', $fields['#__webplayer_videos'])) {
	$query = "ALTER TABLE #__webplayer_videos ADD `dvr` TINYINT(4) NOT NULL AFTER `streamer`";
	$db->setQuery($query);
	$db->query();
}

$fields = $db->getTableFields('#__webplayer_settings');
if (!array_key_exists('playlistrandom', $fields['#__webplayer_settings'])) {
	$query = "ALTER TABLE #__webplayer_settings ADD `playlistrandom` TINYINT(4) NOT NULL AFTER `playlistopen`";
	$db->setQuery($query);
	$db->query();
}

// Database modifications [end]

?>
<?php $rows = 0;?>

<h2><?php echo JText::_('HD Webplayer Installation Status'); ?></h2>
<table class="adminlist">
  <thead>
    <tr>
      <th class="title" colspan="2"><?php echo JText::_('Extension'); ?></th>
      <th width="30%"><?php echo JText::_('Status'); ?></th>
    </tr>
  </thead>
  <tfoot>
    <tr>
      <td colspan="3"></td>
    </tr>
  </tfoot>
  <tbody>
    <tr class="row0">
      <td class="key" colspan="2"><?php echo 'Webplayer '.JText::_('Component'); ?></td>
      <td><strong><?php echo JText::_('Installed'); ?></strong></td>
    </tr>
    <?php if (count($status->modules)) : ?>
    <tr>
      <th><?php echo JText::_('Module'); ?></th>
      <th><?php echo JText::_('Client'); ?></th>
      <th></th>
    </tr>
    <?php foreach ($status->modules as $module) : ?>
    <tr class="row<?php echo (++ $rows % 2); ?>">
      <td class="key"><?php echo $module['name']; ?></td>
      <td class="key"><?php echo ucfirst($module['client']); ?></td>
      <td><strong><?php echo ($module['result'])?JText::_('Installed'):JText::_('Not installed'); ?></strong></td>
    </tr>
    <?php endforeach;?>
    <?php endif;?>
    <?php if (count($status->plugins)) : ?>
    <tr>
      <th><?php echo JText::_('Plugin'); ?></th>
      <th><?php echo JText::_('Group'); ?></th>
      <th></th>
    </tr>
    <?php foreach ($status->plugins as $plugin) : ?>
    <tr class="row<?php echo (++ $rows % 2); ?>">
      <td class="key"><?php echo ucfirst($plugin['name']); ?></td>
      <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
      <td><strong><?php echo ($plugin['result'])?JText::_('Installed'):JText::_('Not installed'); ?></strong></td>
    </tr>
    <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>
<?php
	global $webplayer_installation_has_run;
	$webplayer_installation_has_run = 1;
?>