<?php
/**
* @version		$Id: content.php 46 2009-05-26 16:59:42Z happynoodleboy $
* @package      JCE Advlink
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Ryan Demmer
* @license      GNU/GPL
* JCE is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined('_JCE_EXT') or die('Restricted access');
class AdvlinkZoolinks 
{
	function getOptions()
	{
		$advlink =& AdvLink::getInstance();
		$list = '';
		if ($advlink->checkAccess('zoolinks', '1')) {
			$list = '<li id="index.php?option=com_zoo"><div class="tree-row"><div class="tree-image"></div><span class="folder content nolink"><a href="javascript:;">' . JText::_('Application') . '</a></span></div></li>';
		}
		return $list;	
	}
	function getItems($args)
	{		
		global $mainframe;	
		
		$advlink =& AdvLink::getInstance();
		
		$apps 		= AdvlinkZoolinks::_application();
		$items 		= array();
		$view		= isset($args->view) ? $args->view : '';
		switch ($view) {
		default:
			foreach ($apps as $app) {
				$items[] = array(
					'id'		=>	$app->id,
					'name'		=>	$app->name,
					'class'		=>	'folder application nolink'
				);
			}
			break;
		case 'application':			
			$categories = AdvlinkZoolinks::_category($args->id);
			foreach ($categories as $category) {
				$itemid = AdvLink::getItemId('com_zoo', array('categories' => null, 'category' => $category->id));
				$items[] = array(
					'id'		=>	'index.php?option=com_zoo&task=category&category_id=' . $category->id . $itemid,
					'name'		=>	$category->name . ' / ' . $category->alias,
					'class'		=>	'folder category'
				);
			}
			break;
		case 'category':
			$categories = AdvlinkZoolinks::_category($args->id);
			foreach ($categories as $category) {
				$items[] = array(
					'id' 	=> 'index.php?option=com_zoo&task=category&category_id=' . $category->id . $itemid,
					'name' 	=> $category->name . ' / ' . $category->alias,
					'class'	=> 'folder category'
				);
			}
			break;
		case 'item':
			$items = AdvlinkContent::_item($args->id);
			foreach ($items as $item) {
				$items[] = array(
					'id' 	=> ContentHelperRoute::getArticleRoute($article->slug, $article->catslug, $article->sectionid),
					'name' 	=> $article->title . ' / ' . $article->alias,
					'class'	=> 'file'
				);
			}
			break;
		}
		return $items;
	}
	function _application()
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		
		$query = 'SELECT id, name'
		. ' FROM #__zoo_application'
		. ' ORDER BY name'
		;

		$db->setQuery($query);
		return $db->loadObjectList();		
	}
	function _category($id, $parent = 0)
	{
		$db			=& JFactory::getDBO();
		$user		=& JFactory::getUser();
		$advlink 	=& AdvLink::getInstance();
	
		$query = 'SELECT id, name, parent, alias'
		. ' FROM #__zoo_category'
		. ' WHERE application_id = '.(int) $id
		. ' published = 1'
		. ' AND parent = '.(int) $parent
		. ' ORDER BY ordering'
		;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	function _item($id)
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		
		$query = 'SELECT i.name, i.alias'
		. ' FROM #__zoo_item AS i'
		. ' WHERE i.state = 1'
		. ' INNER JOIN #__zoo_category_item AS c ON c.id = '.(int) $id
		;
		$db->setQuery($query, 0);
		return $db->loadObjectList();
	}
}
?>