<?php global $user_ID, $user_identity, $user_level ?>

    <div id="sidebar">
        <?php // Menu for subpages of current page
		// Only shows if the current page has subpages
		if($post->post_parent) {
			$parent = wp_list_pages("title_li=&include=".$post->post_parent."&echo=0");
			$children = wp_list_pages("title_li=&child_of=".$post->post_parent."&echo=0");
		} else {
			$parent = wp_list_pages("title_li=&include=".$post->ID."&echo=0");
			$children = wp_list_pages("title_li=&child_of=".$post->ID."&echo=0");
		}
		if ($children) {
			echo '<h3 class="pages">Sub Pages</h3>';
			echo '<ul class="navigation">';
			echo $parent;
			echo $children;
			echo '</ul>';
		} // End Subpage menu ?>
        
        <?php // Category Navigation ?>
        <h3 class="folder">Categories</h3>
        <ul id="navigation">
          <?php wp_list_categories('depth=2&title_li='); ?>
        </ul>
        <?php if (is_single() && function_exists('related_posts_by_category')) { 
			$home = get_bloginfo("home");
			echo '<h3 class="related">Related Articles</h3>';
			echo '<div id="related">';
			echo '<ul>';
			related_posts_by_category(
			  array(
				'orderby' => 'post_date',
				'order' => 'DESC',
				'limit' => 5,
				'echo' => true,
				'before' => '<li>',
				'inside' => '',
				'outside' => '',
				'after' => '</li>',
				'rel' => 'nofollow',
				'type' => 'post',
				'message' => '<li><a href="'.$home.'">Sorry, no matches.</a></li>'
			  )
			); 
			echo '</ul>';
			echo '</div>';
		}?> 
        
        <h3 class="search">Live Search</h3>
        <div id="livesearch">
        <div class="ajax-loading"></div>
            <form method="get" action="<?php bloginfo('home'); ?>" autocomplete="off">
            	<fieldset>
                <input type="text" value="" name="s" id="s" class="text" style="margin-bottom: 10px;" />
                </fieldset>
            </form>            
        </div> 
        
        <?php // User Login Form ?>
		<?php if ( $user_ID ) { ?>
		<h3 class="unlocked">Control panel</h3>
		<ul class="users">
			<li><p>Your currently signed in as:<br /> <strong><?php echo $user_identity ?></strong>.</p></li>
            <li><?php
                echo get_avatar( $user_ID, $size = '50' ); 
				?>
			<ul>
				<li><a href="<?php bloginfo('url') ?>/wp-admin/">Dashboard</a></li>

				<?php if ( $user_level >= 1 ) : ?>
				<li><a href="<?php bloginfo('url') ?>/wp-admin/post-new.php">Write an article</a></li>
				<?php endif // $user_level >= 1 ?>
                <?php if ( function_exists('wpWikiFAQsList')) { 
				// The FAQs plugin is installed
                echo '<li><a href="'.get_bloginfo('wpurl').'/wp-admin/?page='.WPWIKIFAQS_FOLDER.'/addnew.php">Write a FAQ</a></li>';
                } ?>

				<li><a href="<?php bloginfo('url') ?>/wp-admin/profile.php">Your Profile</a></li>
				<li><?php wp_loginout(); ?></li>
			</ul>
			</li>
		</ul>
		<?php } else { // If not logged in ?>
                </p>
                </fieldset>
			</form>
			</li>

			<?php if ( get_option('users_can_register') ) { 
			// If registration is open ?>
            <li><a href="<?php bloginfo('url') ?>/wp-register.php">Become a Memeber</a></li>
            <?php } // Close registration code ?>
		<?php } // End User Login ?>
    </div>
