<?php 
// Custom functions by Derek Herman http://valendesigns.com

// Removes FAQs Headers, version generator, & wp-pagenavi css
remove_action('wp_head', 'faq_jQuery_header');
remove_action('wp_head', 'faq_js_header');
remove_action('wp_head', 'faq_css_header');
remove_action('wp_head','wp_generator');
remove_action('wp_head', 'pagenavi_css');
remove_action('wp_print_styles', 'pagenavi_stylesheets');

// Add filter to redirect user
add_filter( 'loginout', 'retun_after_logout' );

// If in category or subcategory of $cat_id
function in_or_sub_of($cat_id = 0) {
	foreach (get_the_category() as $cat) {
		if ($cat_id == $cat->cat_ID || cat_is_ancestor_of($cat_id, true)) {
			return true;
		}
	}
	return false;
}
// Retun after logout
function retun_after_logout( $link ) {
	$currenturl = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

	if ( !is_user_logged_in() )
		$link = str_replace( '">', '?redirect_to=' . urlencode( $currenturl ) . '">', $link );
	else
		$link = str_replace( '">', '&amp;redirect_to=' . urlencode( $currenturl ) . '">', $link );

	return $link;
}

// Custom Breadcrumb
if (!function_exists('wp_breadcrumb_nav')) {
	function wp_breadcrumb_nav() { 
		global $post;
		$homelink = '<a href="'.get_bloginfo('home').'">Home</a> &nbsp;&#8250;&nbsp; ';
	  function wiki_get_category_parents($id, $link = FALSE, $separator = ' &nbsp;&#8250;&nbsp; ', $nicename = FALSE){
			$chain = '';
			$parent = &get_category($id);
			if (is_wp_error( $parent )) {
			   return $parent;
			}
			if ( $nicename ) {
			   $name = $parent->slug;
			} else {
			   $name = $parent->cat_name;
			}
			if ($parent->parent && ($parent->parent != $parent->term_id)) {
			   $chain .= get_category_parents($parent->parent, true, $separator, $nicename);
			}
			$chain .= $name;
			return $chain;	
		}
	  if (is_single()) {
			$cats = get_the_category();
			$cat = $cats[0];
			$output .= get_category_parents($cat->term_id, true, " &nbsp;&#8250;&nbsp; ");
			$output .= get_the_title();
		}
		if ( is_category() ) {
			$cat = intval( get_query_var('cat') );
			$output .= wiki_get_category_parents($cat, false, " &nbsp;&#8250;&nbsp; ");
		} elseif ( is_tag() ) {
			$output .= single_cat_title('',false);
		} elseif (is_date()) { 
			$output .= 'Archives for: '.single_month_title(' ',false);
		} elseif (is_author()) { 
			global $wp_query;
	    $curauth = $wp_query->get_queried_object();
			$output .= 'Archives for: '.$curauth->display_name;
		} elseif (is_search()) {
			$output .= 'Search for: '.get_search_query();
		} elseif (is_404()) {
			$output .= 'Error 404';
		} else {
			if (!is_single()) {
				if( $post->post_parent ) {
					$output .= '<a href="'.get_permalink($post->post_parent).'">'.get_the_title($post->post_parent).'</a> &nbsp;&#8250;&nbsp; ';
				}
				$output .= get_the_title();
			}	
		}
		echo $homelink.$output;
	}
}

// Show active category on single pages
function show_active_category($text) {
	global $post;
	if( is_single()) {
		$categories = wp_get_post_categories($post->ID);
		// Parent category
		foreach( $categories as $parentid ) {
			$parent = get_category($parentid);
			if(preg_match('#<li class="cat-item cat-item-'.$parent->parent.'">#', $text)) {
				$text = str_replace('<li class="cat-item cat-item-'.$parent->parent.'">', '<li class="cat-item cat-item-'.$parent->parent.' current-cat-parent">', $text);
			}
		}
		// Child category
		foreach( $categories as $catid ) {
			$cat = get_category($catid);
			if(preg_match('#<li class="cat-item cat-item-'.$cat->cat_ID.'">#', $text)) {
				$text = str_replace('<li class="cat-item cat-item-'.$cat->cat_ID.'">', '<li class="cat-item cat-item-'.$cat->cat_ID.' current-cat">', $text);
			}
		}
	}
	return $text;
}

add_filter('wp_list_categories', 'show_active_category');

// Limit Articles to 4 on the home page
function custom_posts_per_page($query_string) {
global $posts_per;
	$query = new WP_Query();
	$query->parse_query($query_string);

	if (is_home()) {
		$num = 4;
	}

	if (isset($num)) {

		if (preg_match("/posts_per_page=/", $query_string)) {

				$query_string = preg_replace("/posts_per_page=[0-9]*/", "posts_per_page=$num", $query_string);
		} else {
				if ($query_string != '') {
						$query_string .= '&';
				}
		$query_string .= "posts_per_page=$num";
		}
	}
return $query_string;
}
add_filter('query_string', 'custom_posts_per_page');

// Check if Posts wil Paginate
function will_paginate() 
{
  global $wp_query;
  
  if ( !is_singular() ) 
  {
    $max_num_pages = $wp_query->max_num_pages;
    
    if ( $max_num_pages > 1 ) 
    {
      return true;
    }
  }
  return false;
}

// Very Basic Related Posts
function related_posts_by_category($params, $post_id = 0) {
	$entries = array();
	$output = '';
		if (!$post_id) {
			$post_id = $GLOBALS['post']->ID;
		}
	$entries = $GLOBALS['wpdb']->get_results(
	sprintf(
	"SELECT DISTINCT object_id, post_title FROM {$GLOBALS['wpdb']->term_relationships} r, {$GLOBALS['wpdb']->term_taxonomy} t, {$GLOBALS['wpdb']->posts} p WHERE t.term_id IN (SELECT t.term_id FROM {$GLOBALS['wpdb']->term_relationships} r, {$GLOBALS['wpdb']->term_taxonomy} t WHERE r.term_taxonomy_id = t.term_taxonomy_id AND t.taxonomy = 'category' AND r.object_id = $post_id) AND r.term_taxonomy_id = t.term_taxonomy_id AND p.post_status = 'publish' AND p.ID = r.object_id AND object_id <> $post_id %s %s %s",
	(isset($params['type']) === true && empty($params['type']) === false) ? ("AND p.post_type = '" .$params['type']. "'") : '',
	(isset($params['orderby']) === true && empty($params['orderby']) === false) ? ('ORDER BY ' .(strtoupper($params['orderby']) == 'RAND' ? 'RAND()' : $params['orderby']. ' ' .(isset($params['order']) ? $params['order'] : ''))) : '',
	(isset($params['limit']) === true && empty($params['limit']) === false) ? ('LIMIT ' .$params['limit']) : ''
	),
	OBJECT
	);
	if ($entries) { 
		foreach ($entries as $entry) {
			$output .= sprintf(
			'%s<a href="%s" %s title="%s">%s%s%s</a>%s',
			isset($params['before']) ? $params['before'] : '',
			get_permalink($entry->object_id),
			(isset($params['rel']) ? ('rel="' .$params['rel']. '"') : ''),
			$entry->post_title,
			isset($params['inside']) ? $params['inside'] : '',
			$entry->post_title,
			isset($params['outside']) ? $params['outside'] : '',
			isset($params['after']) ? $params['after'] : ''
			);
		}
	} else {
		$output = $params['message'];
	}
	if (isset($params['echo']) === true && $params['echo']) {
		echo $output;
	} else {
		return $output;
	}
}

// Code for Admin Theme Options
add_action('admin_menu', 'add_theme_pages');
add_option('welcome_desc', '<span>Hello</span><p>Welcome to the WordPress Wiki Theme. This theme will transform WordPress into a custom knowledge Base application to power your companies documentation needs. You\'ll be able to add articles and frequently asked questions, rate content, show related articles, and much more!</p>');
add_option('themecolor', 'blue');
add_option('allowcomments', 'yes');
add_action('wp_head', 'add_stylesheet');


function add_stylesheet() {
	echo '<link rel="stylesheet" href="'. get_bloginfo('template_directory').'/style_'. get_option('themecolor').'.css" type="text/css" media="screen" />';
}

function add_theme_pages() {
	add_theme_page('Theme Options', 'Theme Settings', 8, 'adminoptions', 'admin_options');
}
	
function admin_options() {
	?>
<div class="wrap" style="padding-bottom: 40px;">
	<?php echo "<h2 style='margin-bottom:25px;'>" . __( 'Theme Settings') . "</h2>"; ?>

	<?php if(!empty($_GET['updated'])) { echo '<!-- Last Action --><div id="message" class="updated fade"><p>Theme Options Updated</p></div>'; } ?>
  <form method="post" action="options.php">
  <input type="hidden" name="action" value="update" />
  <input type="hidden" name="page_options" value="welcome_desc, themecolor, allowcomments" />
  <?php wp_nonce_field('update-options'); ?>
  <p>Welcome Text:<br />
    <textarea name="welcome_desc" id="welcome_desc" cols="50" rows="6"><?php echo get_option('welcome_desc'); ?></textarea>
  </p>
  <p>Choose a Theme Color:
    <select name="themecolor" id="themecolor" value="<?php echo get_option('themecolor'); ?>">
      <option name="blue" value="blue"<?php if(get_option('themecolor') == "blue") { echo ' selected'; } ?>>blue</option>
      <option name="coffee" value="coffee"<?php if(get_option('themecolor') == "coffee") { echo ' selected'; } ?>>Coffee</option>
      <option name="cashew" value="cashew"<?php if(get_option('themecolor') == "cashew") { echo ' selected'; } ?>>Cashew</option>
      <option name="red" value="red"<?php if(get_option('themecolor') == "red") { echo ' selected'; } ?>>Red</option>
      <option name="green" value="green"<?php if(get_option('themecolor') == "green") { echo ' selected'; } ?>>Green</option>
      <option name="purple" value="purple"<?php if(get_option('themecolor') == "purple") { echo ' selected'; } ?>>Purple</option>
    </select>
  </p>
  <p>Allow Comments:
    <select name="allowcomments" id="allowcomments" value="<?php echo get_option('allowcomments'); ?>">
      <option name="yes" value="yes"<?php if(get_option('allowcomments') == "yes") { echo ' selected'; } ?>>yes</option>
      <option name="coffee" value="no"<?php if(get_option('allowcomments') == "no") { echo ' selected'; } ?>>no</option>
    </select>
  </p>
  <p class="submit"><input type="submit" value="<?php _e('Save Changes') ?>" name="Submit"/></p>
  </form>
</div>
<?
}

?>