<?php
/********************************************************
  NutsMail Global Configuration Setup
	Copyright (c) 2010 NutsMail	(http://nutsmail.com)
	Programming: Chris Kulbacki (http://chriskulbacki.com)
*********************************************************/

if (!defined("SM_PATH"))
	exit("Access denied.");

require_once(SM_PATH . "functions/nmThemeManager.php");
require_once(SM_PATH . "functions/nmVersion.php");
require_once(SM_PATH . "setup/nmSetup.php");

	$nmSetup = new NmSetup();

	// Check if should run configuration program and if has sufficient prifileges to do so.
	// During the normal run of the program this redirects to the login page.
	if (!$nmSetup->verifyConfigPermissions())
		exit("Permission denied.");

	// Configuration program is saving settings.
	$writeSuccess = $nmSetup->writeSettings($writeError);
	if ($writeSuccess && !@$username && !isset($_POST['folderError']))
	{
		header('Location: src/login.php');
		exit();
	}

	$nmSetup->getHeader();

	// check 1: config files

	$errorText = "";
	$tryAgainCode = "window.location.href=window.location.href";
	$nmSetup->checkDeleteFile(SM_PATH . "config/nutsmail_themes.php", $errorText);
	$nmSetup->checkDeleteFile(SM_PATH . "config/conf.pl", $errorText);
	$nmSetup->checkWritableFile(SM_PATH . "config/config.php", $errorText);
	$nmSetup->getThemes($errorText);

	// check 2: data folder

	if (!$errorText)
		$nmSetup->checkFolders($errorText, $tryAgainCode);

	// check 3: default_pref in data folder

	if (!$errorText)
	{
		$nmSetup->checkWritableFile($nmSetup->getDataDir() . "default_pref", $errorText);
		$nmSetup->checkWritableFile($nmSetup->getDataDir(), $errorText, "directory");
		$nmSetup->checkWritableFile($nmSetup->getAttachDir(), $errorText, "directory");
	}

	// display content

	if ($errorText)
	{
		echo "<div id='errorBox'>".
			(@$username ? "" : "<p>Welcome to NutsMail! Before you can configure your NutsMail system, you must fix the following setup problems:</p>").
			$errorText .
			"<p>Please correct the problems and click the 'Try again' button.</p>".
			"<div class='buttonBox'><a href='javascript:void(0)' onClick='$tryAgainCode' class='button'>Try again</a></div>".
			"</div>";
		$nmSetup->getFooter();
		exit();
	}
	else if ($writeError)
		echo "<div id='writeError' class='messageBox'>$writeError</div>";
	else if ($writeSuccess && !isset($_POST['folderError']))
		echo "<div id='writeSuccess' class='messageBox'>Configuration has been saved.</div>";

	$nmSetup->getOutput($nmParam);
	$nmSetup->getFooter();
