<?php

/**
 * page_header.php
 *
 * Prints the page header (duh)
 *
 * @copyright 1999-2010 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: page_header.php 13904 2010-02-13 16:28:10Z kink $
 * @package squirrelmail
 */

/** Include required files from SM */
require_once(SM_PATH . 'functions/strings.php');
require_once(SM_PATH . 'functions/html.php');
require_once(SM_PATH . 'functions/imap_mailbox.php');
require_once(SM_PATH . 'functions/global.php');

/* Always set up the language before calling these functions */
function displayHtmlHeader( $title = 'SquirrelMail', $xtra = '', $do_hook = TRUE ) {
    global $squirrelmail_language;

    if ( !sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION) ) {
        global $base_uri;
    }
    global $theme_css, $custom_css, $pageheader_sent;

    echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">' .
         "\n\n" . html_tag( 'html' ,'' , '', '', '' ) . "\n<head>\n";

		if (function_exists("nmHook"))
			nmHook("htmlHeaderStart");

		echo
         "<meta name=\"robots\" content=\"noindex,nofollow\">\n" .
         "<meta http-equiv=\"x-dns-prefetch-control\" content=\"off\">\n";

    if ( !isset( $custom_css ) || $custom_css == 'none' ) {
        if ($theme_css != '') {
            echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$theme_css\">";
        }
    } else {
        echo '<link rel="stylesheet" type="text/css" href="' .
             $base_uri . 'themes/css/'.$custom_css.'">';
    }

    if ($squirrelmail_language == 'ja_JP') {
        // Why is it added here? Header ('Content-Type:..) is used in i18n.php
        echo "<!-- \xfd\xfe -->\n";
        echo '<meta http-equiv="Content-type" content="text/html; charset=euc-jp">' . "\n";
    }

$cssfile = substr($custom_css, 0, -4);

    echo "<!--[if lte IE 6]>\n";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . "themes/css/".$cssfile."_ie.css\" />\n";
    echo "<![endif]-->\n";

    echo "<!--[if gte IE 7]>\n";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . "themes/css/".$cssfile."_ie7.css\" />\n";
    echo "<![endif]-->\n";

	echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $base_uri . "themes/css/print.css\" media=\"print\" />\n";

echo "<script type=\"text/javascript\" src=\"" . SM_PATH . "functions/jquery.js\"></script>\n";
//echo "<script src=\"" . SM_PATH . "functions/css_browser_selector.js\" type=\"text/javascript\"></script>\n";
echo "<script src=\"" . SM_PATH . "functions/jquery.cookie.js\" type=\"text/javascript\"></script>\n";

$doToggle = true;

if ($cssfile == "iWood" || ($cssfile == "iViola") || ($cssfile == "iClassic") || ($cssfile == "iSpruce")) {
	$doToggle = false;
} else {
	$doToggle = true;
}

if ($doToggle == true) {
echo "<script src=\"" . SM_PATH . "functions/nutsToggle.js\" type=\"text/javascript\"></script>\n";
echo <<<END
 <script type="text/javascript">
 if (jQuery) {
    $(document).ready(function(){
		$("#folders_top > p > a").nutsToggle("#folders","folders");
		$("#cal_top > p > a").nutsToggle("#cal","calendar");
		$("#todo_top > p > a").nutsToggle("#todo","todo");
		$("#extra_top > p > a").nutsToggle("#extra","options");
    });
};
 </script>
END;
} else {
	echo '<script type="text/javascript">'."\n".
		 " if (jQuery) {\n".
		 "  $(document).ready(function(){\n".
		 "    f = $(\"#folders\"),\n".
		 "    c = $(\"#cal\"),\n".
		 "    t = $(\"#todo\"),\n".
		 "    e = $(\"#extra\"),\n".
		 "    cookieF = \"Togglefolders\",\n".
		 "    cookieC = \"Togglecalendar\",\n".
		 "    cookieT = \"Toggletodo\",\n".
		 "    cookieO = \"Toggleoptions\";\n".
		 "	 if ($(f).is(\":hidden\")) { \n".
		 "	   $(f).show(); \n".
		 "	   $.cookie(cookieF, 'expanded', {expires: 90}); \n".
		 "	 } else if ($(c).is(\":hidden\")) { \n".
		 "	   $(c).show(); \n".
		 "	   $.cookie(cookieC, 'expanded', {expires: 90}); \n".
		 "	 } else if ($(t).is(\":hidden\")) { \n".
		 "	   $(t).show(); \n".
		 "	   $.cookie(cookieT, 'expanded', {expires: 90}); \n".
		 "	 } else if ($(e).is(\":hidden\")) { \n".
		 "	   $(e).show(); \n".
		 "	   $.cookie(cookieO, 'expanded', {expires: 90}); \n".
		 "	 } \n".
		 "  });\n".
		 " };\n".
		 "</script>\n";
}

    if ($do_hook) {
        do_hook('generic_header');
    }

    echo "\n<title>$title</title>$xtra\n";

    /* work around IE6's scrollbar bug */
    echo <<<ECHO
<!--[if IE 6]>
<style type="text/css">
/* avoid stupid IE6 bug with frames and scrollbars */
body {
    width: expression(document.documentElement.clientWidth - 30);
}
</style>
<![endif]-->

ECHO;

		if (function_exists("nmHook"))
			nmHook("htmlHeaderEnd");

    echo "\n</head>\n\n";

    /* this is used to check elsewhere whether we should call this function */
    $pageheader_sent = TRUE;
}

function makeInternalLink($path, $text, $target='', $linkClass='') {
    sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION);
    if ($target != '') {
        $target = " target=\"$target\"";
    }
    return '<a href="'.$base_uri.$path.'"'.$target.' class="'.$linkClass.'">'.$text."</a>\n";
}

function displayInternalLink($path, $text, $target='', $linkClass='') {
    echo makeInternalLink($path, $text, $target, $linkClass);
}

function displayPageHeader($color, $mailbox, $xtra='', $session=false, $bodyclass='') {

    global $hide_sm_attributions, $frame_top,
           $compose_new_win, $compose_width, $compose_height,
           $attachemessages, $provider_name, $provider_uri,
           $javascript_on, $default_use_mdn, $mdn_user_support,
           $startMessage, $org_title, $bodyclass;

    sqgetGlobalVar('base_uri', $base_uri, SQ_SESSION );
    sqgetGlobalVar('delimiter', $delimiter, SQ_SESSION );
    if (!isset($frame_top)) {
        $frame_top = '_top';
    }

    if ($session) {
        $compose_uri = $base_uri.'src/compose.php?mailbox='.urlencode($mailbox).'&amp;session='."$session";
    } else {
        $compose_uri = $base_uri.'src/compose.php?newmessage=1';
        $session = 0;
    }

    // only output JavaScript if actually turned on
    if($javascript_on || strpos($xtra, 'new_js_autodetect_results.value') ) {
        if ( !defined('PAGE_NAME') ) define('PAGE_NAME', NULL);
        switch ( PAGE_NAME ) {
        case 'read_body':
            $js ='';

            // compose in new window code
            if ($compose_new_win == '1') {
                if (!preg_match("/^[0-9]{3,4}$/", $compose_width)) {
                    $compose_width = '640';
                }
                if (!preg_match("/^[0-9]{3,4}$/", $compose_height)) {
                    $compose_height = '550';
                }
                $js .= "function comp_in_new(comp_uri) {\n".
                     "       if (!comp_uri) {\n".
                     '           comp_uri = "'.$compose_uri."\";\n".
                     '       }'. "\n".
                     '    var newwin = window.open(comp_uri' .
                     ', "_blank",'.
                     '"width='.$compose_width. ',height='.$compose_height.
                     ',scrollbars=yes,resizable=yes,status=yes");'."\n".
                     "}\n\n";
            }

            // javascript for sending read receipts
            if($default_use_mdn && $mdn_user_support) {
                $js .= "function sendMDN() {\n".
                         "    mdnuri=window.location+'&sendreceipt=1';\n" .
                         "    window.location = mdnuri;\n" .
                       "\n}\n\n";
            }

            // if any of the above passes, add the JS tags too.
            if($js) {
                $js = "\n".'<script language="JavaScript" type="text/javascript">' .
                      "\n<!--\n" . $js . "// -->\n</script>\n";
            }

            displayHtmlHeader($org_title, $js);
            $onload = $xtra;
          break;
        case 'compose':
            $bodyclass = 'compose';
            $js = '<script language="JavaScript" type="text/javascript">' .
             "\n<!--\n" .
             "var alreadyFocused = false;\n" .
             "function checkForm() {\n" .
             "\n    if (alreadyFocused) return;\n";

            global $action, $reply_focus;
            if (strpos($action, 'reply') !== FALSE && $reply_focus)
            {
                if ($reply_focus == 'select') $js .= "document.forms['compose'].body.select();}\n";
                else if ($reply_focus == 'focus') $js .= "document.forms['compose'].body.focus();}\n";
                else if ($reply_focus == 'none') $js .= "}\n";
            }
            // no reply focus also applies to composing new messages
            else if ($reply_focus == 'none')
            {
                $js .= "}\n";
            }
            else
                $js .= "    var f = document.forms.length;\n".
                "    var i = 0;\n".
                "    var pos = -1;\n".
                "    while( pos == -1 && i < f ) {\n".
                "        var e = document.forms[i].elements.length;\n".
                "        var j = 0;\n".
                "        while( pos == -1 && j < e ) {\n".
                "            if ( document.forms[i].elements[j].type == 'text' ) {\n".
                "                pos = j;\n".
                "            }\n".
                "            j++;\n".
                "        }\n".
                "        i++;\n".
                "    }\n".
                "    if( pos >= 0 ) {\n".
                "        document.forms[i-1].elements[pos].focus();\n".
                "    }\n".
                "}\n";

            $js .= "// -->\n".
                 "</script>\n";
            $onload = 'onload="checkForm();"';
            displayHtmlHeader($org_title, $js);
            break;

        default:
            $js = '<script language="JavaScript" type="text/javascript">' .
             "\n<!--\n" .
             "function checkForm() {\n".
             "   var f = document.forms.length;\n".
             "   var i = 0;\n".
             "   var pos = -1;\n".
             "   while( pos == -1 && i < f ) {\n".
             "       var e = document.forms[i].elements.length;\n".
             "       var j = 0;\n".
             "       while( pos == -1 && j < e ) {\n".
             "           if ( document.forms[i].elements[j].type == 'text' " .
             "           || document.forms[i].elements[j].type == 'password' ) {\n".
             "               pos = j;\n".
             "           }\n".
             "           j++;\n".
             "       }\n".
             "   i++;\n".
             "   }\n".
             "   if( pos >= 0 ) {\n".
             "       document.forms[i-1].elements[pos].focus();\n".
             "   }\n".
             "   $xtra\n".
             "}\n";

            if ($compose_new_win == '1') {
                if (!preg_match("/^[0-9]{3,4}$/", $compose_width)) {
                    $compose_width = '640';
                }
                if (!preg_match("/^[0-9]{3,4}$/", $compose_height)) {
                    $compose_height = '550';
                }
                $js .= "function comp_in_new(comp_uri) {\n".
                     "       if (!comp_uri) {\n".
                     '           comp_uri = "'.$compose_uri."\";\n".
                     '       }'. "\n".
                     '    var newwin = window.open(comp_uri' .
                     ', "_blank",'.
                     '"width='.$compose_width. ',height='.$compose_height.
                     ',scrollbars=yes,resizable=yes,status=yes");'."\n".
                     "}\n\n";

            }
        $js .= "// -->\n". "</script>\n";


        $onload = 'onload="checkForm();"';
        displayHtmlHeader($org_title, $js);
      } // end switch module
    } else {
        // JavaScript off
        displayHtmlHeader($org_title);
        $onload = '';
    }
    if (PAGE_NAME == 'right_main'){
        $bodyclass='mailbox';
    }
    echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\" $onload  leftmargin=\"5\" topmargin=\"0\" marginheight=\"0\" marginwidth=\"5\" class=\"$bodyclass\">\n\n";
    /** Here is the header and wrapping table **/
    $shortBoxName = htmlspecialchars(imap_utf7_decode_local(
                      readShortMailboxName($mailbox, $delimiter)));
    if ( $shortBoxName == 'INBOX' ) {
        $shortBoxName = _("INBOX");
    }
    echo "<a name=\"pagetop\"></a>\n";

    $urlMailbox = urlencode($mailbox);
    $startMessage = (int)$startMessage;
//====Start Org Name=======
    echo "<h2 id='org_name'>$org_title</h2>\n";
//====End Org Name=======

//====Start Menu Icons========
    echo "<div id='header_icons'>\n";
	echo "<div id='header_icons_wrap'>\n";
    displayInternalLink('src/right_main.php?PG_SHOWALL=0&amp;sort=0&amp;startMessage=1&amp;mailbox=INBOX',"<span class=\"button-wrap\"><span id='inbox_button'><span class='button_text'>"._("INBOX")."</span></span></span>","","inbox-button");
    echo makeComposeLink('src/compose.php?mailbox='.$urlMailbox.'&amp;startMessage='.$startMessage,"<span class=\"button-wrap\"><span id='compose_button'><span class='button_text'>"._("Compose")."</span></span></span>","","compose-button");
    displayInternalLink ('src/addressbook.php', "<span class=\"button-wrap\"><span id='addresses_button'><span class='button_text'>"._("Addresses")."</span></span></span>","","contacts-button");
    displayInternalLink ('src/folders.php', "<span class=\"button-wrap\"><span id='folders_button'><span class='button_text'>"._("Folders")."</span></span></span>","","folders-button");
	displayInternalLink ('src/options.php', "<span class=\"button-wrap\"><span id='options_button'><span class='button_text'>"._("Options")."</span></span></span>","","options-button");
	echo "</div>\n";
	echo "</div>\n";
//====End Menu Icons========

//===== Top Header =======
    echo "<div id='current_folder'>\n";
	echo "<div class='inbox_left_bar_handle'><img src='".$base_uri."images/divider.gif'></div>\n";

    if ( $shortBoxName <> '' && strtolower( $shortBoxName ) <> 'none' ) {
      echo _("Current Folder") . ": <b>$shortBoxName&nbsp;</b>\n";
    } else {
       echo _("Current Folder") . ": <b>$shortBoxName&nbsp;</b>\n";
    }
    echo  "</div>\n";
    echo "<div id='mini_icons'>\n";
	displayInternalLink ('src/signout.php', "<span id='exit_button' title='"._("Sign Out")."'><span>"._("Sign Out")."</span></span>\n", $frame_top);
	displayInternalLink ("src/search.php?mailbox=$urlMailbox", "<span id='search_button' title='"._("Search")."'><span>"._("Search")."</span></span>\n");
	displayInternalLink ('src/help.php', "<span id='help_button' title='"._("Help")."'><span>"._("Help")."</span></span>\n");
    do_hook('fetchmail');
    do_hook('calendar_plugin');
    do_hook('bookmark_plugin');
    do_hook('avelsieve_plugin');
	do_hook('notes_plugin');
	do_hook('todo_plugin');
    echo "</div>\n";

//======== End Top Header ========

//====Weclome Message Bar=====
//	echo "<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td class='top_left_bar_handle' width='5'><div align='right'><img src='".$base_uri."images/blank_transparent.gif'></div></td>";
//	echo "<td class='top_bar_header' align='left'  >";
    echo "<div id='welcome'>\n";
	do_hook('welcome');
    echo "</div>\n";
//    echo "&nbsp;</td>";
//  echo "<td class='top_bar_header' width='5'><div align='right'><img src='".$base_uri."images/divider.gif'></div></td>";
//	echo "<td class='top_bar_header' align='right' >";
	echo "<div id='menuline_hook'>\n";
    do_hook('menuline');
    echo "</div>\n";
    //echo "&nbsp;</td>";
	//echo "</tr></table><br>\n";

//==== End ====

}

/* blatently copied/truncated/modified from the above function */
function compose_Header($color, $mailbox) {

    global $delimiter, $hide_sm_attributions, $base_uri,
           $data_dir, $username, $frame_top, $compose_new_win;


    if (!isset($frame_top)) {
        $frame_top = '_top';
    }

    /*
        Locate the first displayable form element
    */
    if ( !defined('PAGE_NAME') ) define('PAGE_NAME', NULL);
    switch ( PAGE_NAME ) {
    case 'search':
        $pos = getPref($data_dir, $username, 'search_pos', 0 ) - 1;
        $onload = "onload=\"document.forms[$pos].elements[2].focus();\"";
        displayHtmlHeader (_("Compose"));
        break;
    default:
        $js = '<script language="JavaScript" type="text/javascript">' .
             "\n<!--\n" .
             "var alreadyFocused = false;\n" .
             "function checkForm() {\n" .
             "\n    if (alreadyFocused) return;\n";

            global $action, $reply_focus;
            if (strpos($action, 'reply') !== FALSE && $reply_focus)
            {
                if ($reply_focus == 'select') $js .= "document.forms['compose'].body.select();}\n";
                else if ($reply_focus == 'focus') $js .= "document.forms['compose'].body.focus();}\n";
                else if ($reply_focus == 'none') $js .= "}\n";
            }
            // no reply focus also applies to composing new messages
            else if ($reply_focus == 'none')
            {
                $js .= "}\n";
            }
            else
                $js .= "var f = document.forms.length;\n".
                "var i = 0;\n".
                "var pos = -1;\n".
                "while( pos == -1 && i < f ) {\n".
                    "var e = document.forms[i].elements.length;\n".
                    "var j = 0;\n".
                    "while( pos == -1 && j < e ) {\n".
                        "if ( document.forms[i].elements[j].type == 'text' ) {\n".
                            "pos = j;\n".
                        "}\n".
                        "j++;\n".
                    "}\n".
                "i++;\n".
                "}\n".
                "if( pos >= 0 ) {\n".
                    "document.forms[i-1].elements[pos].focus();\n".
                "}\n".
            "}\n";
        $js .= "// -->\n".
                 "</script>\n";
        $onload = 'onload="checkForm();"';
        displayHtmlHeader (_("Compose"), $js);
        break;

    }

    echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\" $onload>\n\n";
}
