<?php
/********************************************************
  NutsMail Theme Manager
	Copyright (c) 2010 NutsMail	(http://nutsmail.com)
	Programming: Chris Kulbacki (http://chriskulbacki.com)
*********************************************************/

if (!defined('SM_PATH')) define('SM_PATH', '../');

include "nmVersion.php";

if (!isset($default_theme_file))
	$default_theme_file = "";

if (!isset($default_theme_file_mobile))
	$default_theme_file_mobile = "";

$nmThemeManager = new NmThemeManager();
$nmThemeManager->createThemeArray($theme, $theme_default, $theme_css, $default_theme_file, $default_theme_file_mobile);

class NmThemeManager
{
	private $mobileDevice = "unknown";

	function createThemeArray(&$theme, &$theme_default, &$theme_css, $default_theme_file, $default_theme_file_mobile)
	{
		// get theme file names (on linux the files aren't in alphabetical order, place them in array and sort)
		$files = array();
		if ($handle = opendir(SM_PATH . "themes"))
		{
			while (($fileName = readdir($handle)) !== false)
				if ($fileName != "." && $fileName != ".." && strtolower(substr($fileName, -4)) == ".php" && $fileName != "index.php" && $fileName != "default_theme.php")
					array_push($files, $fileName);
			closedir($handle);
		}

		sort($files);

		if (!$default_theme_file_mobile)
			$default_theme_file_mobile = $default_theme_file;

		$defaultFile = $this->isMobileDevice() ? $default_theme_file_mobile : $default_theme_file;

		$index = count($theme);
		foreach ($files as $val)
		{
			$theme[$index]['PATH'] = SM_PATH . "themes/" . $val;
			$theme[$index]['NAME'] = $this->getThemeName($val);

			if (basename($theme[$index]['PATH']) == $defaultFile)
			{
				$theme_default = $index;
				$theme_css = $this->getThemeCssPath($val);
			}

			$index++;
		}

		// if default theme still set to default, set it to the first installed theme
		if (!$theme_default && count($theme) > 1)
		{
			$theme_default = 1;
			$theme_css = $this->getThemeCssPath($theme[1]['PATH']);
		}
	}

	private function getThemeCssPath($phpFileName)
	{
		// legacy themes
		$array = array("iclassic_theme.php"=>"iClassic.css", "iwood_theme.php"=>"iWood.css", "ispruce_theme.php"=>"iSpruce.css", "iviola_theme.php"=>"iViola.css", "iceblue_theme.php"=>"iceblue.css",
			"coralorange_theme.php"=>"coralorange.css", "steelgrey_theme.php"=>"steelgrey.css", "mintgreen_theme.php"=>"mintgreen.css", "bluehive_theme.php"=>"bluehive.css",
			"xpbluesky_theme.php"=>"XP_BlueSky.css", "xpsilver_theme.php"=>"XP_Silver.css", "xpsummer_theme.php"=>"XP_Summer.css", "xpredstorm_theme.php"=>"XP_Redstorm.css");

		$phpFileName = basename($phpFileName);

		// check legacy names (css file names are different than php file names)
		if (array_key_exists(strtolower($phpFileName), $array))
			return SM_PATH . "themes/css/" . $array[$phpFileName];

		return SM_PATH . "themes/css/" . str_replace(".php", "", $phpFileName) . ".css";
	}

	private function getThemeName($themeFile)
	{
		$contents = @file_get_contents(SM_PATH . "themes/" . $themeFile);
		if (!$contents)
			return "";

		// get name from theme's php file
		$i = strpos($contents, "NutsMail theme:");
		if ($i)
		{
			$j = strpos($contents, "\n", $i + 15);
			if ($j)
			{
				$s = trim(strip_tags(substr($contents, $i + 15, $j - $i -15)));
				if ($s)
					return $s;
			}
		}

		// get legacy name
		$s = $this->getLegacyName($themeFile);
		if ($s)
			return $s;

		// make name out of file name
		return ucWords(str_replace("_", " ", str_replace(".php", "", $themeFile)));
	}

	private function getLegacyName($themeFile)
	{
		$array = array("iclassic_theme.php"=>"i:Classic", "iwood_theme.php"=>"i:Wood", "ispruce_theme.php"=>"i:Spruce", "iviola_theme.php"=>"i:Viola", "iceblue_theme.php"=>"W2:IceBlue",
			"coralorange_theme.php"=>"W2:CoralOrange", "steelgrey_theme.php"=>"W2:SteelGrey", "mintgreen_theme.php"=>"W2:MintGreen", "bluehive_theme.php"=>"BlueHive",
			"xpbluesky_theme.php"=>"XP:BlueSky", "xpsilver_theme.php"=>"XP:Silver", "xpsummer_theme.php"=>"XP:Summer", "xpredstorm_theme.php"=>"XP:RedStorm");

		if (array_key_exists(strtolower($themeFile), $array))
			return $array[$themeFile];
		return "";
	}

	function isMobileTheme($themeFile)
	{
		return strpos($themeFile, "mobile") !== false;
	}

	function isMobileDevice()
	{
		// return cached result
		if ($this->mobileDevice != "unknown")
			return $this->mobileDevice;

		if (strpos(strtolower(@$_SERVER['HTTP_USER_AGENT']), 'windows') > 0)
		{
			$this->mobileDevice = false;
			return false;
		}

		$this->mobileDevice =
			preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android)/i', strtolower(@$_SERVER['HTTP_USER_AGENT'])) ||
			strpos(strtolower(@$_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0 ||
			isset($_SERVER['HTTP_X_WAP_PROFILE']) ||
			isset($_SERVER['HTTP_PROFILE']) ||
			strpos(strtolower(@$_SERVER['ALL_HTTP']),'OperaMini') > 0 ||
			in_array(strtolower(substr(@$_SERVER['HTTP_USER_AGENT'], 0, 4)), array(
		    'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
		    'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
		    'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
		    'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
		    'newt','noki','oper','palm','pana','pant','phil','play','port','prox',
		    'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
		    'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
		    'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
		    'wapr','webc','winw','winw','xda ','xda-'));

		//$this->mobileDevice = true; //!!!

		return $this->mobileDevice;
	}

}
