<?php
/**
 * NoNumber! Elements Helper File: VersionCheck
 *
 * @package     NoNumber! Elements
 * @version     2.6.8
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright © 2011 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die();

class NNVersions
{
	function &instance()
	{
		static $instance;
		if ( !is_object( $instance ) ) {
			$instance = new NoNumberVersions;
		}
		return $instance;
	}
}
class NoNumberVersions
{
	function getMessage( $extension = '', $xml = '', $version = '', $addmargin = 0 )
	{
		if ( !$extension || ( !$xml && !$version ) ) {
			return;
		}

		$alias = preg_replace( '#[^a-z\-]#', '', str_replace( '?', '-', strtolower( $extension ) ) );

		if ( $xml ) {
			$xml = JApplicationHelper::parseXMLInstallFile( JPATH_SITE.DS.( str_replace( '/', DS, $xml ) ) );
			if ( $xml && isset( $xml['version'] ) ) {
				$version = $xml['version'];
			}
		}

		if ( !$version ) {
			return;
		}

		$document =& JFactory::getDocument();
		$document->addScript( JURI::root(true).'/plugins/system/nonumberelements/js/script.js' );
		$url = 'http://www.nonumber.nl/ext/version.php?ext='.$alias.'&version='.$version;
		$script = "
			window.addEvent( 'domready', function() {
				nnScripts.loadajax(
					'".$url."',
					'nnScripts.displayVersion( \'".$alias."\', data )',
					'nnScripts.displayVersion( \'".$alias."\', \'\' )'
				);
			});
		";
		$document->addScriptDeclaration( $script );

		$msg = html_entity_decode( JText::sprintf( 'NN_A_NEWER_VERSION_IS_AVAILABLE', 'http://www.nonumber.nl/'.$alias.'/download', '<span id="nonumber_newversionnumber_'.$alias.'"></span>', $version ), ENT_COMPAT, 'UTF-8' );

		$margin = $addmargin ? '10px;' : '3px;';
		$msg = '<div style="border:3px solid #F0DC7E;color:#CC0000;margin-bottom:'.$margin.'"><div style="padding: 2px 5px;background-color:#EFE7B8">'.$msg.'</div></div>';
		$msg = '<div id="nonumber_version_'.$alias.'" style="display: none;">'.$msg.'</div>';

		return $msg;
	}

	function getVersion( $extension, $xml )
	{
		if ( !$extension || !$xml ) {
			return;
		}

		$version = '';
		if ( $xml ) {
			$xml = JApplicationHelper::parseXMLInstallFile( JPATH_SITE.DS.( str_replace( '/', DS, $xml ) ) );
			if ( $xml && isset( $xml['version'] ) ) {
				$version = $xml['version'];
			}
		}
		return $version;
	}

	function setMessage( $current_version = '0', $version_file = '' )
	{
		echo $this->getMessage( str_replace( 'version_', '', $version_file ), '', $current_version, 1 );
	}
}