<?php

//**************************************************************
// Fly06 Spammer Blocker for Joomla 1.5              
// Copyright (C) 2009-2010 by Frédéric Leroy (aka Fly06)   
// --------------- All Rights Reserved ----------------      
// Homepage   : http://www.fly06.fr/        
// Version    : 1.1 beta    
// Date       : 06/04/10
// License    : GNU/GPL            
//**************************************************************
// APIs : Stop Forum Spam
// http://www.stopforumspam.com/
//**************************************************************

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class  plgSystemSpammerBlocker extends JPlugin
{
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object	$subject The object to observe
	 * @param 	array   $config  An array that holds the plugin configuration
	 * @since	1.5
	 */
	function plgSystemSpammerBlocker(& $subject, $config) {
		parent::__construct($subject, $config);
		
		// Fichier langue
		$lang =& JFactory::getLanguage();
		$lang->load('plg_system_spammerblocker', JPATH_ADMINISTRATOR);

	}
	
	function onAfterRoute() {
	
		// On récupère l'objet $mainframe
		$mainframe = &JFactory::getApplication();
		
		// Si on est dans l'admin, on sort
		if ($mainframe->isAdmin()) {
			return; 
		}
		
		// On charge le helper.php
		require_once ( JPATH_BASE . DS . 'plugins' . DS . 'system' . DS . 'spammerblocker' . DS . 'helper.php' );

		// On crée une instance de la classe spammerBlockerHelper
		$helper = new spammerBlockerHelper();
	
		// Si on est hors contexte ==> on sort
		if (!$helper->isApplicable()) {
			return;
		}
		
		// On initialise l'objet $helper
		$helper->init();
	
		// Si on est en mode useredit et que la config du plugin ne couvre pas ce mode, on sort
		if ($helper->isNotUserEditApplicable()) {
			return;
		}
	
		// Si pas de possibilité de connexion distante, on dépublie le plugin, on informe l'admin et on sort	
		if (!$helper->isRemoteConnexionPossible()) {
			$helper->unpublishPlugin();
			return;
		}
			
		// Si aucun critère de détection n'est activé, on dépublie le plugin, on informe l'admin et on sort
		if (!$helper->isPluginConfigurationOk()) {
			$helper->unpublishPlugin();
			return;
		}

		// Check for request forgeries
		$helper->checkToken() or jexit( 'Invalid Token' );

		// Récupération des paramètres à vérifier
		if (!$helper->setUserData()) {
			return;
		}

		// Vérification des paramètres		
		if (!$helper->getXMLFromSFS()) {
			if ($helper->remoteConnexionFailed()) {
				return;
			}
		}		
		
		// Si l'utilisateur est un spammer, on le bloque
		if($helper->isUserASpammer()) {
			$helper->blockSpammer();
		}
	
	} // Fin onAfterRoute

} // Fin class

?>
