<?php


//**************************************************************
// Fly06 Spammer Blocker for Joomla 1.5              
// Copyright (C) 2009-2010 by Frdric Leroy (aka Fly06)   
// --------------- All Rights Reserved ----------------      
// Homepage   : http://www.fly06.fr/        
// Version    : 1.1 beta    
// Date       : 06/04/10
// License    : GNU/GPL            
//**************************************************************
// APIs : Stop Forum Spam
// http://www.stopforumspam.com/
//**************************************************************

defined('_JEXEC') or die('Direct Access to this location is not allowed.');
 
class ModSpammerBlockerHelper {
	
    /**
     * Returns a list of spammer items
    */
    function getItems($spammerCount, $spammerID, $spammerType, $spammerLink, $showTooltip, $dateFormat) {
        // get a reference to the database
        $db = &JFactory::getDBO();
        
        // Construction de la clause where
        $where = ModSpammerBlockerHelper::_getWhere($spammerType);
        
        // get a list of $userCount randomly ordered users 
        $query = 'SELECT id, ' . $spammerID . ' AS identifiant, ' . $spammerID . '_status AS identifiant_status, date '
        			. 'FROM #__spammerblocker_log '
        			. $where
        			. ' ORDER BY date DESC LIMIT ' . (int) $spammerCount  . ''
        			;
 
        $db->setQuery($query);
        //$items = ($items = $db->loadObjectList()) ? $items:array();
        $items = $db->loadObjectList();
        
        // Construction des liens
				$items = ModSpammerBlockerHelper::_buildLink($spammerLink, $showTooltip, $items, $dateFormat);
 
        return $items;
    }
    
    function _getWhere($spammerType) {
 
			switch ($spammerType) {
      	case 'visitor':
        	 $where = 'WHERE user_id = 0 ';
        	 break;
        case 'user':
        	 $where = 'WHERE user_id > 0 ';
        	 break;
        case 'both':
        default:
         	$where = '';  
         	break;
      }     	
    	
    	return $where;
    }
    
    function _buildLink($spammerLink, $showTooltip, $items, $dateFormat) {
    	
     	for ($i=0, $n=count($items); $i < $n; $i++) {
				if ($showTooltip) {
					$items[$i]->identifiant = ModSpammerBlockerHelper::_buildTooltipYes($spammerLink, $items[$i]->identifiant, $items[$i]->identifiant_status, $items[$i]->date, $items[$i]->id, $dateFormat);
				} else {
					$items[$i]->identifiant = ModSpammerBlockerHelper::_buildTooltipNo($spammerLink, $items[$i]->identifiant, $items[$i]->identifiant_status);				
				}
      }    	
    	
    	return $items;
    }
    
    function _buildTooltipYes($spammerLink, $identifiant, $status, $date, $id, $dateFormat) {
    	
    	$content = sprintf(JText::_('SPMOD_HAS_BEEN_IDENTIFIED'), $identifiant, ModSpammerBlockerHelper::_buildTextList($id));
    	$title = ModSpammerBlockerHelper::_getDateToFormat($date, $dateFormat);
    	$img = '';
    	$text = $identifiant;
    	$link = ($spammerLink && $status == 1 ? 'http://www.stopforumspam.com/search?q=' . $identifiant : '');
    	
    	$tooltip_yes = JHTML::tooltip($content, $title, $img, $text, $link);
    	
    	return $tooltip_yes;
    }
    
    function _buildTooltipNo($spammerLink, $identifiant, $status) {
    	
    	$tooltip_no = $identifiant;
    	
    	if ($spammerLink  && ($status == 1)) {
    		$tooltip_no = '<a href="http://www.stopforumspam.com/search?q=' . $identifiant . '" target="blank">' . $identifiant . '</a>';     	
    	}
    	
    	return $tooltip_no;
    }
    
    function _getDateToFormat($date, $dateFormat){      
    
     if( defined('_JEXEC') ){
       //joomla 1.5            
       $JApp =& JFactory::getApplication();
       $date = JFactory::getDate($date);
       $date->setOffset($JApp->getCfg('offset'));   
       $date = ( $dateFormat ? $date->toFormat($dateFormat) : $date->toFormat() );   
     }
    
     return $date;
   }
   
   function _buildTextList($id) {
   	
   	$db = &JFactory::getDBO();

   	$query = 'SELECT email_status, username_status, ip_status FROM #__spammerblocker_log WHERE id=' . (int) $id;
    $db->setQuery($query);
    $row = $db->loadObject();
    
    $text = '';
    $divider = '';
    
    if ($row->email_status == 1) {
    	$text = JText::_( 'SPMOD_IDENFIANT_ITS_EMAIL' ) . $text;
    	$divider = JText::_( 'SPMOD_AND' );
    }	
   	
    if ($row->ip_status == 1) {
    	$text = JText::_( 'SPMOD_IDENFIANT_ITS_IP' ) . $divider . $text;
 			$divider = ($divider ?  JText::_( 'SPMOD_COMMA' ) : JText::_( 'SPMOD_AND' ));
    }	
   	   	
    if ($row->username_status == 1) {
    	$text = JText::_( 'SPMOD_IDENFIANT_ITS_USERNAME' ) . $divider . $text;
    }	   
   
  	return $text;	
  }
    
} 
