<?php

//**************************************************************
// Fly06 Spammer Blocker for Joomla 1.5              
// Copyright (C) 2009-2010 by Frdric Leroy (aka Fly06)   
// --------------- All Rights Reserved ----------------      
// Homepage   : http://www.fly06.fr/        
// Version    : 1.1 beta    
// Date       : 06/04/10
// License    : GNU/GPL            
//**************************************************************
// APIs : Stop Forum Spam
// http://www.stopforumspam.com/
//**************************************************************

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );

/**
 * @package		Joomla
 * @subpackage	SpammerBlocker
 */
class SpammerBlockerModelReset extends JModel
{

	var $lists = '';

	/**
	 * Overridden constructor
	 * @access	protected
	 */
	function __construct()
	{
		parent::__construct();
	}

	function reset( $reset_option )
	{
		$db =& JFactory::getDBO();
		
		// get the total number of records
		$query = 'SELECT COUNT(*) FROM #__spammerblocker_log' . $this->_getWhere($reset_option);
		$db->setQuery( $query );
		$total = $db->loadResult();

		// Suppression des logs en base			
		$query = 'DELETE FROM #__spammerblocker_log' . $this->_getWhere($reset_option);
		$db->setQuery( $query );
		$db->query();

		// Construction du message
		$msg = $this->_getResetMsg($reset_option, $total);
		
		return $msg;
	}

	function getTotal()
	{
		global $mainframe, $option;
		
		// Connexion  la base de donnes
		$db	=& JFactory::getDBO();

		// On vrifie qu'il y a des logs  supprimer
		$query = 'SELECT COUNT(*) FROM #__spammerblocker_log';
		$db->setQuery( $query );
		$total = $db->loadResult();

		// Si il n'y en a pas, on sort avec redirection
		if (!$total) {
			$dbprefix = $mainframe->getCfg( 'dbprefix', 'jos_' );
			$mainframe->redirect('index.php?option='.$option, sprintf(JText::_('SB_RESET_LOG_TABLE_EMPTY'), $dbprefix));
		}
		
		// On construit le formulaire
		$reset_log_options = array();	
		
		// Option de suppression de tout les logs
		$reset_log_options[] = JHTML::_('select.option',  'all', sprintf(JText::_( 'SB_RESET_LOG_OPTION_ALL'), $total));	

		// Construction des autres options
		$valid_period = array('day', 'week', 'month', 'year');
		
		foreach ($valid_period as $period) {

			// get the total number of records
			$query = 'SELECT COUNT(*) FROM #__spammerblocker_log' . $this->_getWhere($period);
			$db->setQuery( $query );
			$sub_total = $db->loadResult();
			
			// Si il y a des logs, on construit un lment de formulaire et on l'ajoute  la liste
			// Sinon on sort de la boucle			
			if ($sub_total) {
				$reset_log_options[] = JHTML::_('select.option',  $period, sprintf(JText::_( 'SB_RESET_LOG_OPTION_ALL_EXCEPT_' . strtoupper($period) ), $sub_total));
			} else {
				break;
			}			
						
		} // Fin foreach
		
		// On construit le bloc radio
		$this->lists['reset_options'] = JHTML::_('select.radiolist',   $reset_log_options, 'reset_option', '', 'value', 'text', 'all' );
		
		return $total;	
	}
	
	// Mthode prive de construction de la clause where
	function _getWhere($period) {
		
		$where = '';
		
		if ($period == 'all') {
			return $where;
		}
		
		$where = ' WHERE DATEDIFF(NOW(), DATE(date)) >= ';
		
		switch ($period) {
			case 'year' :
				$where .= 'DAYOFYEAR(NOW())';
				break;
			case 'month':
				$where .= 'DAYOFMONTH(NOW())';
				break;
			case 'week':
				$where .= 'DAYOFWEEK(NOW())';
				break;
			case 'day':
			default:
				$where .= '1';
				break;
		} 
		
		return $where;
	}
	
	// Mthode de construction du message retourne aprs le reseten base
	function _getResetMsg($reset_option, $total) {
		
		switch ($reset_option) {
			case 'all':
				$msg = sprintf(JText::_('SB_RESET_LOG_MSG_ALL'), $total);
				break;
			case 'year':
			case 'month':
			case 'week':
			case 'day':
			default:
				if ($total == 1) {
					$msg = sprintf(JText::_('SB_RESET_LOG_MSG_ONE'), $total);				
				} else {
					$msg = sprintf(JText::_('SB_RESET_LOG_MSG_SEVERAL'), $total);						
				}
				break;
		}
		
		return $msg;
		
	}

}