<?php
/**
 * @version		1.1.0
 * @package		jFinalizer
 * @copyright	(c) 2010 farbfinal.de
 * @license		GNU General Public License version 2 or later;
 *
 * joomla! 1.5+ system plugin
 *
 * documentation & support: www.farbfinal.de/jfinalizer
 *
 * Error Handler Class, 
 * only loaded if errors occour
 *
*/

defined('_JEXEC') or die;

/* class jFinalizerErrorHandler
 * simply a collection of our Errors
*/

class jFinalizerErrorHandler {

	var $errors = array();
	var $records = array();

	function __construct() {
	
		$this->errors[200] = "Subdirectory path set but incorrect: ";
		$this->errors[201] = "Resulting physical path from given subdir does not exit: "; 
		$this->errors[202] = "<strong> Tip</strong>: if your joomla installation subdirectory is example.com/joomladir, use <strong>/joomladir</strong>, not joomladir/ or /joomladir/ or joomladir as subdirectory entry"; 
		$this->errors[100] = "cannot create cache path: ";
		$this->errors[101] = "Output Path Alias is set but does not exist: ";		
		$this->errors[102] = "";	
		$this->errors[103] = "";	
		$this->errors[104] = "";	
		$this->errors[401] = "asset file not found: ";	
		$this->errors[402] = "remote file inclusion enabled but file could not be loaded: ";	
		$this->errors[403] = "cannot store asset cache file to disk: ";	
		$this->errors[501] = "cannot open or create file for writing: ";	
		
	}

	public function show($id, $var){
		$this->records[] = "<strong>jFinalizer Error ".$id.":</strong> ".$this->errors[$id].$var."<br />";
	}
	
	public function msg($msg){
		$this->records[] = $msg."<br />";
	}

	public function display(){
		$dump='';
		if (count($this->records)>0){
			$dump = "<div id='jfdebugwin' style='position:absolute;top:0px;right:0px;z-index:999;padding:10px;background:#FF8827;color:#FFF;border:5px solid #22A8E9;'>";
			foreach ($this->records AS $r){
				$dump .= $r;
			}
			$dump .= "<a href='#' onclick='javascript:document.getElementById(\"jfdebugwin\").style.visibility=\"hidden\";'>hide</a>";
			$dump .= "</div>";
		}
		return $dump;
	}

}

?>