<?php
/**
 * YouTubeGallery Joomla! 1.5 Native Component
 * @version 1.4.5
 * @author DesignCompass Corp <admin@designcompasscorp.com>
 * @link http://www.designcompasscorp.com
 * @license GNU/GPL
 **/


defined('_JEXEC') or die('Restricted access');

$mainframe->registerEvent('onPrepareContent', 'plgContentYouTubeGallery');

function plgContentYouTubeGallery(&$row, &$params, $page=0)
{
	if (is_object($row)) {
		plgYouTubeGallery($row->text, $params);
		plgYouTubeGalleryByID($row->text, $params);
	}
	else
	{
		plgYouTubeGallery($row, $params);
		plgYouTubeGalleryByID($row, $params);
	}
}

///////////////////

function plgYouTubeGallery(&$text, &$params)
{
	
	$yg=new YouTubeGalleryClass;
	
	$options=array();
	$fList=$yg->getListToReplace('youtubegallery',$options,$text);
	
	
	if(count($fList)>0)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_youtubegallery'.DS.'includes'.DS.'misc.php');
		require_once(JPATH_SITE.DS.'components'.DS.'com_youtubegallery'.DS.'includes'.DS.'render.php');
	}
	
	for($i=0; $i<count($fList);$i++)
	{
		$replaceWith=$yg->getYouTubeGallery($options[$i],$i,false);
		
		$text=str_replace($fList[$i],$replaceWith,$text);	
	}
	
	
	return true;
}

function plgYouTubeGalleryByID(&$text, &$params)
{
	
	$yg=new YouTubeGalleryClass;
	
	$options=array();
	$fList=$yg->getListToReplace('youtubegalleryid',$options,$text);
	
	if(count($fList)>0)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_youtubegallery'.DS.'includes'.DS.'misc.php');
		require_once(JPATH_SITE.DS.'components'.DS.'com_youtubegallery'.DS.'includes'.DS.'render.php');
	}
	
	for($i=0; $i<count($fList);$i++)
	{
		$replaceWith=$yg->getYouTubeGallery($options[$i],$i,true);
		
		$text=str_replace($fList[$i],$replaceWith,$text);	
	}
	
	
	return true;
}


class YouTubeGalleryClass
{
	
	
	function getListToReplace($par,&$options,&$text)
	{
		$fList=array();
		$l=strlen($par)+2;
	
		$offset=0;
		do{
			if($offset>=strlen($text))
				break;
		
			$ps=strpos($text, '{'.$par.'=', $offset);
			if($ps===false)
				break;
		
		
			if($ps+$l>=strlen($text))
				break;
		
		$pe=strpos($text, '}', $ps+$l);
				
		if($pe===false)
			break;
		
		$notestr=substr($text,$ps,$pe-$ps+1);

			$options[]=substr($text,$ps+$l,$pe-$ps-$l);
			$fList[]=$notestr;
			

		$offset=$ps+$l;
		
			
		}while(!($pe===false));
		
		return $fList;
	}

	

	function getYoutubeGallery($galleryparams,$count,$byId)
	{
		$result='';
		
		$opt=explode(',',$galleryparams);
		if(count($opt)<1)
			return '';
	
		
		$db = & JFactory::getDBO();
		
		if($byId)
		{
			$galleryid=(int)$opt[0];
			$query = 'SELECT * FROM #__youtubegallery WHERE id='.$galleryid.' LIMIT 1';
		}
		else
		{
			$galleryname=trim($opt[0]);
			$query = 'SELECT * FROM #__youtubegallery WHERE galleryname="'.$galleryname.'" LIMIT 1';
		}
			
		
		$db->setQuery($query);
		if (!$db->query())    die ( $db->stderr());
		
		
		$rows = $db->loadObjectList();
				
		if(count($rows)==0)
			return '';
			
		$row=$rows[0];
		
		
		
		if(count($opt)>1)
		{
			$row->width=(int)$opt[1];
			
			$row->height=(int)$opt[2];
			$row->playvideo=(int)$opt[3];
			$row->repeat=(int)$opt[4];
			$row->fullscreen=(int)$opt[5];
			$row->autoplay=(int)$opt[6];
			$row->relatedvideos=(int)$opt[7];
			$row->showinfo=(int)$opt[8];
			$row->thumbbgcolor=$opt[9];
			$row->columns=(int)$opt[10];
			
			$row->showtitle=(int)$opt[11];
			
			/*$width=(int)$opt[1];
			$height=(int)$opt[2];
			$playvideo=(int)$opt[3];
			$repeat=(int)$opt[4];
			$fullscreen=(int)$opt[5];
			$autoplay=(int)$opt[6];
			$relatedvideos=(int)$opt[7];
			$showinfo=(int)$opt[8];
			$thumbbgcolor=$opt[9];
			$columns=(int)$opt[10];
			
			$showtitle=(int)$opt[11];
			$showdescription=$row->description;
			*/
			
		}
		else
		{
			/*
			$width=$row->width;
			$height=$row->height;
			$playvideo=$row->playvideo;
			$repeat=$row->repeat;
			$fullscreen=$row->fullscreen;
			$autoplay=$row->autoplay;
			$relatedvideos=$row->related;
			$showinfo=$row->showinfo;
			$thumbbgcolor=$row->bgcolor;
			$columns=$row->cols;
			$showtitle=$row->showtitle;
			$showdescription=$row->description;
			*/
		}
		
		/*
		if($width<1)
			$width=400;
			
		if($height<1)
				$height=300;
		*/
		
		
		//$gallery_name=$row->galleryname;
	

		$Misc=new YouTubeGalleryMisc;
		
		
		
		$firstvideo='';
		
		//print_r($row);
		
		//echo '$row->enablecache='.$row->enablecache.'<br>';
		if($row->enablecache)
		{
			$result.='
<!-- Youtube Gallery - Cache Enabled -->';
			$gallery_list=$Misc->getGalleryList_FromCache($row->cache,$firstvideo);
		}
		else
		{
			$rawList=YouTubeGalleryMisc::csv_explode("\n", $row->gallerylist, '"', true);
			$gallery_list=$Misc->formGalleryList($rawList,$row->showtitle,$row->description,$firstvideo,$row->showactivevideotitle);
		}			
			
		if($row->playvideo==1 and JRequest::getVar('videoid'))
			$row->autoplay=1;
		
		if($row->playvideo==1 and !JRequest::getVar('videoid'))
			JRequest::setVar('videoid',$firstvideo);


		$Misc->tablerow = &$row;

		$renderer= new YouTubeGalleryRenderer;
		
		$result.=$renderer->render(
								 $gallery_list,
								 $galleryid,
								 $Misc->tablerow);
	
		return $result;
	
	}

	
}


?>