<?php
# Copyright 2008 eriestuff.blogspot.com


## INITIALIZE ##############################################################################################################################################################
// include polygon GEO class (which includes polygon.class.php, wich includes vertex.class.php)
require('./class/polygon.geo.class.php');
// include KML function library
require('./class/kml.lib.php');
// init resource arrays
$urls = array();
$files = array();
// start session
session_start();


## SET HARDCODED VARS #######################################################################################################################################################
// google maps api key
define('GOOGLE_MAPS_API_KEY','ABQIAAAAwhB3lTdaZFrJsKa0FPFlVhQgDxaUP40jgCyfoOcj_n5cTh0q5hSHBxVoo-0EDWgn3iSgL0e1D6vn1w');
// google analitics id
define('GOOGLE_ANALITICS_ID','UA-2964824-2');
// set default values
// - urls to default KML files containing polygons (google map url or KML url)
$urls[] = 'http://maps.google.com/maps/ms?ie=UTF8&hl=en&msa=0&msid=109046886555039097315.000447a2753be0851225e&z=12'; //ErieStuff: test KML
// - Perimiter check distance
$default_distance = 1000; // in meters
// - map initial center and zoom level
$lat = '52.365014022082676';
$lng = '4.893208140209909';
// - map zoomlevel
$zoom = 12;
// - show polygons on map?
$showPolygons = TRUE;


## HANDLE REQUEST VARS ######################################################################################################################################################
// get uploaded file uri if a kml file is uploaded
if(getUploadedFileData('uploadedfile')){$files[] = getUploadedFileData('uploadedfile');}
// if file is uploaded, dont use the default urls
if(count($files)){$urls = array();}
// if urls provided through requestvars, dont use the default urls
if((isset($_REQUEST['url1']) && !empty($_REQUEST['url1'])) || (isset($_REQUEST['url2']) && !empty($_REQUEST['url2'])) || (isset($_REQUEST['url3']) && !empty($_REQUEST['url3']))){$urls = array();}
// add requested urls to resource array
$urls = (isset($_REQUEST['url1']) && !empty($_REQUEST['url1']))?array_merge($urls,array(urldecode($_REQUEST['url1']))):$urls;
$urls = (isset($_REQUEST['url2']) && !empty($_REQUEST['url2']))?array_merge($urls,array(urldecode($_REQUEST['url2']))):$urls;
$urls = (isset($_REQUEST['url3']) && !empty($_REQUEST['url3']))?array_merge($urls,array(urldecode($_REQUEST['url3']))):$urls;
// make google maps output a kml file if a custom created google maps map url is provided
foreach($urls as &$url){$url .= (strpos($url,"maps.google.com/maps/ms?") && !strpos($url,"output=kml") )?'&output=kml':'';}
// get latitude and longitude, if requested, override initial mapcenter and zoomlevel
$lat = (isset($_REQUEST['lat']))?urldecode($_REQUEST['lat']):$lat;
$lng = (isset($_REQUEST['lng']))?urldecode($_REQUEST['lng']):$lng;
// get distance or set default
$distance = (isset($_REQUEST['distance']))?floatval($_REQUEST['distance']):$default_distance;
// set ajax request switch
$bool_ajax_request = (isset($_REQUEST['ajaxrequest']))?TRUE:FALSE;


## OUTPUT JAVASCRIPT STATEMENTS, IF POINT TEST IS REQUESTED ##################################################################################################################
// if coordinate is requested, reply which polygons contain the coordinate
// send javascript statements, to be evaluated clientside
if($bool_ajax_request){
	$output = '';
	if(isset($lat) && isset($lng) 
	&& isset($_SESSION['point_in_polygon']) && isset($_SESSION['point_in_polygon']['kmls'])){
		$kmls = $_SESSION['point_in_polygon']['kmls'];
		$vertex = new vertex($lng,$lat);
		$output .= "var ajaxResponse = true; //<br/>\n";
		$output .= "var polyNames = new Array(); //<br/>\n";
		// loop all kml sources
		foreach($kmls as & $kml){
			// loop all polygons
			foreach($kml->arr_placemarks as & $placemark){
				if($placemark['type']=='Polygon'){
					$polygon =& new geo_polygon();
					foreach($placemark['coordinates'] as & $coord){
						$polygon->addv($coord[0],$coord[1]);
					}
					$isInside = ($polygon->isInside($vertex))? 'true':'false';
					$dist2point = round($polygon->distance2point($vertex),2);
					$output .= "polyNames.push({docName:'".$kml->str_document_name."',polyName:'".$placemark['name']."',distance2point:".$dist2point.",isInside:".$isInside."}); //<br/>\n";
				}
			}
		}
	}
	// send javascript and exit
	echo $output;
	exit;
}


## LOAD KML SOURCES #########################################################################################################################################################
// get all kml data from urls and uploaded file(s)
// instantiate new kml object, which will load the provided url and read in the data
// and add it to the array of kml files
$kmls = array();
foreach($files as &$uri){
	$kmls[] =& new kml($uri['tmp_name']);
	$kmls[count($kmls)-1]->set_filename($uri['name']);
}
foreach($urls as &$url){
	$kmls[] =& new kml($url);
}


## SAVE VALUES IN SESSION ###################################################################################################################################################
// needed to sync the ajax requests with the initial request
$_SESSION['point_in_polygon'] = array();
$_SESSION['point_in_polygon']['kmls'] = $kmls; 


## OUTPUT HTML ###############################################################################################################################################################
// set/check output variables
// - need at least three urls set or NULL (to output in the formfields)
while(count($urls)<3){$urls = array_merge($urls,array(NULL));}
// start output
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<title>Point In Polygon - Gmaps - Eriestuff</title>
	<link rel="stylesheet" href="./css/style.css" type="text/css" media="screen" />
	<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo GOOGLE_MAPS_API_KEY ?>" type="text/javascript"></script>
	<script type="text/javascript">//<![CDATA[

// set user defined constants
var START_LOCATION 		= <?php echo "['$lat','$lng']" ?>;
var START_ZOOM			= <?php echo $zoom ?>;
var URL_ICON			= "./img/green_MarkerX.png"
var ID_MAP_DIV			= 'map';

// initialize global vars
var map;
var form;
var marker;
var polygons;

// set onload function
//google.setOnLoadCallback(onLoad);
window.onload = onLoad; if (window.captureEvents) window.captureEvents(Event.LOAD);

function onLoad() {
	// setup Google Map
	map = new GMap2(document.getElementById(ID_MAP_DIV));
	map.setCenter(new GLatLng(START_LOCATION[0],START_LOCATION[1]), START_ZOOM);
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.enableScrollWheelZoom();
	// add onclick functionalities to map
	GEvent.addListener(map, "click", function(overlay, point){
		onClick(overlay,point);
	});
<?php
	// show polygons in client
	if($showPolygons){
		echo "	\n";
		echo "	// add polygons // \n";
		echo "	polygons = new Array(); \n";
		foreach($kmls as $kml){
			// loop all polygons
			foreach($kml->arr_placemarks as & $placemark){
				if($placemark['type']=='Polygon'){
					echo "	/* next polygon */ \n";
					echo "	var points = new Array(); \n";
					foreach($placemark['coordinates'] as $key=>& $coord){
						echo "	points.push(new GLatLng('".$coord[1]."','".$coord[0]."'));"."\n";
					}
					echo "	polygons[polygons.length] = new GPolygon(points,'#000000',2,.5,'#ff0000',.5,{clickable:false});\n";
				}
			}
		}
		echo "	\n";
		echo "	// show the polygons if checkbox is checked \n";
		echo "	togglePolygons();\n";
		echo "	\n";
		echo "	// add onclick event to toggle checkbox\n";
		echo "	var toggleCheckbox = document.getElementById('toggleCheckbox');\n";
		echo "	toggleCheckbox.onclick = togglePolygons; if (toggleCheckbox.captureEvents) toggleCheckbox.captureEvents(Event.CLICK);\n";
	}
	?>

	// build/add marker
	var icon = new GIcon(G_DEFAULT_ICON);
	icon.image = URL_ICON;
	marker = new GMarker(new GLatLng(START_LOCATION[0],START_LOCATION[1]), {icon:icon, draggable:true});
	map.addOverlay(marker);
	// - ondrag -> close info window
	GEvent.addListener(marker, "drag", function(){
		marker.closeInfoWindow();
	});
	// - ondragend -> search nearby
	GEvent.addListener(marker, "dragend", function(){
		isPointInPolygon(this.getLatLng());
	});
}

function onClick(overlay,point){
	if(!overlay){
		// move marker
		marker.setLatLng(point);
		// check if point is in polygon(s)
		isPointInPolygon(point);
	}
}

function togglePolygons(){
	for(i=0;i<polygons.length;i++){
		if(document.getElementById('toggleCheckbox') && document.getElementById('toggleCheckbox').checked){
			map.addOverlay(polygons[i]);
		}else{
			map.removeOverlay(polygons[i]);
		}
	}
}

function isPointInPolygon(point){
	var maxDist = parseInt(document.getElementById('distance').value);
	var lat = point.lat();
	var lng = point.lng();
	GDownloadUrl("./pip.php?ajaxrequest&lat="+lat+"&lng="+lng, function(data, responseCode) {
		if(responseCode == 200 && data.substring(0,24)=='var ajaxResponse = true;'){
			eval(data);
			var htmlString = '<h2>Point:</h2><h3>' + marker.getLatLng().lat() + ',' + marker.getLatLng().lng() +'</h3>';
			var htmlString2 = '<h2>Polygons within '+maxDist+' meter range:</h2>';
			var docName1 = '';
			var docName2 = '';
			if(polyNames.length){
				htmlString += '<h2>Inside Polygons:</h2>';
				for(var key in polyNames){
					var dist = polyNames[key].distance2point;
					if(polyNames[key].isInside){
						if(docName1!=polyNames[key].docName){
							docName1=polyNames[key].docName;
							htmlString += '<h3><b>'+docName1+':</b></h3>';
						}
						htmlString += '<h3>'+polyNames[key].polyName+' ('+dist+'m from border)</h3>';
					}else{
						if(dist<maxDist){
							if(docName2!=polyNames[key].docName){
								docName2=polyNames[key].docName;
								htmlString2 += '<h3><b>'+docName2+':</b></h3>';
							}
							htmlString2 += '<h3>'+dist+' meter from '+polyNames[key].polyName+'</h3>';
						}
					}
				}
			}
			htmlString += htmlString2;
			marker.openInfoWindowHtml(htmlString);
		} else if(responseCode == -1) {
			alert("Data request timed out. Please try later.");
		} else { 
			alert("Request resulted in error.");
		}
	});
}
	//]]></script>
</head>
<body onunload="GUnload()">
	<div id="columncontainer">
		<div id="columnleft">
			<div id="columnleftheader" >
				<h1>Point in Polygon</h1>
				<a href="index.html" >Other Gmaps Apps</a>
			</div>
			<div id="columnleftcontent" >
				<h2>KML source(s):</h2>
				<form id="formSources" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<h3>KML or google map urls:</h3>
						<input type="text" name="url1" id="url1" value="<?php echo htmlentities($urls[0]) ?>" /><label for="url1">URL 1</label><br/>
						<input type="text" name="url2" id="url2" value="<?php echo htmlentities($urls[1]) ?>" /><label for="url2">URL 2</label><br/>
						<input type="text" name="url3" id="url3" value="<?php echo htmlentities($urls[2]) ?>" /><label for="url3">URL 3</label><br/>
						<h3>Path to local KML file:</h3>
						<input type="hidden" name="MAX_FILE_SIZE" value="50000" />
						<input type="file" name="uploadedfile" id="uploadedfiles" size="12" /><br />
						<br />
						<input type="submit" name="fetchSubmit" id="fetchSubmit" value="go" />
					</fieldset>
				</form>
				<h2>Settings:</h2>
				<form id="formSettings" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<h3>Polygon search perimiter</h3>
						<input type="text" name="distance" id="distance" value="<?php echo $distance ?>" /><label for="distance">Distance in meters</label><br/>
						<br/>
						<?php 
						if($showPolygons){
						?><h3>Display polygons from KMLs</h3>
						<input type="checkbox" id="toggleCheckbox" /><label for="toggleCheckbox">Show polygons on map</label><?php echo "\n";
						}
						?>
					</fieldset>
				</form>
				<?php
				if(count($kmls)){
					?><h2>Polygons found in sources:</h2><?php echo "\n";
			    	foreach ($kmls as & $kml){
						echo "\t\t\t\t".'<h3>'.htmlentities($kml->str_document_name).'</h3>'."\n";
						echo "\t\t\t\t<ul>\n";
				    	foreach ($kml->arr_placemarks as & $placemark){
							if($placemark['type']=='Polygon'){
								echo "\t\t\t\t\t".'<li>'.htmlentities($placemark['name']).'</li>'."\n";
							}
						}
						echo "\t\t\t\t</ul>\n";
						echo "\t\t\t\t<br/>\n";
					}
				}
				?>
			</div>
		</div>	
		<div id="columnmid">
		    <div id="map" ></div>
		</div>
	</div>

	<!-- GOOGLE ANALITICS -->
	<script type="text/javascript">
		var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
		document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>
	<script type="text/javascript">
		var pageTracker = _gat._getTracker("<?php echo GOOGLE_ANALITICS_ID ?>");
		pageTracker._initData();
		pageTracker._trackPageview();
	</script>
	<!-- end analitics -->
</body>
</html>
<?php
exit;
?>