<?php
# Copyright 2008 eriestuff.blogspot.com


## INITIALIZE ##############################################################################################################################################################
// include polygon GEO class (which includes polygon.class.php, wich includes vertex.class.php)
require('./class/polygon.geo.class.php');
// include KML function library
require('./class/kml.lib.php');
// init resource arrays
$urls = array();
$files = array();
// start session
session_start();


## SET HARDCODED VARS #######################################################################################################################################################
// google maps api key
define('GOOGLE_MAPS_API_KEY','ABQIAAAA2lUQd3ZukUPtmyKvqyraNxSjpsy6iNNi_5zxtOfkqNAs5cFIHRQvkHPP_XwXzwUb3CHrg1bl8cxZhA');
// google analitics id
define('GOOGLE_ANALITICS_ID','UA-2964824-2');
// set default values
// - urls to default KML files containing polygons (google map url or KML url)
//$urls[] = 'http://maps.google.com/maps/ms?ie=UTF8&hl=en&msa=0&msid=106261964444126324589.00043d39709993c577c03&t=h&z=14'; // Parken
//$urls[] = 'http://maps.google.com/maps/ms?ie=UTF8&hl=en&om=0&msa=0&msid=106261964444126324589.00043d39c84d6fb3bd60f&z=11'; // Stadsdelen
$urls[] = 'http://maps.google.com/maps/ms?ie=UTF8&hl=en&msa=0&msid=109046886555039097315.000446b26979ba4e902ee&z=14'; //ErieStuff: Align Polygons - test KML
// - Perimiter check distance
$default_distance = 1; // in meters
// - map initial center and zoom level
$lat = '52.365014022082676';
$lng = '4.893208140209909';
// - map zoomlevel
$zoom = 12;
// - show vertices on map?
$showVertices = TRUE;
$showPolygons = TRUE;


## HANDLE REQUEST VARS ######################################################################################################################################################
// get uploaded file uri if a kml file is uploaded
if(getUploadedFileData('uploadedfile')){$files[] = getUploadedFileData('uploadedfile');}
// if file is uploaded, dont use the default urls
if(count($files)){$urls = array();}
// if urls provided through requestvars, dont use the default urls
if((isset($_REQUEST['url1']) && !empty($_REQUEST['url1'])) || (isset($_REQUEST['url2']) && !empty($_REQUEST['url2'])) || (isset($_REQUEST['url3']) && !empty($_REQUEST['url3']))){$urls = array();}
// add requested urls to resource array
$urls = (isset($_REQUEST['url1']) && !empty($_REQUEST['url1']))?array_merge($urls,array(urldecode($_REQUEST['url1']))):$urls;
$urls = (isset($_REQUEST['url2']) && !empty($_REQUEST['url2']))?array_merge($urls,array(urldecode($_REQUEST['url2']))):$urls;
$urls = (isset($_REQUEST['url3']) && !empty($_REQUEST['url3']))?array_merge($urls,array(urldecode($_REQUEST['url3']))):$urls;
// make google maps output a kml file if a custom created google maps map url is provided
foreach($urls as &$url){$url .= (strpos($url,"maps.google.com/maps/ms?") && !strpos($url,"output=kml") )?'&output=kml':'';};unset($url);
// get latitude and longitude, if requested, override initial mapcenter and zoomlevel
$lat = (isset($_REQUEST['lat']))?urldecode($_REQUEST['lat']):$lat;
$lng = (isset($_REQUEST['lng']))?urldecode($_REQUEST['lng']):$lng;
// get distance or set default
$distance = (isset($_REQUEST['distance']))?floatval($_REQUEST['distance']):$default_distance;
// set checkboxes to stay checked if they where checked
$toggleCheckboxPolygons		= (isset($_REQUEST['toggleCheckboxPolygons']))?		'checked="checked"':'';
$toggleCheckboxEqual		= (isset($_REQUEST['toggleCheckboxEqual']))?		'checked="checked"':'';
$toggleCheckboxAligned 		= (isset($_REQUEST['toggleCheckboxAligned']))?		'checked="checked"':'';
$toggleCheckboxNotAligned 	= (isset($_REQUEST['toggleCheckboxNotAligned']))?	'checked="checked"':'';


## OUTPUT KML IF REQUESTED ################################################################################################################################################
// if more kmls loaded, find out which one was requested for output
$key=0;while(!isset($_REQUEST['outputKML_'.$key]) && $key<10)$key++;
if(isset($_REQUEST['outputKML_'.$key]) && isset($_SESSION['align_polygons_kmls']) && isset($_SESSION['align_polygons_kmls'][$key])){
	$_SESSION['align_polygons_kmls'][$key]->output_kml();
	exit;
}


## LOAD KML SOURCES #########################################################################################################################################################
// get all kml data from urls and uploaded file(s)
// instantiate new kml object, which will load the provided url and read in the data
// and add it to the array of kml files
$kmls = array();
foreach($files as &$uri){
	$kmls[] =& new kml($uri['tmp_name']);
	$kmls[count($kmls)-1]->set_filename($uri['name']);
}
foreach($urls as &$url){
	$kmls[] =& new kml($url);
}
// make clean polygon array with vertices referenced to kml source array
$arrPolygons = array();
foreach($kmls as $kml){
	foreach($kml->arr_placemarks as & $placemark){
		if($placemark['type'] == 'Polygon'){
			$arrPolygons[] = & $placemark['coordinates'];
		}
	}
}


## ALIGN POLYGONS ##########################################################################################################################################################
// align vertices of all polygons that are close to eachother
if(count($arrPolygons)){
	$arrResult = alignPolygons($arrPolygons,$distance);
}


## SAVE VALUES IN SESSION ###################################################################################################################################################
// save kml data in session to be able to output it as kml, when requested
$_SESSION['align_polygons_kmls'] = array();
foreach($kmls as $key => $kml){
	$_SESSION['align_polygons_kmls'][$key]=$kml;
}


## OUTPUT HTML ###############################################################################################################################################################
// set/check output variables
// - need at least three urls set or NULL (to output in the formfields)
while(count($urls)<3){$urls = array_merge($urls,array(NULL));}
// start output
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<title>Align Polygons - Gmaps - Eriestuff</title>
	<link rel="stylesheet" href="./css/style.css" type="text/css" media="screen" />
	<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo GOOGLE_MAPS_API_KEY ?>" type="text/javascript"></script>
	<script type="text/javascript">//<![CDATA[

// set user defined constants
var START_LOCATION 		= <?php echo "['$lat','$lng']" ?>;
var START_ZOOM			= <?php echo $zoom ?>;
var ID_MAP_DIV			= 'map';
var URL_ICON_GREENX		= "./img/green_MarkerX.png"; 
var URL_ICON_BLUEX		= "./img/blue_MarkerX.png";
var URL_ICON_REDX		= "./img/red_MarkerX.png";
 
// initialize global vars
var map;
var form;
var marker;
var polygons;
var pointsAligned;
var pointsNotAligned;

// set onload function
//google.setOnLoadCallback(onLoad);
window.onload = onLoad; if (window.captureEvents) window.captureEvents(Event.LOAD);

function onLoad() {
	// setup Google Map
	map = new GMap2(document.getElementById(ID_MAP_DIV));
	map.setCenter(new GLatLng(START_LOCATION[0],START_LOCATION[1]), START_ZOOM);
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.enableScrollWheelZoom();
<?php
	// show polygons in client 
	if($showPolygons){
		echo "\t/* add polygons */ \n";
		echo "\tpolygons = new Array(); \n";
		foreach($arrPolygons as $poly){
			echo "\t/* next polygon */ \n";
			echo "\tvar points = new Array(); \n";
			foreach($poly as $vertex){
				echo "\tpoints.push(new GLatLng('".$vertex[1]."','".$vertex[0]."'));"."\n";
			}
			echo "\tpolygons[polygons.length] = new GPolygon(points,'#000000',2,.5,'#ff0000',.5,{clickable:false});\n";
		}
		echo "\t// show polygons if checkbox is checked \n";
		echo "\ttogglePolygons();\n";
		echo "\t// add onclick event to toggle checkbox\n";
		echo "\tvar toggleCheckboxPolygons = document.getElementById('toggleCheckboxPolygons');\n";
		echo "\ttoggleCheckboxPolygons.onclick = togglePolygons; if (toggleCheckboxPolygons.captureEvents) toggleCheckboxPolygons.captureEvents(Event.CLICK);\n";
	}
	?>
<?php
	// show vertices in client 
	if($showVertices){
		echo "\t// add onclick event to toggle checkbox\n";
		echo "	var toggleCheckboxAligned = document.getElementById('toggleCheckboxAligned');\n";
		echo "	toggleCheckboxAligned.onclick = togglePointsAligned; if (toggleCheckboxAligned.captureEvents) toggleCheckboxAligned.captureEvents(Event.CLICK);\n";
		echo "	var toggleCheckboxNotAligned = document.getElementById('toggleCheckboxNotAligned');\n";
		echo "	toggleCheckboxNotAligned.onclick = togglePointsNotAligned; if (toggleCheckboxNotAligned.captureEvents) toggleCheckboxNotAligned.captureEvents(Event.CLICK);\n";
		echo "	var toggleCheckboxEqual = document.getElementById('toggleCheckboxEqual');\n";
		echo "	toggleCheckboxEqual.onclick = togglePointsEqual; if (toggleCheckboxEqual.captureEvents) toggleCheckboxEqual.captureEvents(Event.CLICK);\n";

		echo "	// add markers // \n";
		echo "	var bounds = new GLatLngBounds();\n";
		echo "	pointsEqual = new Array(); \n";
		echo "	pointsAligned = new Array(); \n";
		echo "	pointsNotAligned = new Array(); \n";
		foreach($arrPolygons as $poly){
			echo "	/* next polygon */ \n";
			$i=0;
			foreach($poly as $vertex){
				if(++$i<count($poly)){
					if(isset($vertex[3])){
						switch($vertex[3]){
							case 'aligned': echo "	pointsAligned[pointsAligned.length] = createMarker(new GLatLng('".$vertex[1]."','".$vertex[0]."'),URL_ICON_GREENX,false)\n";break;
							case 'equal':	echo "	pointsEqual[pointsEqual.length] = createMarker(new GLatLng('".$vertex[1]."','".$vertex[0]."'),URL_ICON_REDX,false)\n";break;
						}
					}else{
						echo "	pointsNotAligned[pointsNotAligned.length] = createMarker(new GLatLng('".$vertex[1]."','".$vertex[0]."'),URL_ICON_BLUEX,false)\n";
					}
				}
			}
		}
		echo "	togglePolygons();\n";
		echo "	togglePointsEqual();\n";
		echo "	togglePointsAligned();\n";
		echo "	togglePointsNotAligned();\n";
	}
	?>
}
function togglePointsAligned(){
	points = pointsAligned;
	id = 'toggleCheckboxAligned';
	for(i=0;i<points.length;i++){
		if(document.getElementById(id).checked){
			map.addOverlay(points[i]);
		}else{
			map.removeOverlay(points[i]);
		}
	}
}
function togglePointsNotAligned(){
	points = pointsNotAligned;
	id = 'toggleCheckboxNotAligned';
	for(i=0;i<points.length;i++){
		if(document.getElementById(id).checked){
			map.addOverlay(points[i]);
		}else{
			map.removeOverlay(points[i]);
		}
	}
}
function togglePointsEqual(){
	points = pointsEqual;
	id = 'toggleCheckboxEqual';
	for(i=0;i<points.length;i++){
		if(document.getElementById(id).checked){
			map.addOverlay(points[i]);
		}else{
			map.removeOverlay(points[i]);
		}
	}
}
function togglePolygons(){
	for(i=0;i<polygons.length;i++){
		if(document.getElementById('toggleCheckboxPolygons').checked){
			map.addOverlay(polygons[i]);
		}else{
			map.removeOverlay(polygons[i]);
		}
	}
}
function createMarker(point, urlIcon, boolDraggable){
	var icon = new GIcon(G_DEFAULT_ICON);
	icon.image = urlIcon;
	var marker = new GMarker(point, {icon:icon, draggable:boolDraggable});
//	map.addOverlay(marker);
	return marker;
}

	//]]></script>
</head>
<body onunload="GUnload()">
	<div id="columncontainer">
		<div id="columnleft">
			<div id="columnleftheader" >
				<h1>Align Polygons</h1>
				<a href="index.html" >Other Gmaps Apps</a>
			</div>
			<div id="columnleftcontent" >
				<h2>KML sources &amp; align settings:</h2>
				<form id="formSources" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<h3>KML or google map urls:</h3>
						<input type="text" name="url1" id="url1" value="<?php echo htmlentities($urls[0]) ?>" /><label for="url1">URL 1</label><br/>
						<input type="text" name="url2" id="url2" value="<?php echo htmlentities($urls[1]) ?>" /><label for="url2">URL 2</label><br/>
						<input type="text" name="url3" id="url3" value="<?php echo htmlentities($urls[2]) ?>" /><label for="url3">URL 3</label><br/>
						<h3>Path to local KML file:</h3>
						<input type="hidden" name="MAX_FILE_SIZE" value="50000" />
						<input type="file" name="uploadedfile" id="uploadedfiles" size="12" /><br />
						<br />
						<h3>Equalize threshold:</h3>
						<input type="text" name="distance" id="distance" value="<?php echo $distance ?>" /><label for="distance">Distance in meters</label><br/>
						<br/>
						<input type="submit" name="fetchSubmit" id="fetchSubmit" value="go" />
					</fieldset>
				</form>
<?php
				if(isset($arrResult) && count($arrResult)){
				?>
				<h2>Results:</h2>
				<form id="formResult" enctype="multipart/form-data" method="post" action="" >
					<fieldset>
						<h3>Statistics:</h3>
						Polygon pairs checked: <?php echo $arrResult[0]; ?> <br/>
						Vertex pairs checked: <?php echo $arrResult[1]; ?> <br/>
						Vertex pairs aligned: <?php echo $arrResult[2]; ?> <br/>
						Vertex pairs already equal: <?php echo $arrResult[3]; ?> <br/>
<?php		
					if($showPolygons){
						?>
						<h3>Show result on map:</h3>
						<input type="checkbox" id="toggleCheckboxPolygons" name="toggleCheckboxPolygons" <?php echo $toggleCheckboxPolygons ?> /><label for="toggleCheckboxPolygons">Polygons</label><br/>
						<input type="checkbox" id="toggleCheckboxEqual" name="toggleCheckboxEqual" <?php echo $toggleCheckboxEqual ?> /><label for="toggleCheckboxEqual">Already equal vertices</label><br/>
						<input type="checkbox" id="toggleCheckboxAligned" name="toggleCheckboxAligned" <?php echo $toggleCheckboxAligned ?> /><label for="toggleCheckboxAligned">Aligned vertices</label><br/>
						<input type="checkbox" id="toggleCheckboxNotAligned" name="toggleCheckboxNotAligned" <?php echo $toggleCheckboxNotAligned ?> /><label for="toggleCheckboxNotAligned">Other vertices</label><br/>
					</fieldset>
				</form>
<?php				}
					?>
				<h2>Download aligned polygons:</h2>
				<form id="formDownload" enctype="multipart/form-data" method="post" action="" >
<fieldset>
<?php
			    	foreach ($kmls as $key => & $kml){
						echo "\t\t\t\t\t".'<h3>'.htmlentities($kml->str_document_name)."</h3>\n";
						echo "\t\t\t\t\t<ul>\n";
				    	foreach ($kml->arr_placemarks as & $placemark){
							if($placemark['type']=='Polygon'){
								echo "\t\t\t\t\t\t<li>".htmlentities($placemark['name'])."</li>\n";
							}
						}
						echo "\t\t\t\t\t</ul>\n";
						echo "\t\t\t\t\t".'<input type="submit" name="outputKML_'.$key.'" value="Download altered KML" /><br/>'."\n";
						echo "\t\t\t\t\t".'<br/>'."\n";
					}
					?>
</fieldset>
				</form>
<?php 
				}
				?>				
			</div>
		</div>	
		<div id="columnmid">
		    <div id="map" ></div>
		</div>
	</div>

	<!-- GOOGLE ANALITICS -->
	<script type="text/javascript">
		var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
		document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>
	<script type="text/javascript">
		var pageTracker = _gat._getTracker("<?php echo GOOGLE_ANALITICS_ID ?>");
		pageTracker._initData();
		pageTracker._trackPageview();
	</script>
	<!-- end analitics -->
</body>
</html>

<?php
exit;

// FUNCTION DEFENITIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// alignPolygons
// This function takes a bunch of polygons and checks if any of their vertices
// are so close to eachother that they are probably meant to have the same coordinates
// This is especialy usefull for polygons that border eachother and thus share many 
// vertices, like borders of countries. This type of polygons should not overlap or 
// have gaps in between them.
// 
// The polygons to be checked should sit in an array and should be passed as the first
// argument. The format of the polygons array should be:
// arrPolygons[arrPolygon[arrVertex[floLat,floLng]]];
// 
// The distance that 2 vertices should be apart not to be considered the same has to be
// set as the optional second argument (in meters). 
//
// The algorithm checks the polygon array against its reverse, as shown below, so the loop
// can be exited before a polygon is checked against itself. This way each polygon pair is 
// only checked once, since ab == ba
// 
//   d c b a
// a x x x .
// b x x . .	
// c x . . .
// d . . . .
// 
// The function alters the vertex coordinates in the polygon array and returns the number
// of altered vertices.
function alignPolygons(&$arrPolygons,$maxDistance=100){
	// initialise counters (for debug and fun)
	$intPolygonCount = 0;
	$intVertexCount = 0;
	$intEqualizedCount = 0;
	$intEqualCount = 0;
	// loop through all polygons in array
	$a=0;
	foreach($arrPolygons as &$polygon1){
		$a++;
		// reverse the array to check against
		$arrPolygonsReverse = array();
	    for($i=0, $j=count($arrPolygons); $i<count($arrPolygons); $i++, $j--) {
	        $arrPolygonsReverse[$i] =& $arrPolygons[$j-1];
	    }
		// check vertrices of polygon1 against vertrices of all other polygons
		$b=0;
		foreach($arrPolygonsReverse as &$polygon2){
			$b++;
			// dont check against itself
			// dont continue if all pairs have been checked (ab==ba)
			// this works because polygon2 is the reverse of polygon1
			//  see general comments above for more info
			if ($polygon2 == $polygon1) break; // break from foreach loop, continu with next polygon1
			// loop all vertices of polygon1 to check against all vertices of polygon2
			$c=0;
			foreach ($polygon1 as $key1 => & $vertex1){
				$c++;
				// last vertex should be the same as first vertex (asume closed polygons)
				if($vertex1==$polygon1[0]){
					//set last vertex to reference first vertex
					$polygon1[count($polygon1)-1] =& $vertex1;
				}
				// last vertex is first vertex, so it's already checked, break from loop
				if($key1==count($polygon1)-1) break;
				// loop all vertices of polygon2 to check with current vertex of polygon1
				$d=0;
				foreach ($polygon2 as $key2 => & $vertex2){
					$d++;
					// last vertex should be the same as first vertex (asume closed polygons)
					if($vertex2==$polygon2[0]){
						//set last vertex to reference first vertex
						$polygon2[count($polygon2)-1] =& $vertex2;
					}
					// last vertex is first vertex, so it's already checked, break from loop
					if($key2==count($polygon2)-1) break;
					// calculate distance between points
					$distance = dist_vincenty($vertex1[0],$vertex1[1],$vertex2[0],$vertex2[1]);
					// count vertex as checked
					$intVertexCount++;
					// check distance against threshold
					if($distance>0 && $distance<$maxDistance){
						// vertices closer together than threshold value
						// equalize vertices
						// set vertex2 to reference the value of vertex1;
						$polygon1[$key1] = array(($vertex1[0]+$vertex2[0])/2,($vertex1[1]+$vertex2[1])/2,($vertex1[2]+$vertex2[2])/2,'aligned');
						$polygon2[$key2] =& $polygon1[$key1];
						// count vertex pair as equalized
						$intEqualizedCount++;
					}elseif($distance==0){
						// vertices have exact same coordinates
						// check if they were not aligned in a previous loop, otherwise mark as 'already equal';
						if(!isset($vertex1[2]) || (isset($vertex1[2]) && $vertex1[2]!='aligned')){
							$polygon1[$key1] = array($vertex1[0],$vertex1[1],$vertex1[2],'equal');
							$intEqualCount++;
						}
						// make vertex2 reference to vertex1
						$polygon2[$key2] =& $polygon1[$key1];
					}
				}
			}
		}
		// count polygon as checked
		$intPolygonCount++;
	}
	return array($intPolygonCount,$intVertexCount,$intEqualizedCount,$intEqualCount);
}


?>