<?php 




class VideoSource_YouTube
{
	function extractYouTubeID($youtubeURL)
	{
				
		$arr=$this->parse_query($youtubeURL);
	    return $arr['v'];
	}
	
	function getVideoData($videoid,$customimage,$customtitle,$customdescription, $video_showtitle_nav_or_active,$video_showdescription,$thumbnailcssstyle)
	{
			
		$theTitle='';
		$Description='';
		$theImage='';
						
							
		if($customimage!='')
			$theImage=$customimage;
		else
			$theImage=VideoSource_YouTube::getYouTubeImageURL($videoid,$thumbnailcssstyle);
							
		if($video_showtitle_nav_or_active or $video_showdescription)
		{
							
							
			if($customtitle!='' and $customdescription!='')
			{
				$theTitle=$customtitle;
				$Description=$customdescription;
			}
			else
			{
				$theTitle=VideoSource_YouTube::getYouTubeVideoTitleAndDescription($videoid,$Description);
								
				if($customtitle!='')
					$theTitle=$customtitle;

				if($customdescription!='')
					$Description=$customdescription;
			}

			if(!$video_showtitle_nav_or_active)
				$theTitle='';
								
			if(!$video_showdescription)
				$Description='';
							
			return array(
				'videosource'=>'youtube',
				'videoid'=>$videoid,
				'imageurl'=>$theImage,
				'title'=>$theTitle,
				'description'=>$Description
				);
		}
		else
			return array('videosource'=>'youtube', 'videoid'=>$videoid, 'imageurl'=>$theImage,'title'=>'','description'=>'');
							
									
		
	}
	
	function getYouTubeImageURL($videoid,$thumbnailcssstyle)
	{
		
		
		if($thumbnailcssstyle == null)
			return 'http://img.youtube.com/vi/'.$videoid.'/default.jpg';
		
		//get bigger image if size of the thumbnail set;
		
		$a=str_replace(' ','',$thumbnailcssstyle);
		if(strpos($a,'width:')===false and strpos($a,'height:')===false)
			return 'http://img.youtube.com/vi/'.$videoid.'/default.jpg';
		else
			return 'http://img.youtube.com/vi/'.$videoid.'/0.jpg';
		
	}
	
	function getYouTubeVideoTitleAndDescription($videoid,&$description)
	{
		if(phpversion()<5)
			return "Update to PHP 5+";
				
		if(!ini_get('allow_url_fopen'))
			return 'Set "allow_url_fopen=on" in PHP.ini file.';
				



			
			//$doc = new DOMDocument;
			//$doc->load($url);
			//$tplusd =$doc->getElementsByTagName("name")->item(0)->nodeValue;
			
	

		try{
		echo '<!-- ';
		$value=eval('
			$url = "http://gdata.youtube.com/feeds/api/videos/'.$videoid.'";			
			$doc = new DOMDocument;
			$doc->load($url);
			$tplusd =$doc->getElementsByTagName("title")->item(0)->nodeValue;
			$tplusd.="<!--and-->";
			$tplusd.=$doc->getElementsByTagName("description")->item(0)->nodeValue;
			return $tplusd;');
		echo ' --> ';
		
		
		}
		catch(Exception $e)
		{
			$description='cannot get youtibe video data';
			return 'cannot get youtibe video data';
		}
		
		$pair=explode('<!--and-->',$value);
		$description=$pair[1];
		return $pair[0];
	}
	
	function renderYouTubePlayer($options)
	{
		
		$settings=array();
		
		$settings[]=array('autoplay',(int)$options['autoplay']);
		
		$settings[]=array('hl','en');
		$settings[]=array('fs','1');
		$settings[]=array('showinfo',$options['showinfo']);
		$settings[]=array('iv_load_policy','3');
		$settings[]=array('rel',$options['relatedvideos']);
		$settings[]=array('loop',(int)$options['repeat']);
		$settings[]=array('border',(int)$options['border']);
		
		if($options['color1']!='')
			$settings[]=array('color1',$options['color1']);
			
		if($options['color2']!='')
			$settings[]=array('color2',$options['color2']);

		if($options['controls']!='')
		{
			$settings[]=array('controls',$options['controls']);
			if($options['controls']==0)
				$settings[]=array('version',3);
			
		}
		
		//echo '$options[controls]='.$options['controls'].'<br>';
		
		VideoSource_YouTube::ApplyYoutubeParameters($settings,$options['youtubeparams']);
		
		
		$settingline=VideoSource_YouTube::CreateParamLine($settings);
		
		
		$result='';
		
		if($options['playertype']==1)
		{
			//new player
			$result.='
			<iframe width="'.$options['width'].'" height="'.$options['height'].'" '
				.'src="http://www.youtube.com/embed/'.$options['videoid'].'?'.$settingline.'" '
				.'frameborder="'.(int)$options['border'].'" '
				.'allowfullscreen>'
			.'</iframe>';
		}
		else
		{
			//Old player
			$result.='
			<object width="'.$options['width'].'" height="'.$options['height'].'">'
				.'<param name="movie" value="http://www.youtube.com/v/'.$options['videoid'].'?'.$settingline.'"></param>'
				.'<param name="wmode" value="transparent">'
				.'<param name="allowFullScreen" value="'.($options['fullscreen'] ? 'true' : 'false').'"></param>'
				.'<param name="allowscriptaccess" value="always"></param>'
				.'<embed src="http://www.youtube.com/v/'.$options['videoid'].'?'.$settingline.'" '
					.'type="application/x-shockwave-flash" '
					.'allowscriptaccess="always" '
					.'wmode="transparent" '
					.'allowfullscreen="'.($options['fullscreen'] ? 'true' : 'false').'" '
					.'width="'.$options['width'].'" '
					.'height="'.$options['height'].'">'
				.'</embed>'
			.'</object>';
		}
		
		
		return $result;
	}
	
	function ApplyYoutubeParameters(&$settings,$youtubeparams)
	{
		if($youtubeparams=='')
			return;
		
		$a=str_replace("\n",'',$youtubeparams);
		$a=trim(str_replace("\r",'',$a));
		$l=explode(';',$a);
		
		foreach($l as $o)
		{
			if($o!='')
			{
				$pair=explode('=',$o);
				if(count($pair)==2)
				{
					$option=trim(strtolower($pair[0]));
			
					$found=false;
			
					for($i=0;$i<count($settings);$i++)
					{
				
						if($settings[$i][0]==$option)
						{
							$settings[$i][1]=$pair[1];
							$found=true;
							break;
						}
					}
				
					if(!$found)
						$settings[]=array($option,$pair[1]);
				}//if(count($pair)==2)
			}//if($o!='')
		}
		
	}
	
	function CreateParamLine(&$settings)
	{
		$a=array();
		
		foreach($settings as $s)
			$a[]=$s[0].'='.$s[1];

		return implode('&',$a);
	}

}


?>