<?php

/*
 * @version		$Id: videos.php 1.6 2011-09-09 $
 * @package		Joomla
 * @subpackage	hdwebplayer
 * @copyright   Copyright (C) 2011-2012 HD Webplayer
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class WebplayerModelVideos extends JModel {

	function __construct() {
		parent::__construct();
    }
	
	function save()
	{
	  $mainframe =  JFactory::getApplication();	
	  $session   = JFactory::getSession();
	  $user      =& JFactory::getUser();  
	  $row       =& JTable::getInstance('webplayervideos', 'Table');
	  $cid       =  JRequest::getVar( 'cid', array(0), '', 'array' );
      $id        =  $cid[0];
      $row->load($id);
	  
      if(!$row->bind(JRequest::get('post')))
	  {
		JError::raiseError(500, $row->getError() );
	  }
	  
	  if (!$row->id) {
        $row->ordering = $row->getNextOrder();
      }
	
	  if($row->type == 'General Upload')
	  {
	    jimport('joomla.filesystem.file');
		
		if(!JFolder::exists(WEBPLAYER_UPLOAD_BASE)) {
			JFolder::create(WEBPLAYER_UPLOAD_BASE);
		}
		
	  	$row->video   = $this->general_upload('uploadvideo');
		$row->hdvideo = $this->general_upload('uploadhdvideo');
	  	$row->preview = $this->general_upload('uploadpreview');
	  	$row->thumb   = $this->general_upload('uploadthumb');
	  }
	  
	  if($row->type == 'FFMPEG Upload')
	  {
	    jimport('joomla.filesystem.file');
		
		if(!JFolder::exists(WEBPLAYER_UPLOAD_BASE)) {
			JFolder::create(WEBPLAYER_UPLOAD_BASE);
		}
		
		$ffmpeg       = $this->ffmpeg_upload('uploadvideo');
		$row->video   = $ffmpeg['video'];
	  	$row->preview = $ffmpeg['preview'];
	  	$row->thumb   = $ffmpeg['thumb'];

	  }
	  
	  if($row->type == 'Youtube Videos')
	  {
	     $youtubeID = array(); 
		 preg_match('/http\:\/\/www\.youtube\.com\/watch\?v=([\w-]{11})/',$row->video,$youtubeID); 
         $row->thumb     = 'http://img.youtube.com/vi/'.$youtubeID[1].'/default.jpg';
		 $row->preview   = 'http://img.youtube.com/vi/'.$youtubeID[1].'/0.jpg';
	  }
	  
	  $row->user = (string) $user->get('username');
  
	  if(!$row->store()){
		JError::raiseError(500, $row->getError() );
	  }
	 
	  $task = JRequest::getCmd('task');
	  
	  // page redirect
	  $mainframe->redirect( $session->get('target') );
	  
	}
	
	function general_upload($filename)
	{

	  $file = JFile::makeSafe($_FILES[$filename]['name']);
	  $temp = $_FILES[$filename]['tmp_name'];
	  
      if($file != "") {
     	 if(JFile::upload($temp, WEBPLAYER_UPLOAD_BASE.$file)) {
		 	return WEBPLAYER_UPLOAD_BASEURL.$file;
		 } else {
		 	JError::raiseWarning(21, 'Error Occured While Uploading!');
			return false;
		 }
	  }	
		
	}
	
	function ffmpeg_upload($filename)
	{
	  $dat          = array();
	  $file         = JFile::makeSafe($_FILES[$filename]['name']);
	  $ext          = end(explode(".", $file));	  
	  $temp         = $_FILES[$filename]['tmp_name'];
	  
	  $inputFile    = WEBPLAYER_UPLOAD_BASE.$file;
      $content      = $this->RemoveExtension($file);
	  $outputFile   = WEBPLAYER_UPLOAD_BASE.$content.'.flv';
	  $outputThumb  = WEBPLAYER_UPLOAD_BASE.$content.'_thumb.jpg';
	  $outputPreview= WEBPLAYER_UPLOAD_BASE.$content.'_preview.jpg';

	  $exe          = $this->getexe();
	  $ffmpeg       = $exe[0]->ffmpeg;
	  $flvtool2     = $exe[0]->flvtool2;
	  
	  if(!file_exists(WEBPLAYER_UPLOAD_BASE.$file)) {
     	 if ( JFile::upload($temp, WEBPLAYER_UPLOAD_BASE.$file)) {
		   
		   	if($ext != '.flv') {
		   		$command  = $ffmpeg." -i ".$inputFile." -sameq ". $outputFile."  2>&1";
           		exec($command);
		   		unlink($inputFile);
			}

		   	$command      = $flvtool2 . " -U " . $outputFile;
           	exec($command);
			
			$command      = $ffmpeg." -ss 3 -i ".$outputFile." -f image2 -vframes 1 -s 114x74 ".$outputThumb;
           	exec($command);
			
			$command      = $ffmpeg." -ss 3 -i ".$outputFile." -f image2 -vframes 1 -s 320x240 ".$outputPreview;
           	exec($command);
			
			if(file_exists(WEBPLAYER_UPLOAD_BASE.$content.'.flv')) {
				$dat['video']     = WEBPLAYER_UPLOAD_BASEURL.$content.'.flv';
				$dat['thumb']     = WEBPLAYER_UPLOAD_BASEURL.$content.'_thumb.jpg';
				$dat['preview']   = WEBPLAYER_UPLOAD_BASEURL.$content.'_preview.jpg';
				return $dat;
			}
		   
      	  } else {
		 		JError::raiseWarning(21, 'Error Occured While Uploading!');
				return false;
		  } 
		 
		}	
		
	}
	
	function getexe()
    {
         $db     =& JFactory::getDBO();
         $query  = "SELECT ffmpeg, flvtool2 FROM #__webplayer_settings";
         $db->setQuery( $query );
         $output = $db->loadObjectList();
         return($output);
	}
		
	function RemoveExtension($strName)  
	{  
     	$ext = strrchr($strName, '.');  

     	if($ext !== false)  
     	{  
         	$strName = substr($strName, 0, -strlen($ext));  
     	}  
     	return $strName;  
	}
	
	function delete()
	{
	    $mainframe = JFactory::getApplication();
		$session   = JFactory::getSession();
		$uid       = JRequest::getCmd('uid');

        $db        =& JFactory::getDBO();
        $query     = "DELETE FROM #__webplayer_videos WHERE id=$uid";
        $db->setQuery( $query );
        $db->query();

        $mainframe->redirect( $session->get('target') );
	}
	 
	
}

?>