<?php

/*
 * @version		$Id: uninstall.webplayer.php 1.6 2011-09-09 $
 * @package		Joomla
 * @subpackage	hdwebplayer
 * @copyright   Copyright (C) 2011-2012 HD Webplayer
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

if( substr(JVERSION,0,3) == '1.6' || substr(JVERSION,0,3) == '1.7' ) {
    echo '<h2>'.JText::_('HD Webplayer Component UnInstalled').'</h2>';
	return;
}

jimport('joomla.installer.installer');

$status = new JObject();
$status->modules = array();
$status->plugins = array();

// -- UnInstall Modules
unInstallModules($status, 'mod_webplayer');
unInstallModules($status, 'mod_webplayersearch');

function unInstallModules($status, $mname) {
	$db = & JFactory::getDBO();
	$query = "SELECT `id` FROM `#__modules` WHERE module = ".$db->Quote($mname)."";
	$db->setQuery($query);
	$modules = $db->loadResultArray();
	if (count($modules)) {
		foreach ($modules as $module) {
			$installer = new JInstaller;
			$result = $installer->uninstall('module', $module);
		}
	}
	$status->modules[] = array('name'=>$mname,'client'=>'site', 'result'=>$result);
}

// -- UnInstall Plugin
$pname   = 'webplayer';
$db = & JFactory::getDBO();
$query   = 'SELECT `id` FROM #__plugins WHERE element = '.$db->Quote($pname);
$db->setQuery($query);
$plugins = $db->loadResultArray();
if (count($plugins)) {
	foreach ($plugins as $plugin) {
		$installer = new JInstaller;
		$result = $installer->uninstall('plugin', $plugin, 0);
	}
}
$status->plugins[] = array('name'=>$pname,'group'=>'content', 'result'=>$result);

?>
<?php $rows = 0;?>

<h2><?php echo JText::_('HD Webplayer UnInstallation Status'); ?></h2>
<table class="adminlist">
  <thead>
    <tr>
      <th class="title" colspan="2"><?php echo JText::_('Extension'); ?></th>
      <th width="30%"><?php echo JText::_('Status'); ?></th>
    </tr>
  </thead>
  <tfoot>
    <tr>
      <td colspan="3"></td>
    </tr>
  </tfoot>
  <tbody>
    <tr class="row0">
      <td class="key" colspan="2"><?php echo 'Webplayer '.JText::_('Component'); ?></td>
      <td><strong><?php echo JText::_('Removed'); ?></strong></td>
    </tr>
    <?php if (count($status->modules)) : ?>
    <tr>
      <th><?php echo JText::_('Module'); ?></th>
      <th><?php echo JText::_('Client'); ?></th>
      <th></th>
    </tr>
    <?php foreach ($status->modules as $module) : ?>
    <tr class="row<?php echo (++ $rows % 2); ?>">
      <td class="key"><?php echo $module['name']; ?></td>
      <td class="key"><?php echo ucfirst($module['client']); ?></td>
      <td><strong><?php echo ($module['result'])?JText::_('Removed'):JText::_('Not removed'); ?></strong></td>
    </tr>
    <?php endforeach;?>
    <?php endif;?>
    <?php if (count($status->plugins)) : ?>
    <tr>
      <th><?php echo JText::_('Plugin'); ?></th>
      <th><?php echo JText::_('Group'); ?></th>
      <th></th>
    </tr>
    <?php foreach ($status->plugins as $plugin) : ?>
    <tr class="row<?php echo (++ $rows % 2); ?>">
      <td class="key"><?php echo ucfirst($plugin['name']); ?></td>
      <td class="key"><?php echo ucfirst($plugin['group']); ?></td>
      <td><strong><?php echo ($plugin['result'])?JText::_('Removed'):JText::_('Not removed'); ?></strong></td>
    </tr>
    <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>