<?php

/*
 * @version		$Id: videos.php 1.6 2011-09-09 $
 * @package		Joomla
 * @subpackage	hdwebplayer
 * @copyright   Copyright (C) 2011-2012 HD Webplayer
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import Joomla! libraries
jimport('joomla.application.component.model');

class WebplayerModelVideos extends JModel {

    function __construct() {
		parent::__construct();
    }
	
	function getvideos()
    {
         $mainframe        = JFactory::getApplication();	
		 $option           = JRequest::getCmd('option');
		 $task             = JRequest::getCmd('task');
		 
		 $limit            = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		 $limitstart       = $mainframe->getUserStateFromRequest($option.$task.'.limitstart', 'limitstart', 0, 'int');
		 $filter_category  = $mainframe->getUserStateFromRequest($option.$task.'filter_category', 'filter_category', '', 'string');
		 $filter_state     = $mainframe->getUserStateFromRequest($option.$task.'filter_state', 'filter_state', -1, 'int');
		 $search           = $mainframe->getUserStateFromRequest($option.$task.'search', 'search', '', 'string');
		 $search           = JString::strtolower($search);
     
    	 $db               =& JFactory::getDBO();
		 $query            = "SELECT * FROM #__webplayer_videos";

		 $where            = array();
		 
		 if ($filter_state > - 1) {
			$where[]       = "published={$filter_state}";
		 }
		
		 if ( $search ) {
			$where[]       = 'LOWER(title) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		 }
		 
		 if ($filter_category && $filter_category != '- Select category -') {
		    $filter_category = ($filter_category == 'Uncategorised') ?  'none' : $filter_category; 
			$where[]         = 'category='.$db->Quote($filter_category);
		}
		 
		 $where 		   = ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );
		 
		 $query           .= $where;
		 $query           .= " ORDER BY category,ordering";
    	 $db->setQuery ( $query, $limitstart, $limit);
    	 $output           = $db->loadObjectList();
         return($output);
	}
	
	function gettotal()
    {
         $mainframe        = JFactory::getApplication();	
		 $option           = JRequest::getCmd('option');
		 $task             = JRequest::getCmd('task');
		 
		 $filter_category  = $mainframe->getUserStateFromRequest($option.$task.'filter_category', 'filter_category', '', 'string');
		 $filter_state     = $mainframe->getUserStateFromRequest($option.$task.'filter_state', 'filter_state', -1, 'int');
		 $search           = $mainframe->getUserStateFromRequest($option.$task.'search', 'search', '', 'string');
		 $search           = JString::strtolower($search);
     
    	 $db               =& JFactory::getDBO();
		 $query            = "SELECT COUNT(*) FROM #__webplayer_videos";

		 $where            = array();
		 
		 if ($filter_state > - 1) {
			$where[]       = "published={$filter_state}";
		 }
		
		 if ( $search ) {
			$where[]       = 'LOWER(title) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
		 }
		 
		 if ($filter_category && $filter_category != '- Select category -') {
		    $filter_category = ($filter_category == 'Uncategorised') ?  'none' : $filter_category; 
			$where[]         = 'category='.$db->Quote($filter_category);
		}
		 
		 $where 		   = ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );
		 
		 $query           .= $where;
    	 $db->setQuery ( $query );
    	 $output           = $db->loadResult();
         return($output);
	}
	
	function getpagination()
    {
		 $mainframe  = JFactory::getApplication();	
		 $option     = JRequest::getCmd('option');
		 $task       = JRequest::getCmd('task');
		 
		 $total      = $this->gettotal();
		 $limit      = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		 $limitstart = $mainframe->getUserStateFromRequest($option.$task.'.limitstart', 'limitstart', 0, 'int');
     
    	 jimport( 'joomla.html.pagination' );
		 $pageNav    = new JPagination($total, $limitstart, $limit);
         return($pageNav);
	}
	
	function getlists()
    {
		 $mainframe              = JFactory::getApplication();	
		 $option                 = JRequest::getCmd('option');
		 $task                   = JRequest::getCmd('task');
		 
		 $filter_category        = $mainframe->getUserStateFromRequest($option.$task.'filter_category', 'filter_category','', 'string');
		 $filter_state           = $mainframe->getUserStateFromRequest( $option.$task.'filter_state','filter_state',-1,'int' );
		 $search                 = $mainframe->getUserStateFromRequest($option.$task.'search','search','','string');
		 $search                 = JString::strtolower ( $search );
     
    	 $lists                  = array ();
		 $lists ['search']       = $search;
		 
		 $categories_options[]   = JHTML::_('select.option', '', JText::_('- Select category -'));
		 $categories_options[]   = JHTML::_('select.option','none', JText::_('Uncategorised'));
		 $categories             = $this->getcategory();
		 for ($i=0; $i < count( $categories ); $i++)
         {
           $categories_options[] = JHTML::_('select.option', $categories[$i]->id, $categories[$i]->name);
	     }
		 $lists['categories']    = JHTML::_('select.genericlist', $categories_options, 'filter_category', 'onchange="this.form.submit();"', 'text', 'text', $filter_category);
            
		 $filter_state_options[] = JHTML::_('select.option', -1, JText::_('- Select publishing state -'));
		 $filter_state_options[] = JHTML::_('select.option', 1, JText::_('Published'));
		 $filter_state_options[] = JHTML::_('select.option', 0, JText::_('Unpublished'));
		 $lists['state']         = JHTML::_('select.genericlist', $filter_state_options, 'filter_state', 'onchange="this.form.submit();"', 'value', 'text', $filter_state);
		 
         return($lists);
	}
	
	function getcategory()
    {
         $db     =& JFactory::getDBO();
         $query  = "SELECT * FROM #__webplayer_category WHERE published = 1";
         $db->setQuery( $query );
         $output = $db->loadObjectList();
         return($output);
	}
	
	function getapproval()
    {
         $db     =& JFactory::getDBO();
         $query  = "SELECT COUNT(*) FROM #__webplayer_videos WHERE published=0 AND user!='Admin'";
         $db->setQuery( $query );
         $output = $db->loadResult();
         return($output);
	}
	
	function getexe()
    {
         $db     =& JFactory::getDBO();
         $query  = "SELECT ffmpeg, flvtool2 FROM #__webplayer_settings";
         $db->setQuery( $query );
         $output = $db->loadObjectList();
         return($output);
	}
	
	function getrow()
    {
         $db  =& JFactory::getDBO();
         $row =& JTable::getInstance('webplayervideos', 'Table');
         $cid = JRequest::getVar( 'cid', array(0), '', 'array' );
         $id  = $cid[0];
         $row->load($id);
         $lists['published'] = JHTML::_('select.booleanlist','published',$row->published);

         return $row;
	}
	
	function save()
	{
	  $mainframe = JFactory::getApplication();	  
	  $row       =& JTable::getInstance('webplayervideos', 'Table');
	  $cid       = JRequest::getVar( 'cid', array(0), '', 'array' );
      $id        = $cid[0];
      $row->load($id);
	  
      if(!$row->bind(JRequest::get('post')))
	  {
		JError::raiseError(500, $row->getError() );
	  }
	  
	  if (!$row->id) {
        $row->ordering = 0;		
      }
	
	  if($row->type == 'General Upload')
	  {
	    jimport('joomla.filesystem.file');
		
		if(!JFolder::exists(WEBPLAYER_UPLOAD_BASE)) {
			JFolder::create(WEBPLAYER_UPLOAD_BASE);
		}
		
	  	$row->video   = $this->general_upload('uploadvideo');
		$row->hdvideo = $this->general_upload('uploadhdvideo');
	  	$row->preview = $this->general_upload('uploadpreview');
	  	$row->thumb   = $this->general_upload('uploadthumb');
	  }
	  
	  if($row->type == 'FFMPEG Upload')
	  {
	    jimport('joomla.filesystem.file');
		
		if(!JFolder::exists(WEBPLAYER_UPLOAD_BASE)) {
			JFolder::create(WEBPLAYER_UPLOAD_BASE);
		}
		
		$ffmpeg       = $this->ffmpeg_upload('uploadvideo');
		$row->video   = $ffmpeg['video'];
	  	$row->preview = $ffmpeg['preview'];
	  	$row->thumb   = $ffmpeg['thumb'];

	  }
	  
	  if($row->type == 'Youtube Videos')
	  {
	     $youtubeID = array(); 
		 preg_match('/http\:\/\/www\.youtube\.com\/watch\?v=([\w-]{11})/',$row->video,$youtubeID); 
         $row->thumb     = 'http://img.youtube.com/vi/'.$youtubeID[1].'/default.jpg';
		 $row->preview   = 'http://img.youtube.com/vi/'.$youtubeID[1].'/0.jpg';
	  }
  
	  if(!$row->store()){
		JError::raiseError(500, $row->getError() );
	  }
	 
	  $task = JRequest::getCmd('task');
	  
	  switch ($task)
      {
        case 'applyvideos':
             $msg  = 'Changes Saved';
             $link = 'index.php?option=com_webplayer&task=editvideos&'. JUtility::getToken() .'=1&'.'cid[]='.$row->id;
             break;
        case 'savevideos':
        default:
              $msg  = 'Saved';
              $link = 'index.php?option=com_webplayer&task=videos';
              break;
        }
	  // page redirect
	  $mainframe->redirect($link, $msg);
	  
	}
	
	function general_upload($filename)
	{

	  $file = JFile::makeSafe($_FILES[$filename]['name']);
	  $temp = $_FILES[$filename]['tmp_name'];
	  
      if($file != "") {
     	 if(JFile::upload($temp, WEBPLAYER_UPLOAD_BASE.$file)) {
		 	return WEBPLAYER_UPLOAD_BASEURL.$file;
		 } else {
		 	JError::raiseWarning(21, 'Error Occured While Uploading!');
			return false;
		 }
	  }	
		
	}
	
	function ffmpeg_upload($filename)
	{
	  $dat          = array();
	  $file         = JFile::makeSafe($_FILES[$filename]['name']);
	  $ext          = end(explode(".", $file));	  
	  $temp         = $_FILES[$filename]['tmp_name'];
	  
	  $inputFile    = WEBPLAYER_UPLOAD_BASE.$file;
      $content      = $this->RemoveExtension($file);
	  $outputFile   = WEBPLAYER_UPLOAD_BASE.$content.'.flv';
	  $outputThumb  = WEBPLAYER_UPLOAD_BASE.$content.'_thumb.jpg';
	  $outputPreview= WEBPLAYER_UPLOAD_BASE.$content.'_preview.jpg';

	  $exe          = $this->getexe();
	  $ffmpeg       = $exe[0]->ffmpeg;
	  $flvtool2     = $exe[0]->flvtool2;
	  
	  if(!file_exists(WEBPLAYER_UPLOAD_BASE.$file)) {
     	 if ( JFile::upload($temp, WEBPLAYER_UPLOAD_BASE.$file)) {
		   
		   	if($ext != '.flv') {
		   		$command  = $ffmpeg." -i ".$inputFile." -sameq ". $outputFile."  2>&1";
           		exec($command);
		   		unlink($inputFile);
			}

		   	$command      = $flvtool2 . " -U " . $outputFile;
           	exec($command);
			
			$command      = $ffmpeg." -ss 3 -i ".$outputFile." -f image2 -vframes 1 -s 114x74 ".$outputThumb;
           	exec($command);
			
			$command      = $ffmpeg." -ss 3 -i ".$outputFile." -f image2 -vframes 1 -s 320x240 ".$outputPreview;
           	exec($command);
			
			if(file_exists(WEBPLAYER_UPLOAD_BASE.$content.'.flv')) {
				$dat['video']     = WEBPLAYER_UPLOAD_BASEURL.$content.'.flv';
				$dat['thumb']     = WEBPLAYER_UPLOAD_BASEURL.$content.'_thumb.jpg';
				$dat['preview']   = WEBPLAYER_UPLOAD_BASEURL.$content.'_preview.jpg';
				return $dat;
			}
		   
      	  } else {
		 		JError::raiseWarning(21, 'Error Occured While Uploading!');
				return false;
		  } 
		 
		}	
		
	}
	
	function RemoveExtension($strName)  
	{  
     	$ext = strrchr($strName, '.');  

     	if($ext !== false)  
     	{  
         	$strName = substr($strName, 0, -strlen($ext));  
     	}  
     	return $strName;  
	} 

	function delete()
	{
	    $mainframe = JFactory::getApplication();
        $cid       = JRequest::getVar( 'cid', array(), '', 'array' );
        $db        =& JFactory::getDBO();
        $cids      = implode( ',', $cid );
        if(count($cid))
        {
            $query = "DELETE FROM #__webplayer_videos WHERE id IN ( $cids )";
            $db->setQuery( $query );
            if (!$db->query())
            {
                echo "<script> alert('".$db->getErrorMsg()."');window.history.go(-1); </script>\n";
            }
        }
        // page redirect
        $mainframe->redirect( 'index.php?option=com_webplayer&task=videos' );
	}
	
	function cancel()
	{
	  $mainframe = JFactory::getApplication();
	  $link      = 'index.php?option=com_webplayer&task=videos';
	  $mainframe->redirect($link);
	}
	
	function saveorder()
	{
		$mainframe  = JFactory::getApplication();

		// Initialize variables
		$db	        =& JFactory::getDBO();
		$cid        = JRequest::getVar( 'cid', array(0), '', 'array' );
		$total      = count( $cid );
		$order      = JRequest::getVar( 'order', array(0), '', 'array' );
		JArrayHelper::toInteger($order, array(0));
		 
		$row        =& JTable::getInstance('webplayervideos', 'Table');
		$groupings  = array();
		// update ordering values
		for( $i=0; $i < $total; $i++ ) {
			$row->load( (int) $cid[$i] );
			$groupings[] = $row->category;
 			if ($row->ordering != $order[$i]) {
				$row->ordering  = $order[$i];
				if (!$row->store()) {
					JError::raiseError(500, $db->getErrorMsg() );
				}
			}
		}
 
		$groupings = array_unique($groupings);
		foreach ($groupings as $group) {
			$row->reorder('category = "'.$group.'"');
		}
 
		$mainframe->redirect('index.php?option=com_webplayer&task=videos', 'New ordering saved');
	}
	
	function move($direction)
	{
		$mainframe  = JFactory::getApplication();
		$cid        = JRequest::getVar( 'cid', array(0), '', 'array' );
		$row        = & JTable::getInstance('webplayervideos', 'Table');
		$row->load($cid[0]);
		$row->move($direction, 'category = "'.$row->category.'"');
		$row->reorder('category = "'.$row->category.'"');
	  	$mainframe->redirect('index.php?option=com_webplayer&task=videos', 'New ordering saved');		
	}

}

?>