<?php
/**
* @version:	2.0.0-beta7-74 - 2011 March 09 20:53:08 +0300
* @package:	jbetolo
* @subpackage:	jbetolo
* @copyright:	Copyright (C) 2010 - 2011 jproven.com. All rights reserved. 
* @license:	GNU General Public License Version 2, or later http://www.gnu.org/licenses/gpl.html
*/

/**
 * Original install.php file
 * @package   Zoo Component
 * @author    YOOtheme http://www.yootheme.com
 * @copyright Copyright (C) 2007 - 2009 YOOtheme GmbH
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

$error = false;
$extensions = array();

$this->parent->getDBO =& $this->parent->getDBO();

// additional extensions
$j16 = version_compare(JVERSION, '1.6.0', 'ge');

if ($j16) {
        $add = $this->manifest->xpath('additional');
        if ($add) $add = $add[0];
} else {
        $add = $this->manifest->getElementByPath('additional');
}

if ((is_a($add, 'JSimpleXMLElement') || is_a($add, 'JXMLElement')) && count($add->children())) {
        $exts =& $add->children();
        foreach ($exts as $ext) {
                $extensions[] = array(
                        'name' => $ext->data(),
                        'type' => $ext->name(),
                        'folder' => $this->parent->getPath('source').'/'.attr($ext, 'folder', $j16),
                        'installer' => new JInstaller(),
                        'status' => false
                );
        }
}

// install additional extensions
for ($i = 0; $i < count($extensions); $i++) {
        $extension =& $extensions[$i];
        
        if ($extension['installer']->install($extension['folder'])) {
                $extension['status'] = true;
        } else {
                $error = true;
                break;
        }
}

// rollback on installation errors
if ($error) {
        $this->parent->abort(JText::_('Component').' '.JText::_('Install').': '.JText::_('Error'), 'component');
        for ($i = 0; $i < count($extensions); $i++) {
                if ($extensions[$i]['status']) {
                        $extensions[$i]['installer']->abort(JText::_($extensions[$i]['type']).' '.JText::_('Install').': '.JText::_('Error'), $extensions[$i]['type']);
                        $extensions[$i]['status'] = false;
                }
        }
} else {
        // jbetolo specific tasks
        
        require_once JPATH_SITE . '/plugins/system/' . ($j16 ? 'jbetolo/' : '').'jbetolo.php';
        
        // clean ev. earlier created jbetolo cache
        jbetoloHelper::resetCache();

        // if any default setting is given in metadata file of the plugin preload those settings
        jbetoloHelper::loadDefaultPredefinedSetting();

        // try reorder jbetolo to appear right before the system/cache plugin
        $db = JFactory::getDBO();

        if ($j16) {
                $query = "SELECT ordering, (SELECT extension_id FROM #__extensions WHERE type = 'plugin' AND folder = 'system' AND element = 'jbetolo' LIMIT 1) AS jbetolo FROM #__extensions WHERE type = 'plugin' AND folder = 'system' AND element = 'cache' LIMIT 1";
        } else {
                $query = "SELECT ordering, (SELECT id FROM #__plugins WHERE folder = 'system' AND element = 'jbetolo' LIMIT 1) AS jbetolo FROM #__plugins WHERE folder = 'system' AND element = 'cache' LIMIT 1";
        }

        $db->setQuery($query);
        $rec = $db->loadObject();

        if ($rec && $rec->ordering) {
                $ord = $rec->ordering - 1;
                $row = JTable::getInstance($j16 ? 'extension' : 'plugin');
                $row->load($rec->jbetolo);
                $row->ordering = $ord;
                $row->store();
        }
}

function attr($ext, $name, $j16) {
        return $j16 ? $ext->getAttribute($name) : $ext->attributes($name);
}

?>

<h3><?php echo JText::_('Extensions'); ?></h3>
<table class="adminlist">
	<thead>
		<tr>
			<th class="title"><?php echo JText::_('Extension'); ?></th>
			<th width="60%"><?php echo JText::_('Status'); ?></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
	</tfoot>
	<tbody>
		<?php foreach ($extensions as $i => $ext) : ?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="key"><?php echo $ext['name']; ?> (<?php echo JText::_($ext['type']); ?>)</td>
				<td>
					<?php $style = $ext['status'] ? 'font-weight: bold; color: green;' : 'font-weight: bold; color: red;'; ?>
					<span style="<?php echo $style; ?>"><?php echo $ext['status'] ? JText::_('Installed successfully') : JText::_('NOT Installed'); ?></span>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>