<?php
/**
* @version:	2.0.0-beta7-74 - 2011 March 09 20:53:08 +0300
* @package:	jbetolo
* @subpackage:	jbetolo
* @copyright:	Copyright (C) 2010 - 2011 jproven.com. All rights reserved. 
* @license:	GNU General Public License Version 2, or later http://www.gnu.org/licenses/gpl.html
*/

defined('_JEXEC') or die('Restricted access');

class jbetoloComponentHelper {
        private static $contentTypes = array('css' => 'text/css', 'js' => 'text/javascript', 'font' => 'text/plain');
        
        private static function gzdecode($file){
                if (!is_file($file)) return '';

                if (function_exists('gzdecode')) {
                        return gzdecode($file);
                }

                ob_start();
                readgzfile($file);
                $content = ob_get_clean();

                return $content;
        }

        private static function gmdateStr($time = null) {
                if (is_null($time)) $time = time();
                
                return gmdate("D, d M Y H:i:s", $time) . " GMT";
        }

        private static function doSendFile($type, $cache_file, $is_gz, $age) {
                $m_time = jbetoloComponentHelper::gmdateStr(filemtime($cache_file));
                
                $document = JFactory::getDocument();
                
                header("Content-type: ".jbetoloComponentHelper::$contentTypes[$type]."; charset: " . $document->getCharset());

                if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) && $_SERVER['HTTP_IF_MODIFIED_SINCE'] == $m_time) {
                        header('Content-Length: 0');
                        header("HTTP/1.0 304 Not Modified");
                        return;
                }

                jimport('joomla.plugin.plugin');
                JPluginHelper::importPlugin('system', 'jbetolo');
                
                $t_age = jbetoloComponentHelper::gmdateStr(time() + $age);

                if ($is_gz) {
                        header("Content-Encoding: gzip");
                }

                header('Last-Modified: ' . jbetoloComponentHelper::gmdateStr(filemtime($cache_file)));
                header('Content-Length: ' . filesize($cache_file));
                header('Cache-Control: must-revalidate, max-age=' . $age);
                header('Cache-Control: Public');
                header('Vary: Accept-Encoding');
                header('Expires: ' . $t_age);

                if (!$is_gz && JBETOLO_IS_GZ) {
                        $content = jbetoloComponentHelper::gzdecode($cache_file);
                } else {
                        $content = file_get_contents($cache_file);
                }

                die($content);
        }

        public static function sendFile($type, $file_name) {
                (isset($file_name) && $file_name != '') || die('jbetolo: sendFile: no file to send.');

                if ($type != 'htaccess') {
                        jimport('joomla.plugin.plugin');
                        JPluginHelper::importPlugin('system', 'jbetolo');

                        $is_gz = JRequest::getBool('gz', false);
                        $is_minify = JRequest::getBool('min', false);
                        $to_file = JBETOLO_CACHE_DIR . $file_name;
                        $age = JRequest::getInt('ag', plgSystemJBetolo::param('cache-age'));
                } else {
                        list($is_gz, $age, $type, $file_name) = explode('_', $file_name);
                        $to_file = JBETOLO_CACHE_DIR . $file_name;
                        $is_gz = (bool) $is_gz;
                }

                if (file_exists($to_file)) {
                        jbetoloComponentHelper::doSendFile($type, $to_file, $is_gz, $age);
                } else {
                        die('Restricted access');
                }
        }

        public static function isJ16() {
                return version_compare(JVERSION, '1.6.0', 'ge');
        }

        public static function pluginLocation() {
                return JPATH_PLUGINS.'/system/'.(jbetoloComponentHelper::isJ16()?'jbetolo/':'').'jbetolo.php';
        }

        private static function settingAllowed() {
                $app = JFactory::getApplication();
                
                if ($app->getName() == 'administrator') return true;

                JError::raiseError(403, JText::_("ALERTNOTAUTH"));
        }

        public static function resetCache() {
                jbetoloComponentHelper::settingAllowed();

                require_once jbetoloComponentHelper::pluginLocation();
                return jbetoloHelper::resetCache(JRequest::getCmd('app', 'all'));
        }

        public static function resetSetting() {
                jbetoloComponentHelper::settingAllowed();
                
                require_once jbetoloComponentHelper::pluginLocation();
                
                return jbetoloHelper::resetSetting(JRequest::getCmd('setting', ''));
        }

        public static function saveSetting() {
                jbetoloComponentHelper::settingAllowed();
                
                $name = JRequest::getString('name');
                $setting = JRequest::getString('settings');
                
                require_once jbetoloComponentHelper::pluginLocation();
                
                return jbetoloHelper::saveSetting($name, $setting);
        }

        public static function smushIt() {
                jbetoloComponentHelper::settingAllowed();

                $dir = JRequest::getString('dir');
                $replace = JRequest::getString('replace');
                $recursive = JRequest::getString('recursive');
                $fix = JRequest::getString('fix', '_smushed');

                require_once jbetoloComponentHelper::pluginLocation();

                return jbetoloHelper::smushItDirectory($dir, $recursive == 'recursive', $replace == 'replace', $fix);
        }
}
?>
