<?php
/**
* @package   Omegatheme Template
* @version   1.5.0 April 2011
* @author    services@omegatheme.com
* @copyright Copyright (C) 2011 Omegatheme http://omegatheme.com
*/
defined('_JEXEC') or die('Restricted access');

if ( ! defined('modMainMenuXMLCallbackDefined') )
{
function modMainMenuXMLCallback(&$node, $args)
{
	$user	= &JFactory::getUser();
	$menu	= &JSite::getMenu();
	$active	= $menu->getActive();
	$path	= isset($active) ? array_reverse($active->tree) : null;

	if (($args['end']) && ($node->attributes('level') >= $args['end']))
	{
		$children = $node->children();
		foreach ($node->children() as $child)
		{
			if ($child->name() == 'ul') {
				$node->removeChild($child);
			}
		}
	}

	if ($node->name() == 'ul') {
		foreach ($node->children() as $child)
		{
			if ($child->attributes('access') > $user->get('aid', 0)) {
				$node->removeChild($child);
			}
		}
	}

	if (($node->name() == 'li') && isset($node->ul)) {
		$node->addAttribute('class', 'parent');
	}

	if (isset($path) && (in_array($node->attributes('id'), $path) || in_array($node->attributes('rel'), $path)))
	{
		if ($node->attributes('class')) {
			$node->addAttribute('class', $node->attributes('class').' active');
		} else {
			$node->addAttribute('class', 'active');
		}
	}
	else
	{
		if (isset($args['children']) && !$args['children'])
		{
			$children = $node->children();
			foreach ($node->children() as $child)
			{
				if ($child->name() == 'ul') {
					$node->removeChild($child);
				}
			}
		}
	}

	//Hack main menu
	if ($node->name() == 'ul') {
		
		// set order/first/last for li
		$count = count($node->children());
		foreach ($node->children() as $i => $child) {
			if ($i == 0) $child->addAttribute('first', 1);
			if ($i == $count - 1) $child->addAttribute('last', 1);
			//$child->addAttribute('order', $i + 1);
		}
	}

	if (($node->name() == 'li') && ($id = $node->attributes('id'))) {
		if ($node->attributes('class')) {
			$node->addAttribute('class', $node->attributes('class').' item'.$id);
		} else {
			$node->addAttribute('class', 'item'.$id);
		}
	}

	if (isset($path) && $node->attributes('id') == $path[0]) {
		$node->addAttribute('id', 'current');
	} else {
		$node->removeAttribute('id');
	}
	if ($node->name() == 'li') {
	
		$item        = $menu->getItem($node->attributes('id'));
		$level       = $node->attributes('level');
		$css         = 'level' . $level . '' . $node->attributes('order');
		$span_css    = '';
	
		if ($node->attributes('first')) $css .= ' first';
		if ($node->attributes('last')) $css .= ' last';
		if (isset($node->ul) && ($args['end'] == 0 || $node->attributes('level') < $args['end'])) $css .= ' parent';
		if (isset($path) && in_array($node->attributes('id'), $path)) $css .= ' active';
		if (isset($path) && $node->attributes('id') == $path[0]) $css .= ' current';
		//if ($item->type == 'separator') $css .= ' separator';
		
		// add a/span css classes
		if (isset($node->_children[0])) {
			$node->_children[0]->attributes('class') ? $node->_children[0]->addAttribute('class', $node->_children[0]->attributes('class') . ' ' . $css) : $node->_children[0]->addAttribute('class', $css);
		}
		
		// add item css classes
		$node->attributes('class') ? $node->addAttribute('class', $node->attributes('class') . ' ' . $css) : $node->addAttribute('class', $css);
	
		// add span css and subtitle span
		if (isset($node->_children[0]) && isset($node->_children[0]->span[0])) {
			$node->_children[0]->span[0]->addAttribute('class', 'bg '.$span_css);
			$title = $node->_children[0]->span[0];
			$split = explode('||', $title->data(), 2);
			if (count($split) == 2) {
				$span =& $node->_children[0]->span[0]->addChild('span', array('class' => 'title'));
				$span->setData(trim($split[0]));
				$span =& $node->_children[0]->span[0]->addChild('span', array('class' => 'subtitle'));
				$span->setData(trim($split[1]));
			}
		}
	}
	$node->removeAttribute('rel');
	$node->removeAttribute('level');
	$node->removeAttribute('access');
	$node->removeAttribute('first');
	$node->removeAttribute('last');
}
	define('modMainMenuXMLCallbackDefined', true);
}
modMainMenuHelper::render($params, 'modMainMenuXMLCallback');